/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects;

import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.ISearchParameters;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.testutils.utils.pageobjects.InShellPageObject;
import org.eclipse.platform.discovery.ui.api.IAdvancedSearchParamsUiContributor;
import org.eclipse.platform.discovery.ui.api.IViewUiContext;
import org.eclipse.platform.discovery.ui.internal.search.advancedparams.AdvancedSearchParamsDisplayer;
import org.eclipse.platform.discovery.ui.internal.xp.IAdvancedSearchParamsUiContribXpParser;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot.SWTBotSection;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot.SwtBotUtils;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;
import org.eclipse.platform.discovery.util.internal.property.IPropertyAttributeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.BoolResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.hamcrest.Matcher;

public class AdvancedSearchParamsPageObject<T extends Control>
extends InShellPageObject {
    private final ISearchProviderConfiguration searchProviderConfiguration;
    private final IAdvancedSearchParamsUiContribXpParser xpParser;
    private final SwtBotUtils botUtils;
    private final Matcher<T> widgetMatcher;
    private Composite parameterComposite;
    private AdvancedSearchParamsDisplayer displayer;

    public AdvancedSearchParamsPageObject(ISearchProviderConfiguration searchProviderConfiguration, IAdvancedSearchParamsUiContribXpParser xpParser, Matcher<T> widgetMatcher) {
        this.searchProviderConfiguration = searchProviderConfiguration;
        this.xpParser = xpParser;
        this.botUtils = new SwtBotUtils();
        this.widgetMatcher = widgetMatcher;
    }

    protected void createContent(Shell parentShell, FormToolkit formToolkit) {
        Composite parentComposite = new Composite((Composite)parentShell, 0);
        parentComposite.setLayout((Layout)new FillLayout());
        this.displayer = new AdvancedSearchParamsDisplayer(parentComposite, formToolkit){

            protected ISearchProviderConfiguration searchProviderConfiguration() {
                return AdvancedSearchParamsPageObject.this.searchProviderConfiguration;
            }

            protected Composite createParametersContainingComposite(Composite parent) {
                AdvancedSearchParamsPageObject.this.parameterComposite = super.createParametersContainingComposite(parent);
                return AdvancedSearchParamsPageObject.this.parameterComposite;
            }

            protected IAdvancedSearchParamsUiContribXpParser createAdvancedSearchUiContribXpParser() {
                return AdvancedSearchParamsPageObject.this.xpParser;
            }
        };
    }

    public void registerSizePropertyChangeListener(IPropertyAttributeListener<Point> listener, boolean notifyCurrent) {
        this.displayer.registerSizePropertyChangeListener(listener, notifyCurrent);
    }

    public IAdvancedSearchParamsUiContributor getUiContributor() {
        return this.displayer.getUiContributor();
    }

    public void setSearchParameters(ISearchParameters searchParams) {
        this.displayer.setParams(searchParams);
    }

    public void setInput(final IObjectTypeDescription objectType, final ISearchDestination destination, final IDiscoveryEnvironment environment, final IViewUiContext viewUiContext) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                AdvancedSearchParamsPageObject.this.displayer.update(objectType, destination, environment, viewUiContext);
            }
        });
    }

    public Composite getParametersComposite() {
        return this.parameterComposite;
    }

    public Composite getParametersCompositeParent() {
        return (Composite)UIThreadRunnable.syncExec((Result)new Result<Composite>(){

            public Composite run() {
                return AdvancedSearchParamsPageObject.this.getParametersComposite().getParent();
            }
        });
    }

    public boolean isCustomUiAvailable() {
        try {
            final Control customUi = (Control)this.botUtils.findOneChildControl(this.shell().widget, this.widgetMatcher, true);
            return (Boolean)UIThreadRunnable.syncExec((Result)new BoolResult(){

                public Boolean run() {
                    return customUi.isVisible();
                }
            });
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            return false;
        }
    }

    public String getSectionTitle() {
        return this.findSection().getText();
    }

    public boolean isSectionVisible() {
        try {
            this.findSection();
            return true;
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            return false;
        }
    }

    public void hideCustomUi() {
        this.findSection().collapse();
    }

    public void showCustomUi() {
        this.findSection().expand();
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void setParams(ISearchParameters searchParams) {
        this.displayer.setParams(searchParams);
    }

    private SWTBotSection findSection() {
        return new SWTBotSection(this.botUtils.findOneChildControlOfExactType(this.shell().widget, Section.class, true));
    }

    private void setEnabled(final boolean enabled) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                AdvancedSearchParamsPageObject.this.displayer.setEnabled(enabled);
            }
        });
    }
}

