/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.internal.resources.semantic.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.QualifiedName;

public class Util {
    private Util() {
    }

    public static void assertQualifiedNameValid(QualifiedName name) {
        Assert.isLegal((name.getQualifier().indexOf(94) == -1 ? 1 : 0) != 0, (String)Messages.Util_QualifierNoCirconflex_XMSG);
        Assert.isLegal((name.getLocalName().indexOf(94) == -1 ? 1 : 0) != 0, (String)Messages.Util_LocalNameNoCirconflex_XMSG);
    }

    public static String qualifiedNameToString(QualifiedName name) {
        StringBuilder sb = new StringBuilder(50);
        sb.append(name.getQualifier());
        sb.append('^');
        sb.append(name.getLocalName());
        return sb.toString();
    }

    public static void safeClose(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void safeClose(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {}
    }
}

