/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.IBinding;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.core.di.suppliers.PrimaryObjectSupplier;
import org.eclipse.e4.core.internal.di.Binding;
import org.eclipse.e4.core.internal.di.ClassRequestor;
import org.eclipse.e4.core.internal.di.ConstructorRequestor;
import org.eclipse.e4.core.internal.di.FieldRequestor;
import org.eclipse.e4.core.internal.di.MethodRequestor;
import org.eclipse.e4.core.internal.di.ObjectDescriptor;
import org.eclipse.e4.core.internal.di.ProviderImpl;
import org.eclipse.e4.core.internal.di.Requestor;
import org.eclipse.e4.core.internal.di.osgi.ProviderHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectorImpl
implements IInjector {
    private static final String JAVA_OBJECT = "java.lang.Object";
    private Map<PrimaryObjectSupplier, List<WeakReference<?>>> injectedObjects = new HashMap();
    private Set<WeakReference<Class<?>>> injectedClasses = new HashSet();
    private HashMap<Class<?>, Object> singletonCache = new HashMap();
    private Map<Class<?>, Set<Binding>> bindings = new HashMap();

    @Override
    public void inject(Object object, PrimaryObjectSupplier objectSupplier) {
        ArrayList<Requestor> requestors = new ArrayList<Requestor>();
        this.processClassHierarchy(object, objectSupplier, false, true, true, requestors);
        boolean haveLink = false;
        for (Requestor requestor : requestors) {
            if (!requestor.shouldTrack()) continue;
            haveLink = true;
        }
        if (!haveLink) {
            requestors.add(new ClassRequestor(object.getClass(), (IInjector)this, objectSupplier, object, true));
        }
        this.resolveRequestorArgs(requestors, objectSupplier, false, true);
        for (Requestor requestor : requestors) {
            if (!requestor.isResolved()) continue;
            requestor.execute();
        }
        this.rememberInjectedObject(object, objectSupplier);
        this.processAnnotated(PostConstruct.class, object, object.getClass(), objectSupplier, new ArrayList(5));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rememberInjectedObject(Object object, PrimaryObjectSupplier objectSupplier) {
        Map<PrimaryObjectSupplier, List<WeakReference<?>>> map = this.injectedObjects;
        synchronized (map) {
            List<Object> list;
            if (!this.injectedObjects.containsKey(objectSupplier)) {
                list = new ArrayList();
                this.injectedObjects.put(objectSupplier, list);
            } else {
                list = this.injectedObjects.get(objectSupplier);
            }
            for (WeakReference weakReference : list) {
                if (object != weakReference.get()) continue;
                return;
            }
            list.add(new WeakReference<Object>(object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean forgetInjectedObject(Object object, PrimaryObjectSupplier objectSupplier) {
        Map<PrimaryObjectSupplier, List<WeakReference<?>>> map = this.injectedObjects;
        synchronized (map) {
            block7: {
                block6: {
                    if (this.injectedObjects.containsKey(objectSupplier)) break block6;
                    return false;
                }
                List<WeakReference<?>> list = this.injectedObjects.get(objectSupplier);
                Iterator<WeakReference<?>> i = list.iterator();
                if (!i.hasNext()) break block7;
                WeakReference<?> ref = i.next();
                if (object == ref.get()) {
                    i.remove();
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WeakReference<?>> forgetSupplier(PrimaryObjectSupplier objectSupplier) {
        Map<PrimaryObjectSupplier, List<WeakReference<?>>> map = this.injectedObjects;
        synchronized (map) {
            block4: {
                if (this.injectedObjects.containsKey(objectSupplier)) break block4;
                return null;
            }
            return this.injectedObjects.remove(objectSupplier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WeakReference<?>> getSupplierObjects(PrimaryObjectSupplier objectSupplier) {
        Map<PrimaryObjectSupplier, List<WeakReference<?>>> map = this.injectedObjects;
        synchronized (map) {
            block4: {
                if (this.injectedObjects.containsKey(objectSupplier)) break block4;
                return null;
            }
            return this.injectedObjects.get(objectSupplier);
        }
    }

    @Override
    public void uninject(Object object, PrimaryObjectSupplier objectSupplier) {
        if (!this.forgetInjectedObject(object, objectSupplier)) {
            return;
        }
        ArrayList<Requestor> requestors = new ArrayList<Requestor>();
        this.processClassHierarchy(object, objectSupplier, false, true, false, requestors);
        this.resolveRequestorArgs(requestors, null, true, false);
        for (Requestor requestor : requestors) {
            requestor.execute();
        }
    }

    @Override
    public Object invoke(Object object, Class<? extends Annotation> qualifier, PrimaryObjectSupplier objectSupplier) {
        Object result = this.invokeUsingClass(object, object.getClass(), qualifier, IInjector.NOT_A_VALUE, objectSupplier, true);
        if (result == IInjector.NOT_A_VALUE) {
            throw new InjectionException("Unable to find matching method to invoke");
        }
        return result;
    }

    @Override
    public Object invoke(Object object, Class<? extends Annotation> qualifier, Object defaultValue, PrimaryObjectSupplier objectSupplier) {
        return this.invokeUsingClass(object, object.getClass(), qualifier, defaultValue, objectSupplier, false);
    }

    private Object invokeUsingClass(Object userObject, Class<?> currentClass, Class<? extends Annotation> qualifier, Object defaultValue, PrimaryObjectSupplier objectSupplier, boolean throwUnresolved) {
        Method[] methods = currentClass.getDeclaredMethods();
        int j = 0;
        while (j < methods.length) {
            Method method = methods[j];
            if (method.getAnnotation(qualifier) != null) {
                MethodRequestor requestor = new MethodRequestor(method, (IInjector)this, objectSupplier, userObject, false);
                Object[] actualArgs = this.resolveArgs(requestor, objectSupplier, false, false);
                int unresolved = this.unresolved(actualArgs);
                if (unresolved != -1) {
                    if (throwUnresolved) {
                        this.reportUnresolvedArgument(requestor, unresolved);
                    }
                } else {
                    requestor.setResolvedArgs(actualArgs);
                    return requestor.execute();
                }
            }
            ++j;
        }
        Class<?> superClass = currentClass.getSuperclass();
        if (superClass == null) {
            return defaultValue;
        }
        return this.invokeUsingClass(userObject, superClass, qualifier, defaultValue, objectSupplier, throwUnresolved);
    }

    @Override
    public <T> T make(Class<T> clazz, PrimaryObjectSupplier objectSupplier) {
        ObjectDescriptor descriptor = new ObjectDescriptor(clazz, null);
        Binding binding = this.findBinding(descriptor);
        Class<?> implementationClass = binding == null ? this.getDesiredClass(descriptor.getDesiredType()) : binding.getImplementationClass();
        return clazz.cast(this.internalMake(implementationClass, objectSupplier));
    }

    public Object makeFromProvider(IObjectDescriptor descriptor, PrimaryObjectSupplier objectSupplier) {
        ObjectDescriptor actualClass;
        Object[] result;
        Binding binding = this.findBinding(descriptor);
        Class<?> implementationClass = binding == null ? this.getProviderType(descriptor.getDesiredType()) : binding.getImplementationClass();
        if (objectSupplier != null && (result = objectSupplier.get(new IObjectDescriptor[]{actualClass = new ObjectDescriptor(implementationClass, null)}, null, false, false))[0] != IInjector.NOT_A_VALUE) {
            return result[0];
        }
        return this.internalMake(implementationClass, objectSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object internalMake(Class<?> clazz, PrimaryObjectSupplier objectSupplier) {
        boolean isSingleton = clazz.isAnnotationPresent(Singleton.class);
        if (isSingleton) {
            HashMap<Class<?>, Object> hashMap = this.singletonCache;
            synchronized (hashMap) {
                if (this.singletonCache.containsKey(clazz)) {
                    return this.singletonCache.get(clazz);
                }
            }
        }
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        ArrayList<Constructor> sortedConstructors = new ArrayList<Constructor>(constructors.length);
        Constructor<?>[] constructorArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor constructor = constructorArray[n2];
            sortedConstructors.add(constructor);
            ++n2;
        }
        Collections.sort(sortedConstructors, new Comparator<Constructor<?>>(){

            @Override
            public int compare(Constructor<?> c1, Constructor<?> c2) {
                int l1 = c1.getParameterTypes().length;
                int l2 = c2.getParameterTypes().length;
                return l2 - l1;
            }
        });
        for (Constructor constructor : sortedConstructors) {
            ConstructorRequestor requestor;
            Object[] actualArgs;
            int modifiers = constructor.getModifiers();
            if ((modifiers & 2) != 0 || (modifiers & 4) != 0 || !constructor.isAnnotationPresent(Inject.class) && constructor.getParameterTypes().length != 0 || this.unresolved(actualArgs = this.resolveArgs(requestor = new ConstructorRequestor(constructor, this, objectSupplier), objectSupplier, false, false)) != -1) continue;
            requestor.setResolvedArgs(actualArgs);
            Object newInstance = requestor.execute();
            if (newInstance == null) continue;
            this.inject(newInstance, objectSupplier);
            if (isSingleton) {
                HashMap<Class<?>, Object> hashMap = this.singletonCache;
                synchronized (hashMap) {
                    this.singletonCache.put(clazz, newInstance);
                }
            }
            return newInstance;
        }
        throw new InjectionException("Could not find satisfiable constructor in " + clazz.getName());
    }

    public void resolveArguments(IRequestor requestor) {
        ArrayList<Requestor> list = new ArrayList<Requestor>(1);
        list.add((Requestor)requestor);
        this.resolveRequestorArgs(list, ((Requestor)requestor).getPrimarySupplier(), true, false);
    }

    public void disposed(PrimaryObjectSupplier objectSupplier) {
        List<WeakReference<?>> references = this.getSupplierObjects(objectSupplier);
        if (references == null) {
            return;
        }
        Object[] objects = new Object[references.size()];
        int count = 0;
        for (WeakReference<?> ref : references) {
            Object object = ref.get();
            if (object == null) continue;
            objects[count] = object;
            ++count;
        }
        int i = 0;
        while (i < count) {
            this.processAnnotated(PreDestroy.class, objects[i], objects[i].getClass(), objectSupplier, new ArrayList(5));
            if (objects[i] instanceof IDisposable) {
                ((IDisposable)objects[i]).dispose();
            }
            this.uninject(objects[i], objectSupplier);
            ++i;
        }
        this.forgetSupplier(objectSupplier);
    }

    private void resolveRequestorArgs(ArrayList<Requestor> requestors, PrimaryObjectSupplier objectSupplier, boolean fillNulls, boolean track) {
        for (Requestor requestor : requestors) {
            Object[] actualArgs = this.resolveArgs(requestor, objectSupplier, fillNulls, track);
            int unresolved = this.unresolved(actualArgs);
            if (unresolved == -1) {
                requestor.setResolvedArgs(actualArgs);
                continue;
            }
            if (requestor.isOptional()) {
                requestor.setResolvedArgs(null);
                continue;
            }
            this.reportUnresolvedArgument(requestor, unresolved);
        }
    }

    private void reportUnresolvedArgument(Requestor requestor, int argIndex) {
        StringBuffer tmp = new StringBuffer();
        tmp.append("Unable to process \"");
        tmp.append(requestor.toString());
        tmp.append("\": no actual value was found for the argument \"");
        tmp.append(requestor.getDependentObjects()[argIndex].toString());
        tmp.append("\".");
        throw new InjectionException(tmp.toString());
    }

    private Object[] resolveArgs(Requestor requestor, PrimaryObjectSupplier objectSupplier, boolean fillNulls, boolean track) {
        IObjectDescriptor[] descriptors = requestor.getDependentObjects();
        Object[] actualArgs = new Object[descriptors.length];
        int i = 0;
        while (i < actualArgs.length) {
            actualArgs[i] = NOT_A_VALUE;
            ++i;
        }
        i = 0;
        while (i < actualArgs.length) {
            Class<?> providerClass = this.getProviderType(descriptors[i].getDesiredType());
            if (providerClass != null) {
                actualArgs[i] = new ProviderImpl(descriptors[i], this, objectSupplier);
                descriptors[i] = null;
            }
            ++i;
        }
        if (objectSupplier != null) {
            Object[] primarySupplierArgs = objectSupplier.get(descriptors, requestor, requestor.shouldTrack() && track, requestor.shouldGroupUpdates());
            int i2 = 0;
            while (i2 < actualArgs.length) {
                if (descriptors[i2] != null && primarySupplierArgs[i2] != NOT_A_VALUE) {
                    actualArgs[i2] = primarySupplierArgs[i2];
                    descriptors[i2] = null;
                }
                ++i2;
            }
        }
        i = 0;
        while (i < actualArgs.length) {
            ExtendedObjectSupplier extendedSupplier;
            if (descriptors[i] != null && (extendedSupplier = this.findExtendedSupplier(descriptors[i], objectSupplier)) != null) {
                Object result = extendedSupplier.get(descriptors[i], requestor, requestor.shouldTrack() && track, requestor.shouldGroupUpdates());
                if (result != NOT_A_VALUE) {
                    actualArgs[i] = result;
                    descriptors[i] = null;
                }
            }
            ++i;
        }
        i = 0;
        while (i < actualArgs.length) {
            Binding binding;
            if (descriptors[i] != null && (binding = this.findBinding(descriptors[i])) != null) {
                actualArgs[i] = this.internalMake(binding.getImplementationClass(), objectSupplier);
                if (actualArgs[i] != NOT_A_VALUE) {
                    descriptors[i] = null;
                }
            }
            ++i;
        }
        if (!fillNulls && !requestor.isOptional()) {
            i = 0;
            while (i < actualArgs.length) {
                if (descriptors[i] != null && !descriptors[i].hasQualifier(Optional.class)) {
                    Object result = null;
                    try {
                        result = this.internalMake(this.getDesiredClass(descriptors[i].getDesiredType()), objectSupplier);
                    }
                    catch (InjectionException injectionException) {}
                    if (result != null && result != NOT_A_VALUE) {
                        actualArgs[i] = result;
                        descriptors[i] = null;
                    }
                }
                ++i;
            }
        }
        descriptors = requestor.getDependentObjects();
        i = 0;
        while (i < descriptors.length) {
            if (actualArgs[i] != null && actualArgs[i] != IInjector.NOT_A_VALUE) {
                Class<Object> descriptorsClass = this.getDesiredClass(descriptors[i].getDesiredType());
                if (descriptorsClass.isPrimitive()) {
                    if (descriptorsClass.equals(Boolean.TYPE)) {
                        descriptorsClass = Boolean.class;
                    } else if (descriptorsClass.equals(Integer.TYPE)) {
                        descriptorsClass = Integer.class;
                    } else if (descriptorsClass.equals(Character.TYPE)) {
                        descriptorsClass = Character.class;
                    } else if (descriptorsClass.equals(Float.TYPE)) {
                        descriptorsClass = Float.class;
                    } else if (descriptorsClass.equals(Double.TYPE)) {
                        descriptorsClass = Double.class;
                    } else if (descriptorsClass.equals(Long.TYPE)) {
                        descriptorsClass = Long.class;
                    } else if (descriptorsClass.equals(Short.TYPE)) {
                        descriptorsClass = Short.class;
                    } else if (descriptorsClass.equals(Byte.TYPE)) {
                        descriptorsClass = Byte.class;
                    }
                }
                if (!descriptorsClass.isAssignableFrom(actualArgs[i].getClass())) {
                    actualArgs[i] = IInjector.NOT_A_VALUE;
                }
            }
            if (actualArgs[i] == IInjector.NOT_A_VALUE && descriptors[i].hasQualifier(Optional.class)) {
                actualArgs[i] = null;
            } else if (fillNulls && actualArgs[i] == IInjector.NOT_A_VALUE) {
                actualArgs[i] = null;
            }
            ++i;
        }
        return actualArgs;
    }

    private ExtendedObjectSupplier findExtendedSupplier(IObjectDescriptor descriptor, PrimaryObjectSupplier objectSupplier) {
        Annotation[] qualifiers = descriptor.getQualifiers();
        if (qualifiers == null) {
            return null;
        }
        Annotation[] annotationArray = qualifiers;
        int n = qualifiers.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation qualifier = annotationArray[n2];
            Class<? extends Annotation> type = qualifier.annotationType();
            if (type instanceof Class) {
                ExtendedObjectSupplier supplier;
                String key = type.getName();
                try {
                    supplier = ProviderHelper.findProvider(key, objectSupplier);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    return null;
                }
                if (supplier != null) {
                    return supplier;
                }
            }
            ++n2;
        }
        return null;
    }

    private int unresolved(Object[] actualArgs) {
        int i = 0;
        while (i < actualArgs.length) {
            if (actualArgs[i] == IInjector.NOT_A_VALUE) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void processClassHierarchy(Object userObject, PrimaryObjectSupplier objectSupplier, boolean processStatic, boolean track, boolean normalOrder, List<Requestor> requestors) {
        this.processClass(userObject, objectSupplier, userObject == null ? null : userObject.getClass(), new ArrayList(5), processStatic, track, normalOrder, requestors);
    }

    private void processClass(Object userObject, PrimaryObjectSupplier objectSupplier, Class<?> objectsClass, ArrayList<Class<?>> classHierarchy, boolean processStatic, boolean track, boolean normalOrder, List<Requestor> requestors) {
        boolean injectedStaticMethods;
        boolean injectedStaticFields;
        Class<?> superClass;
        if (objectsClass != null && (superClass = objectsClass.getSuperclass()) != null && !superClass.getName().equals(JAVA_OBJECT)) {
            classHierarchy.add(objectsClass);
            this.processClass(userObject, objectSupplier, superClass, classHierarchy, processStatic, track, normalOrder, requestors);
            classHierarchy.remove(objectsClass);
        }
        if (normalOrder) {
            injectedStaticFields = this.processFields(userObject, objectSupplier, objectsClass, processStatic, track, requestors);
            injectedStaticMethods = this.processMethods(userObject, objectSupplier, objectsClass, classHierarchy, processStatic, track, requestors);
        } else {
            injectedStaticMethods = this.processMethods(userObject, objectSupplier, objectsClass, classHierarchy, processStatic, track, requestors);
            injectedStaticFields = this.processFields(userObject, objectSupplier, objectsClass, processStatic, track, requestors);
        }
        if (injectedStaticFields || injectedStaticMethods) {
            this.rememberInjectedStatic(objectsClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasInjectedStatic(Class<?> objectsClass) {
        Set<WeakReference<Class<?>>> set = this.injectedClasses;
        synchronized (set) {
            WeakReference<Class<?>> ref;
            Class injectedClass;
            Iterator<WeakReference<Class<?>>> iterator = this.injectedClasses.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((injectedClass = (Class)(ref = iterator.next()).get()) == null || injectedClass != objectsClass);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rememberInjectedStatic(Class<?> objectsClass) {
        Set<WeakReference<Class<?>>> set = this.injectedClasses;
        synchronized (set) {
            this.injectedClasses.add(new WeakReference(objectsClass));
        }
    }

    private boolean processFields(Object userObject, PrimaryObjectSupplier objectSupplier, Class<?> objectsClass, boolean processStatic, boolean track, List<Requestor> requestors) {
        boolean injectedStatic = false;
        Field[] fields = objectsClass.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            block6: {
                Field field;
                block5: {
                    field = fields[i];
                    if (!Modifier.isStatic(field.getModifiers())) break block5;
                    if (this.hasInjectedStatic(objectsClass)) break block6;
                    injectedStatic = true;
                }
                if (field.isAnnotationPresent(Inject.class)) {
                    requestors.add(new FieldRequestor(field, (IInjector)this, objectSupplier, userObject, track));
                }
            }
            ++i;
        }
        return injectedStatic;
    }

    private boolean processMethods(Object userObject, PrimaryObjectSupplier objectSupplier, Class<?> objectsClass, ArrayList<Class<?>> classHierarchy, boolean processStatic, boolean track, List<Requestor> requestors) {
        boolean injectedStatic = false;
        Method[] methods = objectsClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            block5: {
                Method method;
                block6: {
                    method = methods[i];
                    if (this.isOverridden(method, classHierarchy)) break block5;
                    if (!Modifier.isStatic(method.getModifiers())) break block6;
                    if (this.hasInjectedStatic(objectsClass)) break block5;
                    injectedStatic = true;
                }
                if (method.isAnnotationPresent(Inject.class)) {
                    requestors.add(new MethodRequestor(method, (IInjector)this, objectSupplier, userObject, track));
                }
            }
            ++i;
        }
        return injectedStatic;
    }

    private boolean isOverridden(Method method, ArrayList<Class<?>> classHierarchy) {
        int modifiers = method.getModifiers();
        if (Modifier.isPrivate(modifiers)) {
            return false;
        }
        if (Modifier.isStatic(modifiers)) {
            return false;
        }
        boolean isDefault = !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers);
        for (Class<?> subClass : classHierarchy) {
            try {
                subClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
            }
            catch (SecurityException securityException) {
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            if (isDefault) {
                Package originalPackage = method.getDeclaringClass().getPackage();
                Package overridePackage = subClass.getPackage();
                if (originalPackage == null && overridePackage == null) {
                    return true;
                }
                if (originalPackage == null || overridePackage == null) {
                    return false;
                }
                if (!originalPackage.equals(overridePackage)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private Class<?> getDesiredClass(Type desiredType) {
        Type rawType;
        if (desiredType instanceof Class) {
            return (Class)desiredType;
        }
        if (desiredType instanceof ParameterizedType && (rawType = ((ParameterizedType)desiredType).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        return null;
    }

    private Class<?> getProviderType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        Type rawType = ((ParameterizedType)type).getRawType();
        if (!Provider.class.equals((Object)rawType)) {
            return null;
        }
        Type[] actualTypes = ((ParameterizedType)type).getActualTypeArguments();
        if (actualTypes.length != 1) {
            return null;
        }
        if (!(actualTypes[0] instanceof Class)) {
            return null;
        }
        return (Class)actualTypes[0];
    }

    @Override
    public IBinding addBinding(Class<?> clazz) {
        return this.addBinding(new Binding(clazz, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinding addBinding(IBinding binding) {
        Binding internalBinding = (Binding)binding;
        Class<?> clazz = internalBinding.getDescribedClass();
        Map<Class<?>, Set<Binding>> map = this.bindings;
        synchronized (map) {
            if (this.bindings.containsKey(clazz)) {
                Set<Binding> collection = this.bindings.get(clazz);
                String desiredQualifierName = internalBinding.getQualifierName();
                Iterator<Binding> i = collection.iterator();
                while (i.hasNext()) {
                    Binding collectionBinding = i.next();
                    if (!this.eq(collectionBinding.getQualifierName(), desiredQualifierName)) continue;
                    i.remove();
                    break;
                }
                collection.add(internalBinding);
            } else {
                HashSet<Binding> collection = new HashSet<Binding>(1);
                collection.add(internalBinding);
                this.bindings.put(clazz, collection);
            }
        }
        return binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Binding findBinding(IObjectDescriptor descriptor) {
        Class<?> desiredClass = this.getProviderType(descriptor.getDesiredType());
        if (desiredClass == null) {
            desiredClass = this.getDesiredClass(descriptor.getDesiredType());
        }
        Map<Class<?>, Set<Binding>> map = this.bindings;
        synchronized (map) {
            block10: {
                if (this.bindings.containsKey(desiredClass)) break block10;
                return null;
            }
            Set<Binding> collection = this.bindings.get(desiredClass);
            String desiredQualifierName = null;
            if (descriptor.hasQualifier(Named.class)) {
                Named namedAnnotation = descriptor.getQualifier(Named.class);
                desiredQualifierName = namedAnnotation.value();
            } else {
                Annotation[] annotations = descriptor.getQualifiers();
                if (annotations != null) {
                    Annotation[] annotationArray = annotations;
                    if (annotations.length != 0) {
                        Annotation annotation = annotationArray[0];
                        desiredQualifierName = annotation.annotationType().getName();
                    }
                }
            }
            for (Binding collectionBinding : collection) {
                if (!this.eq(collectionBinding.getQualifierName(), desiredQualifierName)) continue;
                return collectionBinding;
            }
        }
        return null;
    }

    private boolean eq(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    private void processAnnotated(Class<? extends Annotation> annotation, Object userObject, Class<?> objectClass, PrimaryObjectSupplier objectSupplier, ArrayList<Class<?>> classHierarchy) {
        Class<?> superClass = objectClass.getSuperclass();
        if (superClass != null && !superClass.getName().equals(JAVA_OBJECT)) {
            classHierarchy.add(objectClass);
            this.processAnnotated(annotation, userObject, superClass, objectSupplier, classHierarchy);
            classHierarchy.remove(objectClass);
        }
        Method[] methods = objectClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            block5: {
                Object[] actualArgs;
                MethodRequestor requestor;
                block6: {
                    Method method = methods[i];
                    if (!method.isAnnotationPresent(annotation) || this.isOverridden(method, classHierarchy)) break block5;
                    requestor = new MethodRequestor(method, (IInjector)this, objectSupplier, userObject, false);
                    actualArgs = this.resolveArgs(requestor, objectSupplier, false, false);
                    int unresolved = this.unresolved(actualArgs);
                    if (unresolved == -1) break block6;
                    if (method.isAnnotationPresent(Optional.class)) break block5;
                    this.reportUnresolvedArgument(requestor, unresolved);
                }
                requestor.setResolvedArgs(actualArgs);
                requestor.execute();
            }
            ++i;
        }
    }
}

