/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.languages.javascript;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.internal.languages.javascript.JSBundleContext;
import org.eclipse.e4.internal.languages.javascript.JSBundleData;
import org.eclipse.e4.internal.languages.javascript.JSBundleImpl;
import org.eclipse.e4.internal.languages.javascript.JSExportPackage;
import org.eclipse.e4.internal.languages.javascript.JSImportPackage;
import org.eclipse.e4.internal.languages.javascript.JSRequireBundle;
import org.eclipse.e4.internal.languages.javascript.RhinoClassLoader;
import org.eclipse.e4.languages.javascript.JSBundle;
import org.eclipse.e4.languages.javascript.JSBundleException;
import org.eclipse.e4.languages.javascript.JSFramework;
import org.eclipse.e4.languages.javascript.JSONUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.osgi.framework.Bundle;

public class JSFrameworkImpl
implements JSFramework {
    private static final Comparator exportsComparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            JSExportPackage export0 = (JSExportPackage)arg0;
            JSExportPackage export1 = (JSExportPackage)arg1;
            int result = export1.getVersion().compareTo((Object)export0.getVersion());
            if (result == 0) {
                result = export0.getBundleId() - export1.getBundleId();
            }
            return result;
        }
    };
    private static final Comparator requireBundlesComparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            JSBundle bundle0 = (JSBundle)arg0;
            JSBundle bundle1 = (JSBundle)arg1;
            int result = bundle1.getVersion().compareTo((Object)bundle0.getVersion());
            if (result == 0) {
                result = bundle0.getBundleId() - bundle1.getBundleId();
            }
            return result;
        }
    };
    private List installOrderBundles = new ArrayList();
    private List resolveOrderBundles = new ArrayList();
    private Map exports = new HashMap();
    private Map requiredBundles = new HashMap();
    private int currentBundleId = 0;
    private final Scriptable frameworkScope;
    private final Map properties = new HashMap();
    private ContextFactory contextFactory;

    private static Map loadHeaders(String location) throws JSBundleException {
        String contents;
        try {
            URL url = new URL(location);
            contents = JSFrameworkImpl.readContents(url);
        }
        catch (IOException e) {
            throw new JSBundleException("error reading contents from: " + location, e);
        }
        try {
            Object headers = JSONUtil.read(contents);
            if (headers instanceof Map) {
                return (Map)headers;
            }
            throw new JSBundleException("invalid representation - JSON Object expected from: " + location);
        }
        catch (RuntimeException e) {
            throw new JSBundleException("error parsing JSON contents from: " + location, e);
        }
    }

    private static String readContents(URL url) throws IOException {
        String string;
        InputStreamReader reader = new InputStreamReader(new BufferedInputStream(url.openStream()));
        try {
            StringBuffer buffer = new StringBuffer();
            int read = 0;
            char[] cbuf = new char[1024];
            while (-1 != (read = reader.read(cbuf))) {
                buffer.append(cbuf, 0, read);
            }
            string = buffer.toString();
        }
        catch (Throwable throwable) {
            try {
                ((Reader)reader).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((Reader)reader).close();
        }
        catch (IOException iOException) {}
        return string;
    }

    public JSFrameworkImpl() {
        this(new ContextFactory());
    }

    public JSFrameworkImpl(ContextFactory contextFactory) {
        this.contextFactory = contextFactory;
        this.frameworkScope = (Scriptable)contextFactory.call(new ContextAction(){

            public Object run(Context cx) {
                return cx.initStandardObjects();
            }
        });
    }

    ContextFactory getContextFactory() {
        return this.contextFactory;
    }

    public JSBundle installBundle(String location) throws JSBundleException {
        Map headers = JSFrameworkImpl.loadHeaders(location);
        return this.installBundle(location, headers);
    }

    public JSBundle installBundle(String location, Map headers) throws JSBundleException {
        return this.installBundle(location, headers, new RhinoClassLoader());
    }

    public JSBundle installBundle(String location, Bundle bundle) throws JSBundleException {
        Map headers = JSFrameworkImpl.loadHeaders(location);
        return this.installBundle(location, headers, new RhinoClassLoader(bundle));
    }

    public JSBundle installBundle(String location, Map headers, Bundle bundle) throws JSBundleException {
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle cannot be null");
        }
        return this.installBundle(location, headers, new RhinoClassLoader(bundle));
    }

    public JSBundle installBundle(String location, Map headers, RhinoClassLoader contextClassLoader) throws JSBundleException {
        JSBundleData bundleData;
        JSBundleImpl jsBundle;
        int index;
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null");
        }
        if (contextClassLoader == null) {
            contextClassLoader = new RhinoClassLoader();
        }
        if ((index = this.installOrderBundles.indexOf(jsBundle = new JSBundleImpl(this, bundleData = new JSBundleData(this.currentBundleId, location, headers, contextClassLoader)))) != -1) {
            return (JSBundle)this.installOrderBundles.get(index);
        }
        ++this.currentBundleId;
        this.installOrderBundles.add(jsBundle);
        return jsBundle;
    }

    public JSBundle[] getBundles() {
        return this.installOrderBundles.toArray(new JSBundle[this.installOrderBundles.size()]);
    }

    public void refresh() {
        boolean uninstalledBundleFound = false;
        Iterator iterator = this.resolveOrderBundles.iterator();
        while (iterator.hasNext()) {
            JSBundleImpl bundle = (JSBundleImpl)iterator.next();
            if (bundle.getState() == 1) {
                uninstalledBundleFound = true;
                this.installOrderBundles.remove(bundle);
            }
            if (!uninstalledBundleFound) continue;
            this.unresolveBundle(bundle);
            iterator.remove();
        }
        if (uninstalledBundleFound) {
            this.resolve();
        }
    }

    public void resolve() {
        final ArrayList<JSBundle> unresolvedBundles = new ArrayList<JSBundle>();
        Iterator iterator = this.installOrderBundles.iterator();
        while (iterator.hasNext()) {
            JSBundle bundle = (JSBundle)iterator.next();
            if (bundle.getState() != 2) continue;
            unresolvedBundles.add(bundle);
        }
        this.contextFactory.call(new ContextAction(){

            public Object run(Context cx) {
                ArrayList<JSBundleImpl> resolvedBundles = new ArrayList<JSBundleImpl>();
                while (!unresolvedBundles.isEmpty()) {
                    JSBundleImpl resolvedBundle = JSFrameworkImpl.this.stepResolver(unresolvedBundles);
                    if (resolvedBundle == null) break;
                    resolvedBundles.add(resolvedBundle);
                }
                Iterator iterator = resolvedBundles.iterator();
                while (iterator.hasNext()) {
                    JSBundleImpl resolvedBundle = (JSBundleImpl)iterator.next();
                    if (!resolvedBundle.isMarkedStarted()) continue;
                    resolvedBundle.start();
                }
                return null;
            }
        });
    }

    JSBundleImpl stepResolver(List unresolved) {
        Iterator iterator = unresolved.iterator();
        while (iterator.hasNext()) {
            JSBundleImpl bundle = (JSBundleImpl)iterator.next();
            if (!this.resolveBundle(bundle)) continue;
            this.resolveOrderBundles.add(bundle);
            iterator.remove();
            return bundle;
        }
        return null;
    }

    private boolean resolveBundle(JSBundleImpl jsBundle) {
        if (jsBundle.isSingleton() && this.requiredBundles.containsKey(jsBundle.getSymbolicName())) {
            return false;
        }
        if (this.wire(jsBundle)) {
            jsBundle.resolve();
            this.addExports(jsBundle);
            this.addRequiredBunde(jsBundle);
            return true;
        }
        this.unwire(jsBundle);
        return false;
    }

    private void unresolveBundle(JSBundleImpl jsBundle) {
        this.removeExports(jsBundle);
        this.removeRequiredBunde(jsBundle);
        jsBundle.unresolve();
        this.unwire(jsBundle);
    }

    private boolean wire(JSBundleImpl bundle) {
        return this.wireRequires(bundle) && this.wireImports(bundle);
    }

    private boolean wireRequires(JSBundleImpl bundle) {
        List requires = bundle.getRequires();
        Iterator iterator = requires.iterator();
        while (iterator.hasNext()) {
            JSRequireBundle jsRequire = (JSRequireBundle)iterator.next();
            String name = jsRequire.getName();
            List candidates = (List)this.requiredBundles.get(name);
            if (candidates == null) {
                return false;
            }
            boolean satisfied = false;
            Iterator candidatesIterator = candidates.iterator();
            while (candidatesIterator.hasNext()) {
                JSBundleImpl candidate = (JSBundleImpl)candidatesIterator.next();
                satisfied = jsRequire.wire(candidate);
                if (satisfied) break;
            }
            if (satisfied || jsRequire.isOptional()) continue;
            return false;
        }
        return true;
    }

    private boolean wireImports(JSBundleImpl bundle) {
        List imports = bundle.getImports();
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            JSImportPackage jsImport = (JSImportPackage)iterator.next();
            String name = jsImport.getName();
            List candidates = (List)this.exports.get(name);
            if (candidates == null) {
                return false;
            }
            boolean satisfied = false;
            Iterator candidatesIterator = candidates.iterator();
            while (candidatesIterator.hasNext()) {
                JSExportPackage candidate = (JSExportPackage)candidatesIterator.next();
                satisfied = jsImport.wire(candidate);
                if (satisfied) break;
            }
            if (satisfied || jsImport.isOptional()) continue;
            return false;
        }
        return true;
    }

    private void addExports(JSBundleImpl bundle) {
        Iterator it = bundle.getExports().iterator();
        while (it.hasNext()) {
            JSExportPackage jsExport = (JSExportPackage)it.next();
            String name = jsExport.getName();
            ArrayList<JSExportPackage> namedExports = (ArrayList<JSExportPackage>)this.exports.get(name);
            if (namedExports == null) {
                namedExports = new ArrayList<JSExportPackage>();
                this.exports.put(name, namedExports);
            }
            namedExports.add(jsExport);
            Collections.sort(namedExports, exportsComparator);
        }
    }

    private void addRequiredBunde(JSBundle bundle) {
        String name = bundle.getSymbolicName();
        ArrayList<JSBundle> namedBundles = (ArrayList<JSBundle>)this.requiredBundles.get(name);
        if (namedBundles == null) {
            namedBundles = new ArrayList<JSBundle>();
            this.requiredBundles.put(name, namedBundles);
        }
        namedBundles.add(bundle);
        Collections.sort(namedBundles, requireBundlesComparator);
    }

    private void unwire(JSBundleImpl jsBundle) {
        this.unwireImports(jsBundle);
        this.unwireRequires(jsBundle);
    }

    private void unwireImports(JSBundleImpl bundle) {
        List imports = bundle.getImports();
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            JSImportPackage jsImport = (JSImportPackage)iterator.next();
            jsImport.unwire();
        }
    }

    private void unwireRequires(JSBundleImpl bundle) {
        List requires = bundle.getRequires();
        Iterator iterator = requires.iterator();
        while (iterator.hasNext()) {
            JSRequireBundle jsRequire = (JSRequireBundle)iterator.next();
            jsRequire.unwire();
        }
    }

    private void removeRequiredBunde(JSBundle bundle) {
        String name = bundle.getSymbolicName();
        List namedBundles = (List)this.requiredBundles.get(name);
        if (namedBundles == null) {
            return;
        }
        namedBundles.remove(bundle);
        if (namedBundles.isEmpty()) {
            this.requiredBundles.remove(name);
        }
    }

    private void removeExports(JSBundleImpl bundle) {
        Iterator it = bundle.getExports().iterator();
        while (it.hasNext()) {
            JSExportPackage jsExport = (JSExportPackage)it.next();
            String name = jsExport.getName();
            List namedExports = (List)this.exports.get(name);
            if (namedExports == null) continue;
            namedExports.remove(jsExport);
            if (!namedExports.isEmpty()) continue;
            this.exports.remove(name);
        }
    }

    protected Scriptable createScope(ClassLoader classLoader) {
        Context cx = Context.getCurrentContext();
        ClassLoader current = cx.getApplicationClassLoader();
        cx.setApplicationClassLoader(classLoader);
        try {
            ScriptableObject scope = (ScriptableObject)cx.newObject(this.frameworkScope);
            scope.setParentScope(this.frameworkScope);
            new LazilyLoadedCtor(scope, "Packages", "org.mozilla.javascript.NativeJavaTopPackage", false);
            scope.get("Packages", (Scriptable)scope);
            ScriptableObject scriptableObject = scope;
            return scriptableObject;
        }
        finally {
            cx.setApplicationClassLoader(current);
        }
    }

    public JSBundleContext getBundleContext(JSBundle jsBundle) {
        return new JSBundleContext(jsBundle, this);
    }

    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public void shutdown() {
        ArrayList reversed = new ArrayList(this.installOrderBundles);
        Collections.reverse(reversed);
        Iterator iterator = reversed.iterator();
        while (iterator.hasNext()) {
            JSBundle jsBundle = (JSBundle)iterator.next();
            jsBundle.stop();
            jsBundle.uninstall();
        }
        this.refresh();
    }
}

