/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.util;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PLocator;

public class PNodeLocator
extends PLocator {
    public static final double CENTER = 0.5;
    public static final double WEST = 0.0;
    public static final double EAST = 1.0;
    public static final double NORTH = 0.0;
    public static final double SOUTH = 1.0;
    protected PNode node;
    private double horizontalAlignment = 0.5;
    private double verticalAlignment = 0.5;

    public PNodeLocator(PNode node, double horizontalAlignment, double verticalAlignment) {
        this.setNode(node);
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
    }

    public PNodeLocator(PNode node) {
        this(node, 0.5, 0.5);
    }

    public PNode getNode() {
        return this.node;
    }

    public void setNode(PNode node) {
        this.node = node;
    }

    public double getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(double horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public double getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(double verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public void setAlignments(double horizontalAlignment, double verticalAlignment) {
        this.setHorizontalAlignment(horizontalAlignment);
        this.setVerticalAlignment(verticalAlignment);
    }

    public double locateX() {
        PBounds aBounds = this.node.getBoundsReference();
        return aBounds.getX() + aBounds.getWidth() * this.horizontalAlignment + this.offsetX;
    }

    public double locateY() {
        PBounds aBounds = this.node.getBoundsReference();
        return aBounds.getY() + aBounds.getHeight() * this.verticalAlignment + this.offsetY;
    }

    public static PNodeLocator createCenterLocator(PNode node) {
        return new PNodeLocator(node, 0.5, 0.5);
    }

    public static PNodeLocator createEastLocator(PNode node) {
        return new PNodeLocator(node, 1.0, 0.5);
    }

    public static PNodeLocator createNorthEastLocator(PNode node) {
        return new PNodeLocator(node, 1.0, 0.0);
    }

    public static PNodeLocator createNorthWestLocator(PNode node) {
        return new PNodeLocator(node, 0.0, 0.0);
    }

    public static PNodeLocator createNorthLocator(PNode node) {
        return new PNodeLocator(node, 0.5, 0.0);
    }

    public static PNodeLocator createSouthLocator(PNode node) {
        return new PNodeLocator(node, 0.5, 1.0);
    }

    public static PNodeLocator createWestLocator(PNode node) {
        return new PNodeLocator(node, 0.0, 0.5);
    }

    public static PNodeLocator createSouthWestLocator(PNode node) {
        return new PNodeLocator(node, 0.0, 1.0);
    }

    public static PNodeLocator createSouthEastLocator(PNode node) {
        return new PNodeLocator(node, 1.0, 1.0);
    }
}

