/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.common.component;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponentEditor {
    private EditingDomain editingDomain;
    private static Map<Integer, Image> IMAGE_MAP = new HashMap<Integer, Image>();
    private static final String[] IMAGES = new String[]{"/icons/full/obj16/zoom.png", "/icons/full/obj16/table_add.png", "/icons/full/obj16/table_delete.png", "/icons/full/obj16/arrow_up.png", "/icons/full/obj16/arrow_down.png"};
    private WritableValue master = new WritableValue();
    public static final int SEARCH_IMAGE = 0;
    public static final int TABLE_ADD_IMAGE = 1;
    public static final int TABLE_DELETE_IMAGE = 2;
    public static final int ARROW_UP = 3;
    public static final int ARROW_DOWN = 4;

    public AbstractComponentEditor(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public WritableValue getMaster() {
        return this.master;
    }

    public Image getImage(Display d, int id) {
        Image img = IMAGE_MAP.get(id);
        if (img == null) {
            try {
                InputStream in = AbstractComponentEditor.class.getClassLoader().getResourceAsStream(IMAGES[id]);
                img = new Image((Device)d, in);
                IMAGE_MAP.put(id, img);
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return img;
    }

    public abstract Image getImage(Object var1, Display var2);

    public abstract String getLabel(Object var1);

    public abstract String getDetailLabel(Object var1);

    public abstract String getDescription(Object var1);

    public abstract Composite getEditor(Composite var1, Object var2);

    public abstract IObservableList getChildList(Object var1);

    protected Image loadSharedImage(Display d, URL path) {
        try {
            URL url = FileLocator.resolve((URL)path);
            if (url != null) {
                InputStream in = url.openStream();
                Image image = new Image((Device)d, in);
                in.close();
                return image;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public FeaturePath[] getLabelProperties() {
        return new FeaturePath[0];
    }

    public List<Action> getActions(Object element) {
        return Collections.emptyList();
    }
}

