/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.jface.viewers;

import org.eclipse.e4.ui.css.core.css2.CSS2FontPropertiesHelpers;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSBaseLabelProvider
extends LabelProvider {
    protected CSSEngine engine;
    protected StructuredViewer viewer;

    public CSSBaseLabelProvider(CSSEngine engine, StructuredViewer viewer) {
        this.engine = engine;
        this.viewer = viewer;
    }

    protected Font getFont(Object element, String propertyName, int columnIndex) {
        Widget widget = this.getWidget(element, columnIndex);
        return this.getFont(widget, propertyName);
    }

    protected Font getFont(Object element, String propertyName) {
        Widget widget = this.getWidget(element);
        return this.getFont(widget, propertyName);
    }

    protected Font getFont(Widget widget, String propertyName) {
        CSSValue value = this.getCSSValue(widget, propertyName);
        if (value == null) {
            return null;
        }
        CSS2FontProperties fontProperties = CSS2FontPropertiesHelpers.createCSS2FontProperties((CSSValue)value, (String)propertyName);
        try {
            return (Font)this.engine.convert((CSSValue)fontProperties, Font.class, (Object)widget.getDisplay());
        }
        catch (Exception e) {
            this.engine.handleExceptions(e);
            return null;
        }
    }

    protected Image getImage(Object element, String propertyName, int columnIndex) {
        Widget widget = this.getWidget(element, columnIndex);
        return this.getImage(widget, propertyName);
    }

    protected Image getImage(Object element, String propertyName) {
        Widget widget = this.getWidget(element);
        return this.getImage(widget, propertyName);
    }

    protected Image getImage(Widget widget, String propertyName) {
        return (Image)this.getResource(widget, propertyName, Image.class);
    }

    protected Color getColor(Object element, String propertyName, int columnIndex) {
        Widget widget = this.getWidget(element, columnIndex);
        return this.getColor(widget, propertyName);
    }

    protected Color getColor(Object element, String propertyName) {
        Widget widget = this.getWidget(element);
        return this.getColor(widget, propertyName);
    }

    protected Color getColor(Widget widget, String propertyName) {
        return (Color)this.getResource(widget, propertyName, Color.class);
    }

    protected Object getResource(Widget widget, String propertyName, Object toType) {
        CSSValue value = this.getCSSValue(widget, propertyName);
        if (value != null) {
            try {
                return this.engine.convert(value, toType, (Object)widget.getDisplay());
            }
            catch (Exception e) {
                this.engine.handleExceptions(e);
            }
        }
        return null;
    }

    protected CSSValue getCSSValue(Widget widget, String propertyName) {
        if (widget == null) {
            return null;
        }
        Element elt = this.engine.getElement((Object)widget);
        if (elt == null) {
            return null;
        }
        CSSStyleDeclaration styleDeclaration = this.engine.getViewCSS().getComputedStyle(elt, null);
        if (styleDeclaration == null) {
            return null;
        }
        return styleDeclaration.getPropertyCSSValue(propertyName);
    }

    protected Widget getWidget(Object element) {
        return this.viewer.testFindItem(element);
    }

    protected Widget getWidget(Object element, int columnIndex) {
        return null;
    }
}

