/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.gadgets.opensocial.propertyPages;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.ui.internal.gadgets.opensocial.OSGModule;
import org.eclipse.e4.ui.internal.gadgets.opensocial.OSGUserPref;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class OSGModulePrefsPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Map<String, Text> preferenceEditors = new HashMap<String, Text>();

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        OSGModule module = (OSGModule)this.getElement().getAdapter(OSGModule.class);
        for (OSGUserPref pref : module.getUserPrefs()) {
            this.addProperty(composite, pref.getName(), pref.getValue());
        }
        return composite;
    }

    public boolean performOk() {
        OSGModule module = (OSGModule)this.getElement().getAdapter(OSGModule.class);
        for (Map.Entry<String, Text> entry : this.preferenceEditors.entrySet()) {
            module.setUserPrefValue(entry.getKey(), entry.getValue().getText());
        }
        return true;
    }

    protected void performDefaults() {
        OSGModule module = (OSGModule)this.getElement().getAdapter(OSGModule.class);
        for (Map.Entry<String, Text> entry : this.preferenceEditors.entrySet()) {
            String userPrefDefaultValue = module.getUserPrefDefaultValue(entry.getKey());
            entry.getValue().setText(userPrefDefaultValue);
        }
    }

    private void addProperty(Composite parent, String key, String value) {
        Label label = new Label(parent, 0);
        label.setText(key);
        Text text = new Text(parent, 2048);
        if (value == null) {
            value = "";
        }
        text.setText(value);
        GridData gd = new GridData(768);
        text.setLayoutData((Object)gd);
        this.preferenceEditors.put(key, text);
    }
}

