/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ButtonTest
extends CSSSWTTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);
    CSSEngine engine;

    protected Button createTestButton(String styleSheet) {
        Display display = Display.getDefault();
        this.engine = this.createEngine(styleSheet, display);
        Shell shell = new Shell(display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        Button buttonToTest = new Button(panel, 32);
        buttonToTest.setText("Some button text");
        this.engine.applyStyles((Object)shell, true);
        shell.pack();
        return buttonToTest;
    }

    protected Button createTestArrowButton(String styleSheet) {
        Display display = Display.getDefault();
        this.engine = this.createEngine(styleSheet, display);
        Shell shell = new Shell(display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        Button buttonToTest = new Button(panel, 4);
        this.engine.applyStyles((Object)shell, true);
        shell.pack();
        return buttonToTest;
    }

    public void testColor() throws Exception {
        Button buttonToTest = this.createTestButton("Button { background-color: #FF0000; color: #0000FF }");
        ButtonTest.assertEquals((Object)RED, (Object)buttonToTest.getBackground().getRGB());
        ButtonTest.assertEquals((Object)BLUE, (Object)buttonToTest.getForeground().getRGB());
    }

    public void testFontRegular() throws Exception {
        Button buttonToTest = this.createTestButton("Button { font: Verdana 16px }");
        ButtonTest.assertEquals((int)1, (int)buttonToTest.getFont().getFontData().length);
        FontData fontData = buttonToTest.getFont().getFontData()[0];
        ButtonTest.assertEquals((String)"Verdana", (String)fontData.getName());
        ButtonTest.assertEquals((int)16, (int)fontData.getHeight());
        ButtonTest.assertEquals((int)0, (int)fontData.getStyle());
    }

    public void testFontBold() throws Exception {
        Button buttonToTest = this.createTestButton("Button { font: Arial 12px; font-weight: bold }");
        ButtonTest.assertEquals((int)1, (int)buttonToTest.getFont().getFontData().length);
        FontData fontData = buttonToTest.getFont().getFontData()[0];
        ButtonTest.assertEquals((String)"Arial", (String)fontData.getName());
        ButtonTest.assertEquals((int)12, (int)fontData.getHeight());
        ButtonTest.assertEquals((int)1, (int)fontData.getStyle());
    }

    public void testFontItalic() throws Exception {
        Button buttonToTest = this.createTestButton("Button { font-style: italic }");
        ButtonTest.assertEquals((int)1, (int)buttonToTest.getFont().getFontData().length);
        FontData fontData = buttonToTest.getFont().getFontData()[0];
        ButtonTest.assertEquals((int)2, (int)fontData.getStyle());
    }

    public void testSelectedPseudo() throws Exception {
        Button buttonToTest = this.createTestButton("Button { color: #FF0000; }\nButton:selected { color: #0000FF; }");
        ButtonTest.assertEquals((Object)RED, (Object)buttonToTest.getForeground().getRGB());
        buttonToTest.setSelection(true);
        this.engine.applyStyles((Object)buttonToTest.getShell(), true);
        ButtonTest.assertEquals((Object)BLUE, (Object)buttonToTest.getForeground().getRGB());
    }

    public void testAlignment() throws Exception {
        Button buttonToTest = this.createTestButton("Button { alignment: right; }");
        ButtonTest.assertEquals((int)131072, (int)buttonToTest.getAlignment());
        buttonToTest = this.createTestButton("Button { alignment: left; }");
        ButtonTest.assertEquals((int)16384, (int)buttonToTest.getAlignment());
        buttonToTest = this.createTestButton("Button { alignment: center; }");
        ButtonTest.assertEquals((int)0x1000000, (int)buttonToTest.getAlignment());
    }

    public void testAlignment2() throws Exception {
        Button buttonToTest = this.createTestButton("Button { alignment: trail; }");
        ButtonTest.assertEquals((int)131072, (int)buttonToTest.getAlignment());
        buttonToTest = this.createTestButton("Button { alignment: lead; }");
        ButtonTest.assertEquals((int)16384, (int)buttonToTest.getAlignment());
    }

    public void testArrowAlignment() throws Exception {
        Button buttonToTest = this.createTestArrowButton("Button { alignment: up; }");
        ButtonTest.assertEquals((int)128, (int)buttonToTest.getAlignment());
        buttonToTest = this.createTestArrowButton("Button { alignment: down; }");
        ButtonTest.assertEquals((int)1024, (int)buttonToTest.getAlignment());
        buttonToTest = this.createTestArrowButton("Button { alignment: left; }");
        ButtonTest.assertEquals((int)16384, (int)buttonToTest.getAlignment());
        buttonToTest = this.createTestArrowButton("Button { alignment: right; }");
        ButtonTest.assertEquals((int)131072, (int)buttonToTest.getAlignment());
    }
}

