/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.UIEventPublisher;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MInputPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindowElement;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.tests.application.ClientEditor;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IPartListener;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.emf.common.notify.Notifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPartServiceTest
extends TestCase {
    private IEclipseContext applicationContext;
    private IPresentationEngine engine;

    protected void setUp() throws Exception {
        this.applicationContext = E4Application.createDefaultContext();
        super.setUp();
    }

    protected String getEngineURI() {
        return "platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.HeadlessContextPresentationEngine";
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.applicationContext instanceof IDisposable) {
            this.applicationContext.dispose();
        }
    }

    private IPresentationEngine getEngine() {
        if (this.engine == null) {
            IContributionFactory contributionFactory = (IContributionFactory)this.applicationContext.get(IContributionFactory.class.getName());
            Object newEngine = contributionFactory.create(this.getEngineURI(), this.applicationContext);
            EPartServiceTest.assertTrue((boolean)(newEngine instanceof IPresentationEngine));
            this.applicationContext.set(IPresentationEngine.class.getName(), newEngine);
            this.engine = (IPresentationEngine)newEngine;
        }
        return this.engine;
    }

    public void testFindPart_PartInWindow() {
        MApplication application = this.createApplication("partId");
        MWindow window = (MWindow)application.getChildren().get(0);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart part = partService.findPart("partId");
        EPartServiceTest.assertNotNull((Object)part);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        EPartServiceTest.assertEquals(partStack.getChildren().get(0), (Object)part);
        part = partService.findPart("invalidPartId");
        EPartServiceTest.assertNull((Object)part);
    }

    public void testFindPart_PartNotInWindow() {
        MApplication application = this.createApplication("partId");
        MWindow window = (MWindow)application.getChildren().get(0);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart part = partService.findPart("invalidPartId");
        EPartServiceTest.assertNull((Object)part);
    }

    public void testFindPart_PartInAnotherWindow() {
        MApplication application = this.createApplication(new String[][]{{"partInWindow1"}, {"partInWindow2"}});
        MWindow window1 = (MWindow)application.getChildren().get(0);
        MWindow window2 = (MWindow)application.getChildren().get(1);
        this.getEngine().createGui((MUIElement)window1);
        this.getEngine().createGui((MUIElement)window2);
        EPartService partService = (EPartService)window1.getContext().get(EPartService.class.getName());
        MPart part = partService.findPart("partInWindow2");
        EPartServiceTest.assertNull((Object)part);
        part = partService.findPart("partInWindow1");
        EPartServiceTest.assertNotNull((Object)part);
        MPartStack partStack = (MPartStack)window1.getChildren().get(0);
        EPartServiceTest.assertEquals(partStack.getChildren().get(0), (Object)part);
        partService = (EPartService)window2.getContext().get(EPartService.class.getName());
        part = partService.findPart("partInWindow1");
        EPartServiceTest.assertNull((Object)part);
        part = partService.findPart("partInWindow2");
        EPartServiceTest.assertNotNull((Object)part);
        partStack = (MPartStack)window2.getChildren().get(0);
        EPartServiceTest.assertEquals(partStack.getChildren().get(0), (Object)part);
    }

    public void testBringToTop_PartOnTop() {
        MApplication application = this.createApplication("partFront", "partBack");
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart partFront = (MPart)partStack.getChildren().get(0);
        partStack.setSelectedElement((MUIElement)partFront);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        partService.bringToTop(partFront);
        EPartServiceTest.assertEquals((Object)partStack.getSelectedElement(), (Object)partFront);
    }

    public void testBringToTop_PartOnTop_myService() {
        MApplication application = this.createApplication("partFront", "partBack");
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart partFront = (MPart)partStack.getChildren().get(0);
        partStack.setSelectedElement((MUIElement)partFront);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)partFront.getContext().get(EPartService.class.getName());
        partService.bringToTop(partFront);
        EPartServiceTest.assertEquals((Object)partStack.getSelectedElement(), (Object)partFront);
    }

    public void testBringToTop_PartNotOnTop() {
        MApplication application = this.createApplication("partFront", "partBack");
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart partFront = (MPart)partStack.getChildren().get(0);
        MPart partBack = (MPart)partStack.getChildren().get(1);
        partStack.setSelectedElement((MUIElement)partFront);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        partService.bringToTop(partBack);
        EPartServiceTest.assertEquals((Object)partStack.getSelectedElement(), (Object)partBack);
    }

    public void testBringToTop_PartNotOnTop_myService() {
        MApplication application = this.createApplication("partFront", "partBack");
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart partFront = (MPart)partStack.getChildren().get(0);
        MPart partBack = (MPart)partStack.getChildren().get(1);
        partStack.setSelectedElement((MUIElement)partFront);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)partFront.getContext().get(EPartService.class.getName());
        partService.bringToTop(partBack);
        EPartServiceTest.assertEquals((Object)partStack.getSelectedElement(), (Object)partBack);
    }

    public void testBringToTop_PartInAnotherWindow() {
        MApplication application = this.createApplication(new String[][]{{"partFrontA", "partBackA"}, {"partFrontB", "partBackB"}});
        MWindow windowA = (MWindow)application.getChildren().get(0);
        MPartStack partStackA = (MPartStack)windowA.getChildren().get(0);
        MPart partFrontA = (MPart)partStackA.getChildren().get(0);
        MPart partBackA = (MPart)partStackA.getChildren().get(1);
        partStackA.setSelectedElement((MUIElement)partFrontA);
        MWindow windowB = (MWindow)application.getChildren().get(1);
        MPartStack partStackB = (MPartStack)windowB.getChildren().get(0);
        MPart partFrontB = (MPart)partStackB.getChildren().get(0);
        MPart partBackB = (MPart)partStackB.getChildren().get(1);
        partStackB.setSelectedElement((MUIElement)partFrontB);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)windowA.getContext().get(EPartService.class.getName());
        EPartService partServiceB = (EPartService)windowB.getContext().get(EPartService.class.getName());
        partServiceA.bringToTop(partBackB);
        EPartServiceTest.assertEquals((Object)partStackA.getSelectedElement(), (Object)partFrontA);
        EPartServiceTest.assertEquals((Object)partStackB.getSelectedElement(), (Object)partFrontB);
        partServiceB.bringToTop(partBackA);
        EPartServiceTest.assertEquals((Object)partStackA.getSelectedElement(), (Object)partFrontA);
        EPartServiceTest.assertEquals((Object)partStackB.getSelectedElement(), (Object)partFrontB);
        partServiceA.bringToTop(partBackA);
        EPartServiceTest.assertEquals((Object)partStackA.getSelectedElement(), (Object)partBackA);
        EPartServiceTest.assertEquals((Object)partStackB.getSelectedElement(), (Object)partFrontB);
        partServiceB.bringToTop(partBackB);
        EPartServiceTest.assertEquals((Object)partStackA.getSelectedElement(), (Object)partBackA);
        EPartServiceTest.assertEquals((Object)partStackB.getSelectedElement(), (Object)partBackB);
    }

    public void testBringToTop_PartInAnotherWindow_myService() {
        MApplication application = this.createApplication(new String[][]{{"partFrontA", "partBackA"}, {"partFrontB", "partBackB"}});
        MWindow windowA = (MWindow)application.getChildren().get(0);
        MPartStack partStackA = (MPartStack)windowA.getChildren().get(0);
        MPart partFrontA = (MPart)partStackA.getChildren().get(0);
        MPart partBackA = (MPart)partStackA.getChildren().get(1);
        partStackA.setSelectedElement((MUIElement)partFrontA);
        MWindow windowB = (MWindow)application.getChildren().get(1);
        MPartStack partStackB = (MPartStack)windowB.getChildren().get(0);
        MPart partFrontB = (MPart)partStackB.getChildren().get(0);
        MPart partBackB = (MPart)partStackB.getChildren().get(1);
        partStackB.setSelectedElement((MUIElement)partFrontB);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)partFrontA.getContext().get(EPartService.class.getName());
        EPartService partServiceB = (EPartService)partFrontB.getContext().get(EPartService.class.getName());
        partServiceA.bringToTop(partBackB);
        EPartServiceTest.assertEquals((Object)partStackA.getSelectedElement(), (Object)partFrontA);
        EPartServiceTest.assertEquals((Object)partStackB.getSelectedElement(), (Object)partFrontB);
        partServiceB.bringToTop(partBackA);
        EPartServiceTest.assertEquals((Object)partStackA.getSelectedElement(), (Object)partFrontA);
        EPartServiceTest.assertEquals((Object)partStackB.getSelectedElement(), (Object)partFrontB);
        partServiceA.bringToTop(partBackA);
        EPartServiceTest.assertEquals((Object)partStackA.getSelectedElement(), (Object)partBackA);
        EPartServiceTest.assertEquals((Object)partStackB.getSelectedElement(), (Object)partFrontB);
        partServiceB.bringToTop(partBackB);
        EPartServiceTest.assertEquals((Object)partStackA.getSelectedElement(), (Object)partBackA);
        EPartServiceTest.assertEquals((Object)partStackB.getSelectedElement(), (Object)partBackB);
    }

    public void testBringToTop_ActivationChanges() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack partStackA = BasicFactoryImpl.eINSTANCE.createPartStack();
        MPart partFrontA = BasicFactoryImpl.eINSTANCE.createPart();
        MPart partBackA = BasicFactoryImpl.eINSTANCE.createPart();
        partStackA.getChildren().add(partFrontA);
        partStackA.getChildren().add(partBackA);
        window.getChildren().add(partStackA);
        MPartStack partStackB = BasicFactoryImpl.eINSTANCE.createPartStack();
        MPart partFrontB = BasicFactoryImpl.eINSTANCE.createPart();
        MPart partBackB = BasicFactoryImpl.eINSTANCE.createPart();
        partStackB.getChildren().add(partFrontB);
        partStackB.getChildren().add(partBackB);
        window.getChildren().add(partStackB);
        partStackA.setSelectedElement((MUIElement)partFrontA);
        partStackB.setSelectedElement((MUIElement)partFrontB);
        window.setSelectedElement((MUIElement)partStackA);
        application.setSelectedElement((MUIElement)window);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        partService.activate(partFrontA);
        EPartServiceTest.assertEquals((Object)partFrontA, (Object)partService.getActivePart());
        partService.bringToTop(partBackB);
        EPartServiceTest.assertEquals((Object)partFrontA, (Object)partService.getActivePart());
        EPartServiceTest.assertTrue((boolean)partService.isPartVisible(partFrontA));
        EPartServiceTest.assertFalse((boolean)partService.isPartVisible(partBackA));
        EPartServiceTest.assertFalse((boolean)partService.isPartVisible(partFrontB));
        EPartServiceTest.assertTrue((boolean)partService.isPartVisible(partBackB));
        partService.bringToTop(partBackA);
        EPartServiceTest.assertEquals((Object)partBackA, (Object)partService.getActivePart());
        EPartServiceTest.assertFalse((boolean)partService.isPartVisible(partFrontA));
        EPartServiceTest.assertTrue((boolean)partService.isPartVisible(partBackA));
        EPartServiceTest.assertFalse((boolean)partService.isPartVisible(partFrontB));
        EPartServiceTest.assertTrue((boolean)partService.isPartVisible(partBackB));
    }

    public void testBringToTop_Unrendered() {
        MApplication application = this.createApplication("partFront", "partBack");
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart partFront = (MPart)partStack.getChildren().get(0);
        MPart partBack = (MPart)partStack.getChildren().get(1);
        partBack.setToBeRendered(false);
        partStack.setSelectedElement((MUIElement)partFront);
        window.setSelectedElement((MUIElement)partStack);
        application.setSelectedElement((MUIElement)window);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartServiceTest.assertFalse((boolean)partBack.isToBeRendered());
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        partService.bringToTop(partBack);
        EPartServiceTest.assertTrue((String)"Bringing a part to the top should cause it to be rendered", (boolean)partBack.isToBeRendered());
    }

    public void testGetParts_Empty() {
        MApplication application = this.createApplication(1, new String[1][0]);
        MWindow window = (MWindow)application.getChildren().get(0);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        Collection parts = partService.getParts();
        EPartServiceTest.assertNotNull((Object)parts);
        EPartServiceTest.assertEquals((int)0, (int)parts.size());
    }

    public void testGetParts_OneWindow() {
        MApplication application = this.createApplication("partId", "partId2");
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        Collection parts = partService.getParts();
        EPartServiceTest.assertNotNull((Object)parts);
        EPartServiceTest.assertEquals((int)2, (int)parts.size());
        EPartServiceTest.assertTrue((boolean)parts.containsAll(partStack.getChildren()));
    }

    public void testGetParts_TwoWindows() {
        MApplication application = this.createApplication(new String[][]{{"partId", "partId2"}, {"partIA", "partIdB", "partIdC"}});
        MWindow windowA = (MWindow)application.getChildren().get(0);
        MWindow windowB = (MWindow)application.getChildren().get(1);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)windowA.getContext().get(EPartService.class.getName());
        EPartService partServiceB = (EPartService)windowB.getContext().get(EPartService.class.getName());
        MPartStack partStackA = (MPartStack)windowA.getChildren().get(0);
        MPartStack partStackB = (MPartStack)windowB.getChildren().get(0);
        Collection partsA = partServiceA.getParts();
        Collection partsB = partServiceB.getParts();
        EPartServiceTest.assertNotNull((Object)partsA);
        EPartServiceTest.assertEquals((int)2, (int)partsA.size());
        EPartServiceTest.assertTrue((boolean)partsA.containsAll(partStackA.getChildren()));
        EPartServiceTest.assertNotNull((Object)partsB);
        EPartServiceTest.assertEquals((int)3, (int)partsB.size());
        EPartServiceTest.assertTrue((boolean)partsB.containsAll(partStackB.getChildren()));
        for (MPart partA : partsA) {
            EPartServiceTest.assertFalse((boolean)partsB.contains(partA));
        }
    }

    public void testGetInputParts() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        MInputPart inputPart = BasicFactoryImpl.eINSTANCE.createInputPart();
        inputPart.setInputURI("file:///a.txt");
        window.getChildren().add(inputPart);
        part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        inputPart = BasicFactoryImpl.eINSTANCE.createInputPart();
        inputPart.setInputURI("file:///b.txt");
        window.getChildren().add(inputPart);
        inputPart = BasicFactoryImpl.eINSTANCE.createInputPart();
        inputPart.setInputURI("file:///a.txt");
        window.getChildren().add(inputPart);
        part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertEquals((int)6, (int)partService.getParts().size());
        EPartServiceTest.assertEquals((int)2, (int)partService.getInputParts("file:///a.txt").size());
        EPartServiceTest.assertEquals((int)1, (int)partService.getInputParts("file:///b.txt").size());
        EPartServiceTest.assertEquals((int)0, (int)partService.getInputParts("totally unknown").size());
        try {
            partService.getInputParts(null);
            EPartServiceTest.fail((String)"Passing null should throw an AssertionFailedException");
        }
        catch (AssertionFailedException assertionFailedException) {}
    }

    public void testIsPartVisible_NotInStack(boolean selected, boolean visible) {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setVisible(visible);
        window.getChildren().add(part);
        if (selected) {
            window.setSelectedElement((MUIElement)part);
        }
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertEquals((boolean)visible, (boolean)partService.isPartVisible(part));
        partService = (EPartService)part.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertEquals((boolean)visible, (boolean)partService.isPartVisible(part));
    }

    public void testIsPartVisible_NotInStackTrueTrue() {
        this.testIsPartVisible_NotInStack(true, true);
    }

    public void testIsPartVisible_NotInStackTrueFalse() {
        this.testIsPartVisible_NotInStack(true, false);
    }

    public void testIsPartVisible_NotInStackFalseTrue() {
        this.testIsPartVisible_NotInStack(false, true);
    }

    public void testIsPartVisible_NotInStackFalseFalse() {
        this.testIsPartVisible_NotInStack(false, false);
    }

    public void testIsPartVisible_ViewVisible() {
        MApplication application = this.createApplication("partId");
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart part = (MPart)partStack.getChildren().get(0);
        partStack.setSelectedElement((MUIElement)part);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertTrue((boolean)partService.isPartVisible(part));
    }

    public void testIsPartVisible_ViewVisible_myService() {
        MApplication application = this.createApplication("partId");
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart part = (MPart)partStack.getChildren().get(0);
        partStack.setSelectedElement((MUIElement)part);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)part.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertTrue((boolean)partService.isPartVisible(part));
    }

    public void testIsPartVisible_ViewNotVisible() {
        MApplication application = this.createApplication("partId", "partId2");
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        partStack.setSelectedElement((MUIElement)((MStackElement)partStack.getChildren().get(0)));
        this.getEngine().createGui((MUIElement)window);
        MPart part = (MPart)partStack.getChildren().get(1);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertFalse((boolean)partService.isPartVisible(part));
    }

    public void testIsPartVisible_ViewNotVisible_myService() {
        MApplication application = this.createApplication("partId", "partId2");
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        partStack.setSelectedElement((MUIElement)((MStackElement)partStack.getChildren().get(0)));
        this.getEngine().createGui((MUIElement)window);
        MPart part1 = (MPart)partStack.getChildren().get(0);
        MPart part2 = (MPart)partStack.getChildren().get(1);
        EPartService partService1 = (EPartService)part1.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertTrue((boolean)partService1.isPartVisible(part1));
        EPartServiceTest.assertFalse((boolean)partService1.isPartVisible(part2));
        partService1.activate(part2);
        EPartService partService2 = (EPartService)part2.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertFalse((boolean)partService1.isPartVisible(part1));
        EPartServiceTest.assertTrue((boolean)partService1.isPartVisible(part2));
        EPartServiceTest.assertFalse((boolean)partService2.isPartVisible(part1));
        EPartServiceTest.assertTrue((boolean)partService2.isPartVisible(part2));
    }

    public void testIsPartVisible_ViewInAnotherWindow() {
        MApplication application = this.createApplication(new String[][]{{"partFrontA", "partBackA"}, {"partFrontB", "partBackB"}});
        MWindow windowA = (MWindow)application.getChildren().get(0);
        MPartStack partStackA = (MPartStack)windowA.getChildren().get(0);
        MPart partFrontA = (MPart)partStackA.getChildren().get(0);
        MPart partBackA = (MPart)partStackA.getChildren().get(1);
        partStackA.setSelectedElement((MUIElement)partFrontA);
        MWindow windowB = (MWindow)application.getChildren().get(1);
        MPartStack partStackB = (MPartStack)windowB.getChildren().get(0);
        MPart partFrontB = (MPart)partStackB.getChildren().get(0);
        MPart partBackB = (MPart)partStackB.getChildren().get(1);
        partStackB.setSelectedElement((MUIElement)partFrontB);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)windowA.getContext().get(EPartService.class.getName());
        EPartService partServiceB = (EPartService)windowB.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertTrue((boolean)partServiceA.isPartVisible(partFrontA));
        EPartServiceTest.assertFalse((boolean)partServiceA.isPartVisible(partBackA));
        EPartServiceTest.assertFalse((boolean)partServiceA.isPartVisible(partFrontB));
        EPartServiceTest.assertFalse((boolean)partServiceA.isPartVisible(partBackB));
        EPartServiceTest.assertFalse((boolean)partServiceB.isPartVisible(partFrontA));
        EPartServiceTest.assertFalse((boolean)partServiceB.isPartVisible(partBackA));
        EPartServiceTest.assertTrue((boolean)partServiceB.isPartVisible(partFrontB));
        EPartServiceTest.assertFalse((boolean)partServiceB.isPartVisible(partBackB));
    }

    public void testIsPartVisible_ViewInAnotherWindow_myService() {
        MApplication application = this.createApplication(new String[][]{{"partFrontA", "partBackA"}, {"partFrontB", "partBackB"}});
        MWindow windowA = (MWindow)application.getChildren().get(0);
        MPartStack partStackA = (MPartStack)windowA.getChildren().get(0);
        MPart partFrontA = (MPart)partStackA.getChildren().get(0);
        MPart partBackA = (MPart)partStackA.getChildren().get(1);
        partStackA.setSelectedElement((MUIElement)partFrontA);
        MWindow windowB = (MWindow)application.getChildren().get(1);
        MPartStack partStackB = (MPartStack)windowB.getChildren().get(0);
        MPart partFrontB = (MPart)partStackB.getChildren().get(0);
        MPart partBackB = (MPart)partStackB.getChildren().get(1);
        partStackB.setSelectedElement((MUIElement)partFrontB);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)partFrontA.getContext().get(EPartService.class.getName());
        EPartService partServiceB = (EPartService)partFrontB.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertTrue((boolean)partServiceA.isPartVisible(partFrontA));
        EPartServiceTest.assertFalse((boolean)partServiceA.isPartVisible(partBackA));
        EPartServiceTest.assertFalse((boolean)partServiceA.isPartVisible(partFrontB));
        EPartServiceTest.assertFalse((boolean)partServiceA.isPartVisible(partBackB));
        EPartServiceTest.assertFalse((boolean)partServiceB.isPartVisible(partFrontA));
        EPartServiceTest.assertFalse((boolean)partServiceB.isPartVisible(partBackA));
        EPartServiceTest.assertTrue((boolean)partServiceB.isPartVisible(partFrontB));
        EPartServiceTest.assertFalse((boolean)partServiceB.isPartVisible(partBackB));
    }

    public void testActivate_partService() {
        MApplication application = this.createApplication("partId", "partId2");
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        partStack.setSelectedElement((MUIElement)((MStackElement)partStack.getChildren().get(0)));
        this.getEngine().createGui((MUIElement)window);
        MPart part1 = (MPart)partStack.getChildren().get(0);
        MPart part2 = (MPart)partStack.getChildren().get(1);
        EPartService partService1 = (EPartService)part1.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertTrue((boolean)partService1.isPartVisible(part1));
        EPartServiceTest.assertFalse((boolean)partService1.isPartVisible(part2));
        partService1.activate(part2);
        EPartService partService2 = (EPartService)part2.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertFalse((boolean)partService1.isPartVisible(part1));
        EPartServiceTest.assertTrue((boolean)partService1.isPartVisible(part2));
        EPartServiceTest.assertFalse((boolean)partService2.isPartVisible(part1));
        EPartServiceTest.assertTrue((boolean)partService2.isPartVisible(part2));
    }

    public void testActivate_partService_twoWindows() {
        MApplication application = this.createApplication(new String[][]{{"partFrontA", "partBackA"}, {"partFrontB", "partBackB"}});
        MWindow windowA = (MWindow)application.getChildren().get(0);
        MPartStack partStackA = (MPartStack)windowA.getChildren().get(0);
        MPart partFrontA = (MPart)partStackA.getChildren().get(0);
        MPart partBackA = (MPart)partStackA.getChildren().get(1);
        partStackA.setSelectedElement((MUIElement)partFrontA);
        windowA.setSelectedElement((MUIElement)partStackA);
        MWindow windowB = (MWindow)application.getChildren().get(1);
        MPartStack partStackB = (MPartStack)windowB.getChildren().get(0);
        MPart partFrontB = (MPart)partStackB.getChildren().get(0);
        MPart partBackB = (MPart)partStackB.getChildren().get(1);
        partStackB.setSelectedElement((MUIElement)partFrontB);
        windowB.setSelectedElement((MUIElement)partStackB);
        application.setSelectedElement((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)partFrontA.getContext().get(EPartService.class.getName());
        EPartService partServiceB = (EPartService)partFrontB.getContext().get(EPartService.class.getName());
        partServiceA.activate(partBackA);
        EPartServiceTest.assertEquals((Object)partBackA, (Object)partServiceA.getActivePart());
        EPartServiceTest.assertFalse((boolean)partServiceA.isPartVisible(partFrontA));
        EPartServiceTest.assertTrue((boolean)partServiceA.isPartVisible(partBackA));
        EPartServiceTest.assertFalse((boolean)partServiceA.isPartVisible(partFrontB));
        EPartServiceTest.assertFalse((boolean)partServiceA.isPartVisible(partBackB));
        partServiceA.activate(partBackB);
        EPartServiceTest.assertEquals((Object)partBackA, (Object)partServiceA.getActivePart());
        EPartServiceTest.assertFalse((boolean)partServiceA.isPartVisible(partFrontA));
        EPartServiceTest.assertTrue((boolean)partServiceA.isPartVisible(partBackA));
        EPartServiceTest.assertFalse((boolean)partServiceA.isPartVisible(partFrontB));
        EPartServiceTest.assertFalse((boolean)partServiceA.isPartVisible(partBackB));
        EPartServiceTest.assertFalse((boolean)partServiceB.isPartVisible(partFrontA));
        EPartServiceTest.assertFalse((boolean)partServiceB.isPartVisible(partBackA));
        EPartServiceTest.assertTrue((boolean)partServiceB.isPartVisible(partFrontB));
        EPartServiceTest.assertFalse((boolean)partServiceB.isPartVisible(partBackB));
        partServiceB.activate(partBackB);
        EPartServiceTest.assertEquals((Object)partBackB, (Object)partServiceB.getActivePart());
        EPartServiceTest.assertFalse((boolean)partServiceB.isPartVisible(partFrontA));
        EPartServiceTest.assertFalse((boolean)partServiceB.isPartVisible(partBackA));
        EPartServiceTest.assertFalse((boolean)partServiceB.isPartVisible(partFrontB));
        EPartServiceTest.assertTrue((boolean)partServiceB.isPartVisible(partBackB));
    }

    public void testActivate_partService_SelectedElement() {
        MApplication application = this.createApplication(new String[][]{{"partFrontA", "partBackA"}, {"partFrontB", "partBackB"}});
        MWindow windowA = (MWindow)application.getChildren().get(0);
        MPartStack partStackA = (MPartStack)windowA.getChildren().get(0);
        MPart partFrontA = (MPart)partStackA.getChildren().get(0);
        MPart partBackA = (MPart)partStackA.getChildren().get(1);
        partStackA.setSelectedElement((MUIElement)partFrontA);
        MWindow windowB = (MWindow)application.getChildren().get(1);
        MPartStack partStackB = (MPartStack)windowB.getChildren().get(0);
        MPart partFrontB = (MPart)partStackB.getChildren().get(0);
        MPart partBackB = (MPart)partStackB.getChildren().get(1);
        partStackB.setSelectedElement((MUIElement)partFrontB);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)partFrontA.getContext().get(EPartService.class.getName());
        EPartService partServiceB = (EPartService)partFrontB.getContext().get(EPartService.class.getName());
        partServiceA.activate(partBackA);
        EPartServiceTest.assertEquals((Object)windowA, (Object)application.getSelectedElement());
        IEclipseContext a = application.getContext();
        IEclipseContext c = (IEclipseContext)a.getLocal("activeChildContext");
        while (c != null) {
            a = c;
            c = (IEclipseContext)a.getLocal("activeChildContext");
        }
        MPart aPart = (MPart)a.get(MPart.class.getName());
        EPartServiceTest.assertEquals((Object)partBackA, (Object)aPart);
        partServiceB.activate(partBackB);
        EPartServiceTest.assertEquals((Object)windowB, (Object)application.getSelectedElement());
        a = application.getContext();
        c = (IEclipseContext)a.getLocal("activeChildContext");
        while (c != null) {
            a = c;
            c = (IEclipseContext)a.getLocal("activeChildContext");
        }
        aPart = (MPart)a.get(MPart.class.getName());
        EPartServiceTest.assertEquals((Object)partBackB, (Object)aPart);
    }

    public void testActivate_partService_activePart() {
        MApplication application = this.createApplication(new String[][]{{"partFrontA", "partBackA"}, {"partFrontB", "partBackB"}});
        MWindow windowA = (MWindow)application.getChildren().get(0);
        MPartStack partStackA = (MPartStack)windowA.getChildren().get(0);
        MPart partFrontA = (MPart)partStackA.getChildren().get(0);
        MPart partBackA = (MPart)partStackA.getChildren().get(1);
        MWindow windowB = (MWindow)application.getChildren().get(1);
        MPartStack partStackB = (MPartStack)windowB.getChildren().get(0);
        MPart partFrontB = (MPart)partStackB.getChildren().get(0);
        MPart partBackB = (MPart)partStackB.getChildren().get(1);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)partFrontA.getContext().get(EPartService.class.getName());
        EPartService partServiceB = (EPartService)partFrontB.getContext().get(EPartService.class.getName());
        partServiceA.activate(partBackA);
        EPartServiceTest.assertEquals((Object)windowA, (Object)application.getSelectedElement());
        MPart shouldBeCorrect = (MPart)partFrontA.getContext().get("e4ActivePart");
        EPartServiceTest.assertNotNull((Object)shouldBeCorrect);
        EPartServiceTest.assertEquals((Object)partBackA, (Object)partServiceA.getActivePart());
        partServiceB.activate(partBackB);
        EPartServiceTest.assertEquals((Object)windowB, (Object)application.getSelectedElement());
        shouldBeCorrect = (MPart)partFrontB.getContext().get("e4ActivePart");
        EPartServiceTest.assertNotNull((Object)shouldBeCorrect);
        EPartServiceTest.assertEquals((Object)partBackB, (Object)partServiceB.getActivePart());
    }

    public void testActivate_Unrendered() {
        MApplication application = this.createApplication("partFront", "partBack");
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart partFront = (MPart)partStack.getChildren().get(0);
        MPart partBack = (MPart)partStack.getChildren().get(1);
        partBack.setToBeRendered(false);
        partStack.setSelectedElement((MUIElement)partFront);
        window.setSelectedElement((MUIElement)partStack);
        application.setSelectedElement((MUIElement)window);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartServiceTest.assertFalse((boolean)partBack.isToBeRendered());
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        partService.activate(partBack);
        EPartServiceTest.assertTrue((String)"Activating a part should cause it to be rendered", (boolean)partBack.isToBeRendered());
    }

    public void testActivate_Focus() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.ClientEditor");
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.ClientEditor");
        window.getChildren().add(partB);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        ClientEditor editorB = (ClientEditor)partB.getObject();
        EPartServiceTest.assertFalse((boolean)editorB.wasFocusCalled());
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partB);
        EPartServiceTest.assertTrue((boolean)editorB.wasFocusCalled());
    }

    public void testCreatePart() {
        MApplication application = this.createApplication(1, new String[1][0]);
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartDescriptor partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setElementId("partId");
        application.getDescriptors().add(partDescriptor);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertNotNull((Object)partService.createPart("partId"));
    }

    public void testCreatePart2() {
        MApplication application = this.createApplication(1, new String[1][0]);
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartDescriptor partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setElementId("partId");
        application.getDescriptors().add(partDescriptor);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertNull((Object)partService.createPart("partId2"));
    }

    public void testShowPart_Id_ACTIVATE() {
        MApplication application = this.createApplication(1, new String[1][0]);
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartDescriptor partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setElementId("partId");
        application.getDescriptors().add(partDescriptor);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart part = partService.showPart("partId", EPartService.PartState.ACTIVATE);
        EPartServiceTest.assertNotNull((Object)part);
        EPartServiceTest.assertEquals((String)"partId", (String)part.getElementId());
        EPartServiceTest.assertEquals((Object)part, (Object)partService.getActivePart());
        EPartServiceTest.assertTrue((String)"Shown part should be visible", (boolean)part.isVisible());
    }

    public void testShowPart_Id_ACTIVATE_DefinedCategoryStackNotExists() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartDescriptor partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setCategory("categoryId");
        partDescriptor.setElementId("partId");
        application.getDescriptors().add(partDescriptor);
        partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setCategory("categoryId");
        partDescriptor.setElementId("partId2");
        application.getDescriptors().add(partDescriptor);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart part = partService.showPart("partId", EPartService.PartState.ACTIVATE);
        EPartServiceTest.assertEquals((int)1, (int)window.getChildren().size());
        EPartServiceTest.assertTrue((boolean)(window.getChildren().get(0) instanceof MPartStack));
        MPartStack stack = (MPartStack)window.getChildren().get(0);
        EPartServiceTest.assertTrue((boolean)stack.getTags().contains("categoryId"));
        EPartServiceTest.assertEquals((int)1, (int)stack.getChildren().size());
        EPartServiceTest.assertEquals((Object)part, stack.getChildren().get(0));
        EPartServiceTest.assertEquals((Object)part, (Object)stack.getSelectedElement());
        MPart part2 = partService.showPart("partId2", EPartService.PartState.ACTIVATE);
        EPartServiceTest.assertEquals((int)2, (int)stack.getChildren().size());
        EPartServiceTest.assertEquals((Object)part, stack.getChildren().get(0));
        EPartServiceTest.assertEquals((Object)part2, stack.getChildren().get(1));
        EPartServiceTest.assertEquals((Object)part2, (Object)stack.getSelectedElement());
    }

    public void testShowPart_Id_ACTIVATE_DefinedCategoryStackExists() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartDescriptor partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setCategory("categoryId");
        partDescriptor.setElementId("partId");
        application.getDescriptors().add(partDescriptor);
        partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setCategory("categoryId");
        partDescriptor.setElementId("partId2");
        application.getDescriptors().add(partDescriptor);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        stack.getTags().add("categoryId");
        window.getChildren().add(stack);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart part = partService.showPart("partId", EPartService.PartState.ACTIVATE);
        EPartServiceTest.assertEquals((int)1, (int)stack.getChildren().size());
        EPartServiceTest.assertEquals((Object)part, stack.getChildren().get(0));
        EPartServiceTest.assertEquals((Object)part, (Object)stack.getSelectedElement());
        MPart part2 = partService.showPart("partId2", EPartService.PartState.ACTIVATE);
        EPartServiceTest.assertEquals((int)2, (int)stack.getChildren().size());
        EPartServiceTest.assertEquals((Object)part, stack.getChildren().get(0));
        EPartServiceTest.assertEquals((Object)part2, stack.getChildren().get(1));
        EPartServiceTest.assertEquals((Object)part2, (Object)stack.getSelectedElement());
    }

    public void testShowPart_Id_CREATE() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack partStackA = BasicFactoryImpl.eINSTANCE.createPartStack();
        MPartStack partStackB = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(partStackA);
        window.getChildren().add(partStackB);
        MPart partA1 = BasicFactoryImpl.eINSTANCE.createPart();
        MPart partA2 = BasicFactoryImpl.eINSTANCE.createPart();
        partA1.setElementId("partA1");
        partA2.setElementId("partA2");
        partStackA.getChildren().add(partA1);
        partStackA.getChildren().add(partA2);
        MPart partB1 = BasicFactoryImpl.eINSTANCE.createPart();
        MPart partB2 = BasicFactoryImpl.eINSTANCE.createPart();
        partB1.setElementId("partB1");
        partB2.setElementId("partB2");
        partStackB.getChildren().add(partB1);
        partStackB.getChildren().add(partB2);
        partStackA.setSelectedElement((MUIElement)partA1);
        partStackB.setSelectedElement((MUIElement)partB1);
        window.setSelectedElement((MUIElement)partStackA);
        application.setSelectedElement((MUIElement)window);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        partService.activate(partA1);
        EPartServiceTest.assertEquals((Object)partA1, (Object)partService.getActivePart());
        EPartServiceTest.assertEquals(null, (Object)partA2.getContext());
        EPartServiceTest.assertEquals(null, (Object)partB2.getContext());
        MPart shownPart = partService.showPart("partA2", EPartService.PartState.CREATE);
        EPartServiceTest.assertTrue((boolean)partService.isPartVisible(partA1));
        EPartServiceTest.assertTrue((boolean)partService.isPartVisible(partB1));
        EPartServiceTest.assertEquals((Object)partA1, (Object)partService.getActivePart());
        EPartServiceTest.assertEquals((Object)shownPart, (Object)partA2);
        EPartServiceTest.assertNotNull((String)"The part should have been created so it should have a context", (Object)partA2.getContext());
        EPartServiceTest.assertEquals((String)"This part has not been instantiated yet, it should have no context", null, (Object)partB2.getContext());
        shownPart = partService.showPart("partB2", EPartService.PartState.CREATE);
        EPartServiceTest.assertTrue((boolean)partService.isPartVisible(partA1));
        EPartServiceTest.assertTrue((boolean)partService.isPartVisible(partB1));
        EPartServiceTest.assertEquals((Object)partA1, (Object)partService.getActivePart());
        EPartServiceTest.assertEquals((Object)shownPart, (Object)partB2);
        EPartServiceTest.assertNotNull((String)"The part should have been created so it should have a context", (Object)partA2.getContext());
        EPartServiceTest.assertNotNull((String)"The part should have been created so it should have a context", (Object)partB2.getContext());
    }

    public void testShowPart_Id_CREATE2() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartDescriptor partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setElementId("partB");
        partDescriptor.setCategory("aCategory");
        application.getDescriptors().add(partDescriptor);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        partStack.setElementId("aCategory");
        window.getChildren().add(partStack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        window.setSelectedElement((MUIElement)partStack);
        application.setSelectedElement((MUIElement)window);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        partService.activate(partA);
        EPartServiceTest.assertEquals((Object)partA, (Object)partService.getActivePart());
        MPart partB = partService.showPart("partB", EPartService.PartState.CREATE);
        EPartServiceTest.assertEquals((int)2, (int)partStack.getChildren().size());
        EPartServiceTest.assertEquals((String)"Only creating the part, the active part should not have changed", (Object)partA, (Object)partService.getActivePart());
        EPartServiceTest.assertNotNull((String)"The shown part should have a context", (Object)partB.getContext());
        EPartServiceTest.assertFalse((boolean)partService.isPartVisible(partB));
    }

    public void testShowPart_Id_CREATE3() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartDescriptor partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setElementId("partB");
        partDescriptor.setCategory("aCategory");
        application.getDescriptors().add(partDescriptor);
        MPartStack partStackA = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(partStackA);
        MPartStack partStackB = BasicFactoryImpl.eINSTANCE.createPartStack();
        partStackB.getTags().add("aCategory");
        window.getChildren().add(partStackB);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partStackA.getChildren().add(partA);
        partStackA.setSelectedElement((MUIElement)partA);
        window.setSelectedElement((MUIElement)partStackA);
        application.setSelectedElement((MUIElement)window);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        partService.activate(partA);
        EPartServiceTest.assertEquals((Object)partA, (Object)partService.getActivePart());
        MPart partB = partService.showPart("partB", EPartService.PartState.CREATE);
        EPartServiceTest.assertEquals((int)1, (int)partStackA.getChildren().size());
        EPartServiceTest.assertEquals((String)"Only creating the part, the active part should not have changed", (Object)partA, (Object)partService.getActivePart());
        EPartServiceTest.assertNotNull((String)"The shown part should have a context", (Object)partB.getContext());
        EPartServiceTest.assertTrue((String)"The part is the only one in the stack, it should be visible", (boolean)partService.isPartVisible(partB));
    }

    public void testShowPart_Id_CREATE4() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        stack.getTags().add("stackId");
        window.getChildren().add(stack);
        MPartDescriptor partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setElementId("part");
        partDescriptor.setCategory("stackId");
        application.getDescriptors().add(partDescriptor);
        application.setSelectedElement((MUIElement)window);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart part = partService.showPart("part", EPartService.PartState.CREATE);
        EPartServiceTest.assertEquals((int)1, (int)stack.getChildren().size());
        EPartServiceTest.assertEquals((Object)part, stack.getChildren().get(0));
        EPartServiceTest.assertEquals((Object)part, (Object)partService.getActivePart());
    }

    public void testShowPart_Id_VISIBLE() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack partStackA = BasicFactoryImpl.eINSTANCE.createPartStack();
        MPartStack partStackB = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(partStackA);
        window.getChildren().add(partStackB);
        MPart partA1 = BasicFactoryImpl.eINSTANCE.createPart();
        MPart partA2 = BasicFactoryImpl.eINSTANCE.createPart();
        partA1.setElementId("partA1");
        partA2.setElementId("partA2");
        partStackA.getChildren().add(partA1);
        partStackA.getChildren().add(partA2);
        MPart partB1 = BasicFactoryImpl.eINSTANCE.createPart();
        MPart partB2 = BasicFactoryImpl.eINSTANCE.createPart();
        partB1.setElementId("partB1");
        partB2.setElementId("partB2");
        partStackB.getChildren().add(partB1);
        partStackB.getChildren().add(partB2);
        partStackA.setSelectedElement((MUIElement)partA1);
        partStackB.setSelectedElement((MUIElement)partB1);
        window.setSelectedElement((MUIElement)partStackA);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        partService.activate(partA1);
        EPartServiceTest.assertEquals((Object)partA1, (Object)partService.getActivePart());
        MPart shownPart = partService.showPart("partB1", EPartService.PartState.VISIBLE);
        EPartServiceTest.assertTrue((boolean)partService.isPartVisible(partA1));
        EPartServiceTest.assertTrue((boolean)partService.isPartVisible(partB1));
        EPartServiceTest.assertEquals((Object)partA1, (Object)partService.getActivePart());
        EPartServiceTest.assertEquals((Object)partB1, (Object)shownPart);
        shownPart = partService.showPart("partB2", EPartService.PartState.VISIBLE);
        EPartServiceTest.assertTrue((boolean)partService.isPartVisible(partA1));
        EPartServiceTest.assertTrue((boolean)partService.isPartVisible(partB2));
        EPartServiceTest.assertEquals((Object)partA1, (Object)partService.getActivePart());
        EPartServiceTest.assertEquals((Object)partB2, (Object)shownPart);
    }

    public void testShowPart_Id_VISIBLE2() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartDescriptor partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setElementId("partB");
        partDescriptor.setCategory("aCategory");
        application.getDescriptors().add(partDescriptor);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        partStack.setElementId("aCategory");
        window.getChildren().add(partStack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        window.setSelectedElement((MUIElement)partStack);
        application.setSelectedElement((MUIElement)window);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        partService.activate(partA);
        EPartServiceTest.assertEquals((Object)partA, (Object)partService.getActivePart());
        MPart partB = partService.showPart("partB", EPartService.PartState.VISIBLE);
        EPartServiceTest.assertEquals((int)2, (int)partStack.getChildren().size());
        EPartServiceTest.assertEquals((String)"The part is in the same stack as the active part, so the active part should not have changed", (Object)partA, (Object)partService.getActivePart());
        EPartServiceTest.assertNotNull((String)"The shown part should have a context", (Object)partB.getContext());
        EPartServiceTest.assertTrue((boolean)partService.isPartVisible(partA));
        EPartServiceTest.assertFalse((boolean)partService.isPartVisible(partB));
    }

    public void testShowPart_Id_VISIBLE3() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartDescriptor partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setElementId("partB");
        partDescriptor.setCategory("aCategory");
        application.getDescriptors().add(partDescriptor);
        MPartStack partStackA = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(partStackA);
        MPartStack partStackB = BasicFactoryImpl.eINSTANCE.createPartStack();
        partStackB.getTags().add("aCategory");
        window.getChildren().add(partStackB);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partStackA.getChildren().add(partA);
        partStackA.setSelectedElement((MUIElement)partA);
        window.setSelectedElement((MUIElement)partStackA);
        application.setSelectedElement((MUIElement)window);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        partService.activate(partA);
        EPartServiceTest.assertEquals((Object)partA, (Object)partService.getActivePart());
        MPart partB = partService.showPart("partB", EPartService.PartState.VISIBLE);
        EPartServiceTest.assertEquals((int)1, (int)partStackA.getChildren().size());
        EPartServiceTest.assertEquals((String)"Only making a part visible, the active part should not have changed", (Object)partA, (Object)partService.getActivePart());
        EPartServiceTest.assertNotNull((String)"The shown part should have a context", (Object)partB.getContext());
        EPartServiceTest.assertTrue((String)"The part is the only one in the stack, it should be visible", (boolean)partService.isPartVisible(partB));
    }

    public void testShowPart_Id_VISIBLE4() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        stack.getTags().add("stackId");
        window.getChildren().add(stack);
        MPartDescriptor partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setElementId("part");
        partDescriptor.setCategory("stackId");
        application.getDescriptors().add(partDescriptor);
        application.setSelectedElement((MUIElement)window);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart part = partService.showPart("part", EPartService.PartState.VISIBLE);
        EPartServiceTest.assertEquals((int)1, (int)stack.getChildren().size());
        EPartServiceTest.assertEquals((Object)part, stack.getChildren().get(0));
        EPartServiceTest.assertEquals((Object)part, (Object)partService.getActivePart());
    }

    public void testShowPart_Id_VISIBLE5() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartDescriptor partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setElementId("partB");
        partDescriptor.setCategory("aCategory");
        application.getDescriptors().add(partDescriptor);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        partStack.setElementId("aCategory");
        window.getChildren().add(partStack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partStack.getChildren().add(partA);
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setElementId("partB");
        partB.setToBeRendered(false);
        partStack.getChildren().add(partB);
        partStack.setSelectedElement((MUIElement)partA);
        window.setSelectedElement((MUIElement)partStack);
        application.setSelectedElement((MUIElement)window);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        partService.activate(partA);
        EPartServiceTest.assertEquals((Object)partA, (Object)partService.getActivePart());
        MPart shownPart = partService.showPart("partB", EPartService.PartState.VISIBLE);
        EPartServiceTest.assertEquals((int)2, (int)partStack.getChildren().size());
        EPartServiceTest.assertEquals((String)"The part is in the same stack as the active part, so the active part should not have changed", (Object)partA, (Object)partService.getActivePart());
        EPartServiceTest.assertNotNull((String)"The shown part should have a context", (Object)partB.getContext());
        EPartServiceTest.assertTrue((boolean)partService.isPartVisible(partA));
        EPartServiceTest.assertFalse((boolean)partService.isPartVisible(partB));
        EPartServiceTest.assertEquals((Object)partB, (Object)shownPart);
        EPartServiceTest.assertTrue((boolean)partB.isToBeRendered());
    }

    private void testShowPart_Id_Unrendered(EPartService.PartState partState) {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setElementId("partId");
        part.setToBeRendered(false);
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart shownPart = partService.showPart("partId", partState);
        EPartServiceTest.assertEquals((int)1, (int)window.getChildren().size());
        EPartServiceTest.assertEquals((Object)part, window.getChildren().get(0));
        EPartServiceTest.assertEquals((Object)part, (Object)shownPart);
        EPartServiceTest.assertTrue((String)"A shown part should be rendered", (boolean)part.isToBeRendered());
    }

    public void testShowPart_Id_Unrendered_CREATE() {
        this.testShowPart_Id_Unrendered(EPartService.PartState.CREATE);
    }

    public void testShowPart_Id_Unrendered_VISIBLE() {
        this.testShowPart_Id_Unrendered(EPartService.PartState.VISIBLE);
    }

    public void testShowPart_Id_Unrendered_ACTIVATE() {
        this.testShowPart_Id_Unrendered(EPartService.PartState.ACTIVATE);
    }

    private void testShowPart_Id_Unrendered2(EPartService.PartState partState) {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        window.setToBeRendered(true);
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        partStack.setToBeRendered(false);
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setElementId("partId");
        part.setToBeRendered(false);
        partStack.getChildren().add(part);
        partStack.setSelectedElement((MUIElement)part);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart shownPart = partService.showPart("partId", partState);
        EPartServiceTest.assertEquals((int)1, (int)partStack.getChildren().size());
        EPartServiceTest.assertEquals((Object)part, partStack.getChildren().get(0));
        EPartServiceTest.assertEquals((Object)part, (Object)shownPart);
        EPartServiceTest.assertTrue((String)"A shown part should be rendered", (boolean)part.isToBeRendered());
    }

    public void testShowPart_Id_Unrendered_CREATE2() {
        this.testShowPart_Id_Unrendered2(EPartService.PartState.CREATE);
    }

    public void testShowPart_Id_Unrendered_VISIBLE2() {
        this.testShowPart_Id_Unrendered2(EPartService.PartState.VISIBLE);
    }

    public void testShowPart_Id_Unrendered_ACTIVATE2() {
        this.testShowPart_Id_Unrendered2(EPartService.PartState.ACTIVATE);
    }

    private void testShowPart_Id_Unrendered3(EPartService.PartState partState) {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        window.setToBeRendered(true);
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartSashContainer partSashContainer = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        partSashContainer.setToBeRendered(false);
        window.getChildren().add(partSashContainer);
        window.setSelectedElement((MUIElement)partSashContainer);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        partStack.setToBeRendered(false);
        partSashContainer.getChildren().add(partStack);
        partSashContainer.setSelectedElement((MUIElement)partStack);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setElementId("partId");
        part.setToBeRendered(false);
        partStack.getChildren().add(part);
        partStack.setSelectedElement((MUIElement)part);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart shownPart = partService.showPart("partId", partState);
        EPartServiceTest.assertEquals((int)1, (int)partStack.getChildren().size());
        EPartServiceTest.assertEquals((Object)part, partStack.getChildren().get(0));
        EPartServiceTest.assertEquals((Object)part, (Object)shownPart);
        EPartServiceTest.assertTrue((String)"A shown part should be rendered", (boolean)part.isToBeRendered());
    }

    public void testShowPart_Id_Unrendered_CREATE3() {
        this.testShowPart_Id_Unrendered3(EPartService.PartState.CREATE);
    }

    public void testShowPart_Id_Unrendered_VISIBLE3() {
        this.testShowPart_Id_Unrendered3(EPartService.PartState.VISIBLE);
    }

    public void testShowPart_Id_Unrendered_ACTIVATE3() {
        this.testShowPart_Id_Unrendered3(EPartService.PartState.ACTIVATE);
    }

    private void testShowPart_Id_PartAlreadyShown(EPartService.PartState partState) {
        MApplication application = this.createApplication(1, new String[1][0]);
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartDescriptor partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setElementId("partId");
        application.getDescriptors().add(partDescriptor);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart part = partService.showPart("partId", partState);
        EPartServiceTest.assertNotNull((Object)part);
        EPartServiceTest.assertEquals((String)"partId", (String)part.getElementId());
        EPartServiceTest.assertEquals((Object)part, (Object)partService.getActivePart());
        MPart part2 = partService.showPart("partId", partState);
        EPartServiceTest.assertEquals((String)"Should not have instantiated a new MPart", (Object)part, (Object)part2);
        EPartServiceTest.assertEquals((Object)part, (Object)partService.getActivePart());
    }

    public void testShowPart_Id_PartAlreadyShown_ACTIVATE() {
        this.testShowPart_Id_PartAlreadyShown(EPartService.PartState.ACTIVATE);
    }

    public void testShowPart_Id_PartAlreadyShown_CREATE() {
        this.testShowPart_Id_PartAlreadyShown(EPartService.PartState.CREATE);
    }

    public void testShowPart_Id_PartAlreadyShown_VISIBLE() {
        this.testShowPart_Id_PartAlreadyShown(EPartService.PartState.VISIBLE);
    }

    private void testShowPart_Id_IncorrectDescriptor(EPartService.PartState partState) {
        MApplication application = this.createApplication(1, new String[1][0]);
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartDescriptor partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setElementId("partId");
        application.getDescriptors().add(partDescriptor);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertNull((Object)partService.showPart("partId2", partState));
    }

    public void testShowPart_Id_IncorrectDescriptor_ACTIVATE() {
        this.testShowPart_Id_IncorrectDescriptor(EPartService.PartState.ACTIVATE);
    }

    public void testShowPart_Id_IncorrectDescriptor_VISIBLE() {
        this.testShowPart_Id_IncorrectDescriptor(EPartService.PartState.VISIBLE);
    }

    public void testShowPart_Id_IncorrectDescriptor_CREATE() {
        this.testShowPart_Id_IncorrectDescriptor(EPartService.PartState.CREATE);
    }

    private void testShowPart_Id_MultipleExists(boolean multipleAllowed, EPartService.PartState partState) {
        MApplication application = this.createApplication("partId");
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartStack stack = (MPartStack)window.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        MPartDescriptor partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setAllowMultiple(multipleAllowed);
        partDescriptor.setElementId("partId");
        application.getDescriptors().add(partDescriptor);
        stack.setSelectedElement((MUIElement)part);
        window.setSelectedElement((MUIElement)stack);
        application.setSelectedElement((MUIElement)window);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart shownPart = partService.showPart("partId", partState);
        EPartServiceTest.assertNotNull((Object)shownPart);
        EPartServiceTest.assertEquals((Object)part, (Object)shownPart);
    }

    public void testShowPart_Id_MultipleExists_TrueACTIVATE() {
        this.testShowPart_Id_MultipleExists(true, EPartService.PartState.ACTIVATE);
    }

    public void testShowPart_Id_MultipleExists_FalseACTIVATE() {
        this.testShowPart_Id_MultipleExists(false, EPartService.PartState.ACTIVATE);
    }

    public void testShowPart_Id_MultipleExists_TrueVISIBLE() {
        this.testShowPart_Id_MultipleExists(true, EPartService.PartState.VISIBLE);
    }

    public void testShowPart_Id_MultipleExists_FalseVISIBLE() {
        this.testShowPart_Id_MultipleExists(false, EPartService.PartState.VISIBLE);
    }

    public void testShowPart_Id_MultipleExists_TrueCREATE() {
        this.testShowPart_Id_MultipleExists(true, EPartService.PartState.CREATE);
    }

    public void testShowPart_Id_MultipleExists_FalseCREATE() {
        this.testShowPart_Id_MultipleExists(false, EPartService.PartState.CREATE);
    }

    public void testShowPart_Id_PartInInactivePerspective() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPerspective perspectiveB = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspectiveB);
        MPartDescriptor partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setElementId("partId");
        application.getDescriptors().add(partDescriptor);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart part = partService.showPart("partId", EPartService.PartState.ACTIVATE);
        MElementContainer parent = part.getParent();
        while (parent != null) {
            if (parent == perspectiveA) break;
            if (parent == perspectiveB) {
                EPartServiceTest.fail((String)"Parent should not have been perspectiveB");
            }
            parent = parent.getParent();
        }
        EPartServiceTest.assertNotNull((Object)parent);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveB);
        window.getContext().set("activeChildContext", (Object)perspectiveB.getContext());
        MPart part2 = partService.showPart("partId", EPartService.PartState.ACTIVATE);
        parent = part2.getParent();
        while (parent != null) {
            if (parent == perspectiveB) break;
            if (parent == perspectiveA) {
                EPartServiceTest.fail((String)"Parent should not have been perspectiveA");
            }
            parent = parent.getParent();
        }
        EPartServiceTest.assertNotNull((Object)parent);
        EPartServiceTest.assertFalse((part == part2 ? 1 : 0) != 0);
    }

    private void testShowPart_Part(EPartService.PartState partState) {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartDescriptor partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setElementId("partId");
        application.getDescriptors().add(partDescriptor);
        application.setSelectedElement((MUIElement)window);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart part = partService.createPart("partId");
        partService.showPart(part, partState);
    }

    public void testShowPart_Part_ACTIVATE() {
        this.testShowPart_Part(EPartService.PartState.ACTIVATE);
    }

    public void testShowPart_Part_VISIBLE() {
        this.testShowPart_Part(EPartService.PartState.VISIBLE);
    }

    public void testShowPart_Part_CREATE() {
        this.testShowPart_Part(EPartService.PartState.CREATE);
    }

    private void testShowPart_Part_MultipleExists(boolean multipleAllowed, EPartService.PartState partState) {
        MApplication application = this.createApplication("partId");
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartStack stack = (MPartStack)window.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        MPartDescriptor partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setAllowMultiple(multipleAllowed);
        partDescriptor.setElementId("partId");
        application.getDescriptors().add(partDescriptor);
        stack.setSelectedElement((MUIElement)part);
        window.setSelectedElement((MUIElement)stack);
        application.setSelectedElement((MUIElement)window);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart createdPart = partService.createPart("partId");
        MPart shownPart = partService.showPart(createdPart, partState);
        EPartServiceTest.assertNotNull((Object)shownPart);
        if (multipleAllowed) {
            EPartServiceTest.assertEquals((Object)createdPart, (Object)shownPart);
        } else {
            EPartServiceTest.assertEquals((Object)part, (Object)shownPart);
        }
    }

    public void testShowPart_Part_MultipleExists_TrueACTIVATE() {
        this.testShowPart_Part_MultipleExists(true, EPartService.PartState.ACTIVATE);
    }

    public void testShowPart_Part_MultipleExists_FalseACTIVATE() {
        this.testShowPart_Part_MultipleExists(false, EPartService.PartState.ACTIVATE);
    }

    public void testShowPart_Part_MultipleExists_TrueVISIBLE() {
        this.testShowPart_Part_MultipleExists(true, EPartService.PartState.VISIBLE);
    }

    public void testShowPart_Part_MultipleExists_FalseVISIBLE() {
        this.testShowPart_Part_MultipleExists(false, EPartService.PartState.VISIBLE);
    }

    public void testShowPart_Part_MultipleExists_TrueCREATE() {
        this.testShowPart_Part_MultipleExists(true, EPartService.PartState.CREATE);
    }

    public void testShowPart_Part_MultipleExists_FalseCREATE() {
        this.testShowPart_Part_MultipleExists(false, EPartService.PartState.CREATE);
    }

    private void testShowPart_Part_MultipleNonexistent(boolean multipleAllowed, EPartService.PartState partState) {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartDescriptor partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setAllowMultiple(multipleAllowed);
        partDescriptor.setElementId("partId");
        application.getDescriptors().add(partDescriptor);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart createdPart = partService.createPart("partId");
        MPart shownPart = partService.showPart(createdPart, partState);
        EPartServiceTest.assertNotNull((Object)shownPart);
        EPartServiceTest.assertEquals((Object)createdPart, (Object)shownPart);
    }

    public void testShowPart_Part_MultipleNonexistent_TrueACTIVATE() {
        this.testShowPart_Part_MultipleNonexistent(true, EPartService.PartState.ACTIVATE);
    }

    public void testShowPart_Part_MultipleNonexistent_FalseACTIVATE() {
        this.testShowPart_Part_MultipleNonexistent(false, EPartService.PartState.ACTIVATE);
    }

    public void testShowPart_Part_MultipleNonexistent_TrueVISIBLE() {
        this.testShowPart_Part_MultipleNonexistent(true, EPartService.PartState.VISIBLE);
    }

    public void testShowPart_Part_MultipleNonexistent_FalseVISIBLE() {
        this.testShowPart_Part_MultipleNonexistent(false, EPartService.PartState.VISIBLE);
    }

    public void testShowPart_Part_MultipleNonexistent_TrueCREATE() {
        this.testShowPart_Part_MultipleNonexistent(true, EPartService.PartState.CREATE);
    }

    public void testShowPart_Part_MultipleNonexistent_FalseCREATE() {
        this.testShowPart_Part_MultipleNonexistent(false, EPartService.PartState.CREATE);
    }

    public void testShowPart_Part_MultipleWithoutCategory() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartDescriptor partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setAllowMultiple(true);
        partDescriptor.setElementId("partId");
        application.getDescriptors().add(partDescriptor);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart createdPart = partService.createPart("partId");
        MPart shownPart = partService.showPart(createdPart, EPartService.PartState.ACTIVATE);
        EPartServiceTest.assertNotNull((Object)shownPart);
        EPartServiceTest.assertEquals((Object)createdPart, (Object)shownPart);
        MPart createdPart2 = partService.createPart("partId");
        MPart shownPart2 = partService.showPart(createdPart2, EPartService.PartState.ACTIVATE);
        EPartServiceTest.assertFalse((boolean)shownPart.equals(shownPart2));
    }

    public void testShowPart_Part_MultipleWithCategory() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        stack.getTags().add("categoryId");
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        MPartDescriptor descriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        descriptor.setAllowMultiple(true);
        descriptor.setElementId("partId");
        descriptor.setCategory("categoryId");
        application.getDescriptors().add(descriptor);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart createdPart = partService.createPart("partId");
        MPart shownPart = partService.showPart(createdPart, EPartService.PartState.ACTIVATE);
        EPartServiceTest.assertNotNull((Object)shownPart);
        EPartServiceTest.assertEquals((Object)createdPart, (Object)shownPart);
        MPart createdPart2 = partService.createPart("partId");
        MPart shownPart2 = partService.showPart(createdPart2, EPartService.PartState.ACTIVATE);
        EPartServiceTest.assertFalse((boolean)shownPart.equals(shownPart2));
        EPartServiceTest.assertTrue((boolean)stack.getChildren().contains(shownPart));
        EPartServiceTest.assertTrue((boolean)stack.getChildren().contains(shownPart2));
    }

    public void testShowPart_Part_ExistingInNonstandardCategory() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        stack.setElementId("categoryId2");
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setElementId("partId");
        stack.getChildren().add(part);
        stack.setSelectedElement((MUIElement)part);
        MPartDescriptor descriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        descriptor.setAllowMultiple(true);
        descriptor.setElementId("partId");
        descriptor.setCategory("categoryId");
        application.getDescriptors().add(descriptor);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart shownPart = partService.showPart("partId", EPartService.PartState.ACTIVATE);
        EPartServiceTest.assertEquals((Object)part, (Object)shownPart);
        EPartServiceTest.assertEquals((Object)stack, (Object)part.getParent());
    }

    public void testHidePart_PartInAnotherWindow() {
        MApplication application = this.createApplication(new String[][]{{"partInWindow1"}, {"partInWindow2"}});
        MWindow window1 = (MWindow)application.getChildren().get(0);
        MWindow window2 = (MWindow)application.getChildren().get(1);
        this.getEngine().createGui((MUIElement)window1);
        this.getEngine().createGui((MUIElement)window2);
        EPartService partService1 = (EPartService)window1.getContext().get(EPartService.class.getName());
        EPartService partService2 = (EPartService)window2.getContext().get(EPartService.class.getName());
        MPart part1 = partService1.findPart("partInWindow1");
        MPart part2 = partService2.findPart("partInWindow2");
        EPartServiceTest.assertTrue((boolean)part1.isToBeRendered());
        EPartServiceTest.assertTrue((boolean)part2.isToBeRendered());
        partService1.hidePart(part2);
        EPartServiceTest.assertTrue((boolean)part1.isToBeRendered());
        EPartServiceTest.assertTrue((boolean)part2.isToBeRendered());
        partService2.hidePart(part1);
        EPartServiceTest.assertTrue((boolean)part1.isToBeRendered());
        EPartServiceTest.assertTrue((boolean)part2.isToBeRendered());
        partService1.hidePart(part1);
        EPartServiceTest.assertFalse((boolean)part1.isToBeRendered());
        EPartServiceTest.assertTrue((boolean)part2.isToBeRendered());
        partService2.hidePart(part2);
        EPartServiceTest.assertFalse((boolean)part1.isToBeRendered());
        EPartServiceTest.assertFalse((boolean)part2.isToBeRendered());
    }

    private void testHidePart_Tagged(boolean tagged) {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        if (tagged) {
            part.getTags().add("removeOnHide");
        }
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        partService.hidePart(part);
        EPartServiceTest.assertFalse((boolean)part.isToBeRendered());
        EPartServiceTest.assertEquals((Object)(tagged ? null : window), (Object)part.getParent());
    }

    public void testHidePart_Tagged_True() {
        this.testHidePart_Tagged(true);
    }

    public void testHidePart_Tagged_False() {
        this.testHidePart_Tagged(false);
    }

    public void testGetDirtyParts() {
        MApplication application = this.createApplication(1, new String[1][0]);
        MWindow window = (MWindow)application.getChildren().get(0);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        Collection dirtyParts = partService.getDirtyParts();
        EPartServiceTest.assertNotNull((Object)dirtyParts);
        EPartServiceTest.assertEquals((int)0, (int)dirtyParts.size());
    }

    public void testGetDirtyParts2() {
        MApplication application = this.createApplication("partId");
        MWindow window = (MWindow)application.getChildren().get(0);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        Collection dirtyParts = partService.getDirtyParts();
        EPartServiceTest.assertNotNull((Object)dirtyParts);
        EPartServiceTest.assertEquals((int)0, (int)dirtyParts.size());
    }

    private void testGetDirtyParts3(boolean before, boolean after) {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPart saveablePart = BasicFactoryImpl.eINSTANCE.createPart();
        saveablePart.setDirty(before);
        window.getChildren().add(saveablePart);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        Collection dirtyParts = partService.getDirtyParts();
        EPartServiceTest.assertNotNull((Object)dirtyParts);
        if (before) {
            EPartServiceTest.assertEquals((int)1, (int)dirtyParts.size());
            EPartServiceTest.assertEquals((Object)saveablePart, dirtyParts.iterator().next());
        } else {
            EPartServiceTest.assertEquals((int)0, (int)dirtyParts.size());
        }
        saveablePart.setDirty(after);
        dirtyParts = partService.getDirtyParts();
        if (after) {
            EPartServiceTest.assertEquals((int)1, (int)dirtyParts.size());
            EPartServiceTest.assertEquals((Object)saveablePart, dirtyParts.iterator().next());
        } else {
            EPartServiceTest.assertEquals((int)0, (int)dirtyParts.size());
        }
    }

    public void testGetDirtyParts3_TrueTrue() {
        this.testGetDirtyParts3(true, true);
    }

    public void testGetDirtyParts3_TrueFalse() {
        this.testGetDirtyParts3(true, false);
    }

    public void testGetDirtyParts3_FalseTrue() {
        this.testGetDirtyParts3(false, true);
    }

    public void testGetDirtyParts3_FalseFalse() {
        this.testGetDirtyParts3(false, false);
    }

    public void testEvent_PartActivated() {
        MApplication application = this.createApplication("partFront", "partBack");
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart partFront = (MPart)partStack.getChildren().get(0);
        MPart partBack = (MPart)partStack.getChildren().get(1);
        partStack.setSelectedElement((MUIElement)partFront);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertEquals((Object)partFront, (Object)partService.getActivePart());
        PartListener partListener = new PartListener();
        partService.addPartListener((IPartListener)partListener);
        partService.activate(partBack);
        EPartServiceTest.assertEquals((int)1, (int)partListener.getActivated());
        EPartServiceTest.assertEquals((Object)partBack, (Object)partListener.getActivatedParts().get(0));
        EPartServiceTest.assertTrue((boolean)partListener.isValid());
    }

    public void testEvent_PartActivated2() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow windowA = BasicFactoryImpl.eINSTANCE.createWindow();
        MWindow windowB = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(windowA);
        application.getChildren().add(windowB);
        application.setSelectedElement((MUIElement)windowA);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        windowB.getChildren().add(stack);
        windowB.setSelectedElement((MUIElement)stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        stack.setSelectedElement((MUIElement)partA);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)windowA.getContext().get(EPartService.class.getName());
        EPartService partServiceB = (EPartService)windowB.getContext().get(EPartService.class.getName());
        PartListener partListener = new PartListener();
        partServiceA.addPartListener((IPartListener)partListener);
        partServiceB.activate(partB);
        EPartServiceTest.assertEquals((int)0, (int)partListener.getActivated());
        EPartServiceTest.assertEquals((int)0, (int)partListener.getActivatedParts().size());
        EPartServiceTest.assertTrue((boolean)partListener.isValid());
        partListener.clear();
        partServiceB.activate(partA);
        EPartServiceTest.assertEquals((int)0, (int)partListener.getActivated());
        EPartServiceTest.assertEquals((int)0, (int)partListener.getActivatedParts().size());
        EPartServiceTest.assertTrue((boolean)partListener.isValid());
    }

    public void testEvent_PartDeactivated() {
        MApplication application = this.createApplication("partFront", "partBack");
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart partFront = (MPart)partStack.getChildren().get(0);
        MPart partBack = (MPart)partStack.getChildren().get(1);
        partStack.setSelectedElement((MUIElement)partFront);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertEquals((Object)partFront, (Object)partService.getActivePart());
        PartListener partListener = new PartListener();
        partService.addPartListener((IPartListener)partListener);
        partService.activate(partBack);
        EPartServiceTest.assertEquals((int)1, (int)partListener.getDeactivated());
        EPartServiceTest.assertEquals((Object)partFront, (Object)partListener.getDeactivatedParts().get(0));
        EPartServiceTest.assertTrue((boolean)partListener.isValid());
    }

    public void testEvent_PartDeactivated2() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow windowA = BasicFactoryImpl.eINSTANCE.createWindow();
        MWindow windowB = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(windowA);
        application.getChildren().add(windowB);
        application.setSelectedElement((MUIElement)windowA);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        windowB.getChildren().add(stack);
        windowB.setSelectedElement((MUIElement)stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        stack.setSelectedElement((MUIElement)partA);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)windowA.getContext().get(EPartService.class.getName());
        EPartService partServiceB = (EPartService)windowB.getContext().get(EPartService.class.getName());
        PartListener partListener = new PartListener();
        partServiceA.addPartListener((IPartListener)partListener);
        partServiceB.activate(partB);
        EPartServiceTest.assertEquals((int)0, (int)partListener.getDeactivated());
        EPartServiceTest.assertEquals((int)0, (int)partListener.getDeactivatedParts().size());
        EPartServiceTest.assertTrue((boolean)partListener.isValid());
        partListener.clear();
        partServiceB.activate(partA);
        EPartServiceTest.assertEquals((int)0, (int)partListener.getDeactivated());
        EPartServiceTest.assertEquals((int)0, (int)partListener.getDeactivatedParts().size());
        EPartServiceTest.assertTrue((boolean)partListener.isValid());
    }

    public void testEvent_PartHidden() {
        MApplication application = this.createApplication("partFront", "partBack");
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart partFront = (MPart)partStack.getChildren().get(0);
        MPart partBack = (MPart)partStack.getChildren().get(1);
        partStack.setSelectedElement((MUIElement)partFront);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertEquals((Object)partFront, (Object)partService.getActivePart());
        PartListener partListener = new PartListener();
        partService.addPartListener((IPartListener)partListener);
        partService.activate(partBack);
        EPartServiceTest.assertEquals((int)1, (int)partListener.getHidden());
        EPartServiceTest.assertEquals((Object)partFront, (Object)partListener.getHiddenParts().get(0));
        EPartServiceTest.assertTrue((boolean)partListener.isValid());
        partListener.clear();
        partService.activate(partFront);
        EPartServiceTest.assertEquals((int)1, (int)partListener.getHidden());
        EPartServiceTest.assertEquals((Object)partBack, (Object)partListener.getHiddenParts().get(0));
        EPartServiceTest.assertTrue((boolean)partListener.isValid());
    }

    public void testEvent_PartHidden2() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow windowA = BasicFactoryImpl.eINSTANCE.createWindow();
        MWindow windowB = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(windowA);
        application.getChildren().add(windowB);
        application.setSelectedElement((MUIElement)windowA);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        windowB.getChildren().add(stack);
        windowB.setSelectedElement((MUIElement)stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        stack.setSelectedElement((MUIElement)partA);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)windowA.getContext().get(EPartService.class.getName());
        EPartService partServiceB = (EPartService)windowB.getContext().get(EPartService.class.getName());
        PartListener partListener = new PartListener();
        partServiceA.addPartListener((IPartListener)partListener);
        partServiceB.activate(partB);
        EPartServiceTest.assertEquals((int)0, (int)partListener.getHidden());
        EPartServiceTest.assertEquals((int)0, (int)partListener.getHiddenParts().size());
        EPartServiceTest.assertTrue((boolean)partListener.isValid());
        partListener.clear();
        partServiceB.activate(partA);
        EPartServiceTest.assertEquals((int)0, (int)partListener.getHidden());
        EPartServiceTest.assertEquals((int)0, (int)partListener.getHiddenParts().size());
        EPartServiceTest.assertTrue((boolean)partListener.isValid());
    }

    public void testEvent_PartVisible() {
        MApplication application = this.createApplication("partFront", "partBack");
        MWindow window = (MWindow)application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart partFront = (MPart)partStack.getChildren().get(0);
        MPart partBack = (MPart)partStack.getChildren().get(1);
        partStack.setSelectedElement((MUIElement)partFront);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertEquals((Object)partFront, (Object)partService.getActivePart());
        PartListener partListener = new PartListener();
        partService.addPartListener((IPartListener)partListener);
        partService.activate(partBack);
        EPartServiceTest.assertEquals((int)1, (int)partListener.getVisible());
        EPartServiceTest.assertEquals((Object)partBack, (Object)partListener.getVisibleParts().get(0));
        EPartServiceTest.assertTrue((boolean)partListener.isValid());
        partListener.clear();
        partService.activate(partFront);
        EPartServiceTest.assertEquals((int)1, (int)partListener.getVisible());
        EPartServiceTest.assertEquals((Object)partFront, (Object)partListener.getVisibleParts().get(0));
        EPartServiceTest.assertTrue((boolean)partListener.isValid());
    }

    public void testEvent_PartVisible2() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow windowA = BasicFactoryImpl.eINSTANCE.createWindow();
        MWindow windowB = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(windowA);
        application.getChildren().add(windowB);
        application.setSelectedElement((MUIElement)windowA);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        windowB.getChildren().add(stack);
        windowB.setSelectedElement((MUIElement)stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        stack.setSelectedElement((MUIElement)partA);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)windowA.getContext().get(EPartService.class.getName());
        EPartService partServiceB = (EPartService)windowB.getContext().get(EPartService.class.getName());
        PartListener partListener = new PartListener();
        partServiceA.addPartListener((IPartListener)partListener);
        partServiceB.activate(partB);
        EPartServiceTest.assertEquals((int)0, (int)partListener.getVisible());
        EPartServiceTest.assertEquals((int)0, (int)partListener.getVisibleParts().size());
        EPartServiceTest.assertTrue((boolean)partListener.isValid());
        partListener.clear();
        partServiceB.activate(partA);
        EPartServiceTest.assertEquals((int)0, (int)partListener.getVisible());
        EPartServiceTest.assertEquals((int)0, (int)partListener.getVisibleParts().size());
        EPartServiceTest.assertTrue((boolean)partListener.isValid());
    }

    private void testSavePart(final ISaveHandler.Save returnValue, boolean confirm, boolean beforeDirty, boolean afterDirty, boolean success, boolean saveCalled, boolean throwException) {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPart saveablePart = BasicFactoryImpl.eINSTANCE.createPart();
        saveablePart.setDirty(beforeDirty);
        saveablePart.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.ClientEditor");
        window.getChildren().add(saveablePart);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        ClientEditor editor = (ClientEditor)saveablePart.getObject();
        editor.setThrowException(throwException);
        window.getContext().set(ISaveHandler.class.getName(), (Object)new ISaveHandler(){

            public ISaveHandler.Save[] promptToSave(Collection<MPart> saveablePart) {
                return null;
            }

            public ISaveHandler.Save promptToSave(MPart saveablePart) {
                return returnValue;
            }
        });
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        if (beforeDirty) {
            EPartServiceTest.assertEquals((boolean)success, (boolean)partService.savePart(saveablePart, confirm));
        } else {
            EPartServiceTest.assertTrue((String)"The part is not dirty, the save operation should complete successfully", (boolean)partService.savePart(saveablePart, confirm));
        }
        EPartServiceTest.assertEquals((boolean)afterDirty, (boolean)saveablePart.isDirty());
        EPartServiceTest.assertEquals((boolean)saveCalled, (boolean)editor.wasSaveCalled());
    }

    private void testSavePart(ISaveHandler.Save returnValue, boolean confirm, boolean beforeDirty, boolean throwException) {
        switch (returnValue) {
            case YES: {
                if (throwException) {
                    if (beforeDirty) {
                        this.testSavePart(ISaveHandler.Save.YES, confirm, beforeDirty, beforeDirty, false, true, throwException);
                        break;
                    }
                    this.testSavePart(ISaveHandler.Save.YES, confirm, beforeDirty, beforeDirty, true, false, throwException);
                    break;
                }
                if (beforeDirty) {
                    if (confirm) {
                        this.testSavePart(ISaveHandler.Save.YES, confirm, beforeDirty, false, true, true, throwException);
                        break;
                    }
                    this.testSavePart(ISaveHandler.Save.YES, confirm, beforeDirty, false, true, true, throwException);
                    break;
                }
                if (confirm) {
                    this.testSavePart(ISaveHandler.Save.YES, confirm, beforeDirty, false, true, false, throwException);
                    break;
                }
                this.testSavePart(ISaveHandler.Save.YES, confirm, beforeDirty, false, true, false, throwException);
                break;
            }
            case NO: {
                if (throwException) {
                    if (beforeDirty) {
                        if (confirm) {
                            this.testSavePart(ISaveHandler.Save.NO, confirm, beforeDirty, beforeDirty, true, false, throwException);
                            break;
                        }
                        this.testSavePart(ISaveHandler.Save.NO, confirm, beforeDirty, beforeDirty, false, true, throwException);
                        break;
                    }
                    this.testSavePart(ISaveHandler.Save.NO, confirm, beforeDirty, beforeDirty, true, false, throwException);
                    break;
                }
                if (beforeDirty) {
                    if (confirm) {
                        this.testSavePart(ISaveHandler.Save.NO, confirm, beforeDirty, true, true, false, throwException);
                        break;
                    }
                    this.testSavePart(ISaveHandler.Save.NO, confirm, beforeDirty, false, true, true, throwException);
                    break;
                }
                if (confirm) {
                    this.testSavePart(ISaveHandler.Save.NO, confirm, beforeDirty, false, true, false, throwException);
                    break;
                }
                this.testSavePart(ISaveHandler.Save.NO, confirm, beforeDirty, false, true, false, throwException);
                break;
            }
            case CANCEL: {
                if (throwException) {
                    if (beforeDirty) {
                        if (confirm) {
                            this.testSavePart(ISaveHandler.Save.CANCEL, confirm, beforeDirty, beforeDirty, false, false, throwException);
                            break;
                        }
                        this.testSavePart(ISaveHandler.Save.CANCEL, confirm, beforeDirty, beforeDirty, false, true, throwException);
                        break;
                    }
                    this.testSavePart(ISaveHandler.Save.CANCEL, confirm, beforeDirty, beforeDirty, true, false, throwException);
                    break;
                }
                if (beforeDirty) {
                    if (confirm) {
                        this.testSavePart(ISaveHandler.Save.CANCEL, confirm, beforeDirty, true, false, false, throwException);
                        break;
                    }
                    this.testSavePart(ISaveHandler.Save.CANCEL, confirm, beforeDirty, false, true, true, throwException);
                    break;
                }
                if (confirm) {
                    this.testSavePart(ISaveHandler.Save.CANCEL, confirm, beforeDirty, false, true, false, throwException);
                    break;
                }
                this.testSavePart(ISaveHandler.Save.CANCEL, confirm, beforeDirty, false, true, false, throwException);
                break;
            }
            default: {
                EPartServiceTest.fail((String)("Unknown expected return value set: " + returnValue));
            }
        }
    }

    public void testSavePart_YesTrueTrueTrue() {
        this.testSavePart(ISaveHandler.Save.YES, true, true, true);
    }

    public void testSavePart_YesTrueTrueFalse() {
        this.testSavePart(ISaveHandler.Save.YES, true, true, false);
    }

    public void testSavePart_YesTrueFalseTrue() {
        this.testSavePart(ISaveHandler.Save.YES, true, false, true);
    }

    public void testSavePart_YesTrueFalseFalse() {
        this.testSavePart(ISaveHandler.Save.YES, true, false, false);
    }

    public void testSavePart_YesFalseTrueTrue() {
        this.testSavePart(ISaveHandler.Save.YES, false, true, true);
    }

    public void testSavePart_YesFalseTrueFalse() {
        this.testSavePart(ISaveHandler.Save.YES, false, true, false);
    }

    public void testSavePart_YesFalseFalseTrue() {
        this.testSavePart(ISaveHandler.Save.YES, false, false, true);
    }

    public void testSavePart_YesFalseFalseFalse() {
        this.testSavePart(ISaveHandler.Save.YES, false, false, false);
    }

    public void testSavePart_NoTrueTrueTrue() {
        this.testSavePart(ISaveHandler.Save.NO, true, true, true);
    }

    public void testSavePart_NoTrueTrueFalse() {
        this.testSavePart(ISaveHandler.Save.NO, true, true, false);
    }

    public void testSavePart_NoTrueFalseTrue() {
        this.testSavePart(ISaveHandler.Save.NO, true, false, true);
    }

    public void testSavePart_NoTrueFalseFalse() {
        this.testSavePart(ISaveHandler.Save.NO, true, false, false);
    }

    public void testSavePart_NoFalseTrueTrue() {
        this.testSavePart(ISaveHandler.Save.NO, false, true, true);
    }

    public void testSavePart_NoFalseTrueFalse() {
        this.testSavePart(ISaveHandler.Save.NO, false, true, false);
    }

    public void testSavePart_NoFalseFalseTrue() {
        this.testSavePart(ISaveHandler.Save.NO, false, false, true);
    }

    public void testSavePart_NoFalseFalseFalse() {
        this.testSavePart(ISaveHandler.Save.NO, false, false, false);
    }

    public void testSavePart_CancelTrueTrueTrue() {
        this.testSavePart(ISaveHandler.Save.CANCEL, true, true, true);
    }

    public void testSavePart_CancelTrueTrueFalse() {
        this.testSavePart(ISaveHandler.Save.CANCEL, true, true, false);
    }

    public void testSavePart_CancelTrueFalseTrue() {
        this.testSavePart(ISaveHandler.Save.CANCEL, true, false, true);
    }

    public void testSavePart_CancelTrueFalseFalse() {
        this.testSavePart(ISaveHandler.Save.CANCEL, true, false, false);
    }

    public void testSavePart_CancelFalseTrueTrue() {
        this.testSavePart(ISaveHandler.Save.CANCEL, false, true, true);
    }

    public void testSavePart_CancelFalseTrueFalse() {
        this.testSavePart(ISaveHandler.Save.CANCEL, false, true, false);
    }

    public void testSavePart_CancelFalseFalseTrue() {
        this.testSavePart(ISaveHandler.Save.CANCEL, false, false, true);
    }

    public void testSavePart_CancelFalseFalseFalse() {
        this.testSavePart(ISaveHandler.Save.CANCEL, false, false, false);
    }

    private void testSavePart_NoHandler(boolean beforeDirty, boolean throwException, boolean confirm) {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPart saveablePart = BasicFactoryImpl.eINSTANCE.createPart();
        saveablePart.setDirty(beforeDirty);
        saveablePart.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.ClientEditor");
        window.getChildren().add(saveablePart);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        ClientEditor editor = (ClientEditor)saveablePart.getObject();
        editor.setThrowException(throwException);
        this.applicationContext.set(ISaveHandler.class.getName(), null);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        if (beforeDirty) {
            EPartServiceTest.assertEquals((!throwException ? 1 : 0) != 0, (boolean)partService.savePart(saveablePart, confirm));
        } else {
            EPartServiceTest.assertTrue((String)"The part is not dirty, the save operation should have complete successfully", (boolean)partService.savePart(saveablePart, confirm));
        }
        EPartServiceTest.assertEquals((beforeDirty && throwException ? 1 : 0) != 0, (boolean)saveablePart.isDirty());
        EPartServiceTest.assertEquals((boolean)beforeDirty, (boolean)editor.wasSaveCalled());
    }

    public void testSavePart_NoHandler_TTT() {
        this.testSavePart_NoHandler(true, true, true);
    }

    public void testSavePart_NoHandler_TTF() {
        this.testSavePart_NoHandler(true, true, false);
    }

    public void testSavePart_NoHandler_TFT() {
        this.testSavePart_NoHandler(true, false, true);
    }

    public void testSavePart_NoHandler_TFF() {
        this.testSavePart_NoHandler(true, false, false);
    }

    public void testSavePart_NoHandler_FTT() {
        this.testSavePart_NoHandler(false, true, true);
    }

    public void testSavePart_NoHandler_FTF() {
        this.testSavePart_NoHandler(false, true, false);
    }

    public void testSavePart_NoHandler_FFT() {
        this.testSavePart_NoHandler(false, false, true);
    }

    public void testSavePart_NoHandler_FFF() {
        this.testSavePart_NoHandler(false, false, false);
    }

    private MPart createSaveablePart(MElementContainer<MWindowElement> container, boolean beforeDirty) {
        MPart saveablePart = BasicFactoryImpl.eINSTANCE.createPart();
        saveablePart.setDirty(beforeDirty);
        saveablePart.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.ClientEditor");
        container.getChildren().add(saveablePart);
        return saveablePart;
    }

    private ISaveHandler.Save prompt(ISaveHandler.Save[] candidates, MPart partToTest, MPart part) {
        return partToTest == part ? candidates[0] : candidates[1];
    }

    private void testSaveAll(final ISaveHandler.Save[] returnValues, boolean confirm, boolean[] beforeDirty, boolean[] afterDirty, boolean success, boolean[] saveCalled, boolean[] throwException) {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        final MPart saveablePart = this.createSaveablePart((MElementContainer<MWindowElement>)window, beforeDirty[0]);
        MPart saveablePart2 = this.createSaveablePart((MElementContainer<MWindowElement>)window, beforeDirty[1]);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        ClientEditor editor = (ClientEditor)saveablePart.getObject();
        editor.setThrowException(throwException[0]);
        ClientEditor editor2 = (ClientEditor)saveablePart2.getObject();
        editor2.setThrowException(throwException[1]);
        window.getContext().set(ISaveHandler.class.getName(), (Object)new ISaveHandler(){

            public ISaveHandler.Save[] promptToSave(Collection<MPart> saveableParts) {
                int index = 0;
                ISaveHandler.Save[] prompt = new ISaveHandler.Save[saveableParts.size()];
                Iterator<MPart> it = saveableParts.iterator();
                while (it.hasNext()) {
                    prompt[index] = EPartServiceTest.this.prompt(returnValues, it.next(), saveablePart);
                    ++index;
                }
                return prompt;
            }

            public ISaveHandler.Save promptToSave(MPart saveablePart2) {
                return null;
            }
        });
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertEquals((boolean)success, (boolean)partService.saveAll(confirm));
        EPartServiceTest.assertEquals((boolean)afterDirty[0], (boolean)saveablePart.isDirty());
        EPartServiceTest.assertEquals((boolean)saveCalled[0], (boolean)editor.wasSaveCalled());
        EPartServiceTest.assertEquals((boolean)afterDirty[1], (boolean)saveablePart2.isDirty());
        EPartServiceTest.assertEquals((boolean)saveCalled[1], (boolean)editor2.wasSaveCalled());
    }

    private boolean hasCancel(ISaveHandler.Save[] returnValues, boolean[] beforeDirty) {
        int i = 0;
        while (i < returnValues.length) {
            if (returnValues[i] == ISaveHandler.Save.CANCEL && beforeDirty[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isSuccessful(ISaveHandler.Save[] returnValues, boolean confirm, boolean[] beforeDirty, boolean[] throwException) {
        if (confirm) {
            if (returnValues[0] == ISaveHandler.Save.YES) {
                if (returnValues[1] == ISaveHandler.Save.YES) {
                    if (beforeDirty[0]) {
                        if (beforeDirty[1]) {
                            return !throwException[0] && !throwException[1];
                        }
                        return !throwException[0];
                    }
                    if (beforeDirty[1]) {
                        return !throwException[1];
                    }
                    return true;
                }
                if (beforeDirty[0]) {
                    return !throwException[0];
                }
                return true;
            }
            if (returnValues[1] == ISaveHandler.Save.YES && beforeDirty[1]) {
                return !throwException[1];
            }
            return true;
        }
        return this.isSuccessful(beforeDirty, throwException);
    }

    private boolean isSuccessful(boolean[] beforeDirty, boolean[] throwException) {
        if (beforeDirty[0]) {
            if (beforeDirty[1]) {
                return !throwException[0] && !throwException[1];
            }
            return !throwException[0];
        }
        if (beforeDirty[1]) {
            return !throwException[1];
        }
        return true;
    }

    private boolean[] afterDirty(ISaveHandler.Save[] returnValues, boolean confirm, boolean[] beforeDirty, boolean[] throwException) {
        if (confirm) {
            if (returnValues[0] == ISaveHandler.Save.YES) {
                if (returnValues[1] == ISaveHandler.Save.YES) {
                    if (beforeDirty[0]) {
                        boolean[] blArray = new boolean[2];
                        blArray[0] = throwException[0];
                        blArray[1] = beforeDirty[1] ? throwException[0] || throwException[1] : false;
                        return blArray;
                    }
                    return new boolean[]{beforeDirty[0], beforeDirty[1] ? throwException[1] : false};
                }
                return new boolean[]{beforeDirty[0] ? throwException[0] : false, beforeDirty[1]};
            }
            if (returnValues[1] == ISaveHandler.Save.YES) {
                return new boolean[]{beforeDirty[0], beforeDirty[1] ? throwException[1] : false};
            }
            return beforeDirty;
        }
        return this.afterDirty(beforeDirty, throwException);
    }

    private boolean[] afterDirty(boolean[] beforeDirty, boolean[] throwException) {
        if (beforeDirty[0]) {
            if (beforeDirty[1]) {
                return new boolean[]{throwException[0], throwException[0] || throwException[1]};
            }
            boolean[] blArray = new boolean[2];
            blArray[0] = throwException[0];
            return blArray;
        }
        if (beforeDirty[1]) {
            boolean[] blArray = new boolean[2];
            blArray[1] = throwException[1];
            return blArray;
        }
        return new boolean[2];
    }

    private boolean[] saveCalled(ISaveHandler.Save[] returnValues, boolean confirm, boolean[] beforeDirty, boolean[] throwException) {
        if (confirm) {
            if (returnValues[0] == ISaveHandler.Save.YES) {
                if (returnValues[1] == ISaveHandler.Save.YES) {
                    if (beforeDirty[0]) {
                        return new boolean[]{true, !throwException[0] && beforeDirty[1]};
                    }
                    return beforeDirty;
                }
                boolean[] blArray = new boolean[2];
                blArray[0] = beforeDirty[0];
                return blArray;
            }
            if (returnValues[1] == ISaveHandler.Save.YES) {
                boolean[] blArray = new boolean[2];
                blArray[1] = beforeDirty[1];
                return blArray;
            }
            return new boolean[2];
        }
        return this.saveCalled(beforeDirty, throwException);
    }

    private boolean[] saveCalled(boolean[] beforeDirty, boolean[] throwException) {
        boolean[] blArray = new boolean[2];
        blArray[0] = beforeDirty[0];
        blArray[1] = beforeDirty[0] ? !throwException[0] && beforeDirty[1] : beforeDirty[1];
        return blArray;
    }

    private void testSaveAll(ISaveHandler.Save[] returnValues, boolean confirm, boolean[] beforeDirty, boolean[] throwException) {
        if (this.hasCancel(returnValues, beforeDirty) && confirm) {
            this.testSaveAll(returnValues, confirm, beforeDirty, beforeDirty, false, new boolean[2], throwException);
        } else {
            this.testSaveAll(returnValues, confirm, beforeDirty, this.afterDirty(returnValues, confirm, beforeDirty, throwException), this.isSuccessful(returnValues, confirm, beforeDirty, throwException), this.saveCalled(returnValues, confirm, beforeDirty, throwException), throwException);
        }
    }

    public void testSaveAll_YY_True_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, new boolean[]{true, true}, new boolean[]{true, true});
    }

    public void testSaveAll_YY_True_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_YY_True_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_YY_True_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_YY_True_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    public void testSaveAll_YY_True_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    public void testSaveAll_YY_True_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, blArray, new boolean[2]);
    }

    public void testSaveAll_YY_True_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_YY_True_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    public void testSaveAll_YY_True_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    public void testSaveAll_YY_True_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, new boolean[2], new boolean[]{true, true});
    }

    public void testSaveAll_YY_True_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, new boolean[2], blArray);
    }

    public void testSaveAll_YY_True_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, new boolean[2], blArray);
    }

    public void testSaveAll_YY_True_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, new boolean[2], new boolean[2]);
    }

    public void testSaveAll_YY_False_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, new boolean[]{true, true}, new boolean[]{true, true});
    }

    public void testSaveAll_YY_False_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_YY_False_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_YY_False_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_YY_False_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    public void testSaveAll_YY_False_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    public void testSaveAll_YY_False_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, blArray, new boolean[2]);
    }

    public void testSaveAll_YY_False_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_YY_False_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    public void testSaveAll_YY_False_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    public void testSaveAll_YY_False_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, new boolean[2], new boolean[]{true, true});
    }

    public void testSaveAll_YY_False_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, new boolean[2], blArray);
    }

    public void testSaveAll_YY_False_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, new boolean[2], blArray);
    }

    public void testSaveAll_YY_False_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, new boolean[2], new boolean[2]);
    }

    public void testSaveAll_YN_True_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, new boolean[]{true, true}, new boolean[]{true, true});
    }

    public void testSaveAll_YN_True_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_YN_True_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_YN_True_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_YN_True_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    public void testSaveAll_YN_True_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    public void testSaveAll_YN_True_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, blArray, new boolean[2]);
    }

    public void testSaveAll_YN_True_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_YN_True_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    public void testSaveAll_YN_True_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    public void testSaveAll_YN_True_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, new boolean[2], new boolean[]{true, true});
    }

    public void testSaveAll_YN_True_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, new boolean[2], blArray);
    }

    public void testSaveAll_YN_True_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, new boolean[2], blArray);
    }

    public void testSaveAll_YN_True_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, new boolean[2], new boolean[2]);
    }

    public void testSaveAll_YN_False_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, new boolean[]{true, true}, new boolean[]{true, true});
    }

    public void testSaveAll_YN_False_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_YN_False_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_YN_False_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_YN_False_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    public void testSaveAll_YN_False_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    public void testSaveAll_YN_False_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, blArray, new boolean[2]);
    }

    public void testSaveAll_YN_False_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_YN_False_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    public void testSaveAll_YN_False_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    public void testSaveAll_YN_False_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, new boolean[2], new boolean[]{true, true});
    }

    public void testSaveAll_YN_False_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, new boolean[2], blArray);
    }

    public void testSaveAll_YN_False_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, new boolean[2], blArray);
    }

    public void testSaveAll_YN_False_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, new boolean[2], new boolean[2]);
    }

    public void testSaveAll_YC_True_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, new boolean[]{true, true}, new boolean[]{true, true});
    }

    public void testSaveAll_YC_True_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_YC_True_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_YC_True_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_YC_True_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    public void testSaveAll_YC_True_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    public void testSaveAll_YC_True_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, blArray, new boolean[2]);
    }

    public void testSaveAll_YC_True_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_YC_True_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    public void testSaveAll_YC_True_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    public void testSaveAll_YC_True_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, new boolean[2], new boolean[]{true, true});
    }

    public void testSaveAll_YC_True_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, new boolean[2], blArray);
    }

    public void testSaveAll_YC_True_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, new boolean[2], blArray);
    }

    public void testSaveAll_YC_True_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, new boolean[2], new boolean[2]);
    }

    public void testSaveAll_YC_False_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, new boolean[]{true, true}, new boolean[]{true, true});
    }

    public void testSaveAll_YC_False_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_YC_False_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_YC_False_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_YC_False_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    public void testSaveAll_YC_False_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    public void testSaveAll_YC_False_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, blArray, new boolean[2]);
    }

    public void testSaveAll_YC_False_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_YC_False_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    public void testSaveAll_YC_False_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    public void testSaveAll_YC_False_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, new boolean[2], new boolean[]{true, true});
    }

    public void testSaveAll_YC_False_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, new boolean[2], blArray);
    }

    public void testSaveAll_YC_False_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, new boolean[2], blArray);
    }

    public void testSaveAll_YC_False_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, new boolean[2], new boolean[2]);
    }

    public void testSaveAll_NY_True_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, new boolean[]{true, true}, new boolean[]{true, true});
    }

    public void testSaveAll_NY_True_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_NY_True_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_NY_True_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_NY_True_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    public void testSaveAll_NY_True_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    public void testSaveAll_NY_True_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, blArray, new boolean[2]);
    }

    public void testSaveAll_NY_True_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_NY_True_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    public void testSaveAll_NY_True_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    public void testSaveAll_NY_True_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, new boolean[2], new boolean[]{true, true});
    }

    public void testSaveAll_NY_True_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, new boolean[2], blArray);
    }

    public void testSaveAll_NY_True_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, new boolean[2], blArray);
    }

    public void testSaveAll_NY_True_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, new boolean[2], new boolean[2]);
    }

    public void testSaveAll_NY_False_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, new boolean[]{true, true}, new boolean[]{true, true});
    }

    public void testSaveAll_NY_False_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_NY_False_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_NY_False_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_NY_False_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    public void testSaveAll_NY_False_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    public void testSaveAll_NY_False_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, blArray, new boolean[2]);
    }

    public void testSaveAll_NY_False_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_NY_False_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    public void testSaveAll_NY_False_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    public void testSaveAll_NY_False_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, new boolean[2], new boolean[]{true, true});
    }

    public void testSaveAll_NY_False_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, new boolean[2], blArray);
    }

    public void testSaveAll_NY_False_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, new boolean[2], blArray);
    }

    public void testSaveAll_NY_False_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, new boolean[2], new boolean[2]);
    }

    public void testSaveAll_NN_True_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, new boolean[]{true, true}, new boolean[]{true, true});
    }

    public void testSaveAll_NN_True_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_NN_True_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_NN_True_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_NN_True_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    public void testSaveAll_NN_True_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    public void testSaveAll_NN_True_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, blArray, new boolean[2]);
    }

    public void testSaveAll_NN_True_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_NN_True_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    public void testSaveAll_NN_True_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    public void testSaveAll_NN_True_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, new boolean[2], new boolean[]{true, true});
    }

    public void testSaveAll_NN_True_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, new boolean[2], blArray);
    }

    public void testSaveAll_NN_True_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, new boolean[2], blArray);
    }

    public void testSaveAll_NN_True_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, new boolean[2], new boolean[2]);
    }

    public void testSaveAll_NN_False_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, new boolean[]{true, true}, new boolean[]{true, true});
    }

    public void testSaveAll_NN_False_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_NN_False_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_NN_False_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_NN_False_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    public void testSaveAll_NN_False_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    public void testSaveAll_NN_False_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, blArray, new boolean[2]);
    }

    public void testSaveAll_NN_False_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_NN_False_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    public void testSaveAll_NN_False_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    public void testSaveAll_NN_False_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, new boolean[2], new boolean[]{true, true});
    }

    public void testSaveAll_NN_False_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, new boolean[2], blArray);
    }

    public void testSaveAll_NN_False_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, new boolean[2], blArray);
    }

    public void testSaveAll_NN_False_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, new boolean[2], new boolean[2]);
    }

    public void testSaveAll_NC_True_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, new boolean[]{true, true}, new boolean[]{true, true});
    }

    public void testSaveAll_NC_True_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_NC_True_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_NC_True_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_NC_True_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    public void testSaveAll_NC_True_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    public void testSaveAll_NC_True_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, blArray, new boolean[2]);
    }

    public void testSaveAll_NC_True_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_NC_True_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    public void testSaveAll_NC_True_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    public void testSaveAll_NC_True_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, new boolean[2], new boolean[]{true, true});
    }

    public void testSaveAll_NC_True_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, new boolean[2], blArray);
    }

    public void testSaveAll_NC_True_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, new boolean[2], blArray);
    }

    public void testSaveAll_NC_True_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, new boolean[2], new boolean[2]);
    }

    public void testSaveAll_NC_False_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, new boolean[]{true, true}, new boolean[]{true, true});
    }

    public void testSaveAll_NC_False_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_NC_False_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_NC_False_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_NC_False_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    public void testSaveAll_NC_False_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    public void testSaveAll_NC_False_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, blArray, new boolean[2]);
    }

    public void testSaveAll_NC_False_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_NC_False_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    public void testSaveAll_NC_False_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    public void testSaveAll_NC_False_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, new boolean[2], new boolean[]{true, true});
    }

    public void testSaveAll_NC_False_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, new boolean[2], blArray);
    }

    public void testSaveAll_NC_False_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, new boolean[2], blArray);
    }

    public void testSaveAll_NC_False_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, new boolean[2], new boolean[2]);
    }

    public void testSaveAll_CY_True_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, new boolean[]{true, true}, new boolean[]{true, true});
    }

    public void testSaveAll_CY_True_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_CY_True_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_CY_True_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_CY_True_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    public void testSaveAll_CY_True_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    public void testSaveAll_CY_True_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, blArray, new boolean[2]);
    }

    public void testSaveAll_CY_True_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_CY_True_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    public void testSaveAll_CY_True_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    public void testSaveAll_CY_True_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, new boolean[2], new boolean[]{true, true});
    }

    public void testSaveAll_CY_True_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, new boolean[2], blArray);
    }

    public void testSaveAll_CY_True_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, new boolean[2], blArray);
    }

    public void testSaveAll_CY_True_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, new boolean[2], new boolean[2]);
    }

    public void testSaveAll_CY_False_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, new boolean[]{true, true}, new boolean[]{true, true});
    }

    public void testSaveAll_CY_False_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_CY_False_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_CY_False_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_CY_False_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    public void testSaveAll_CY_False_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    public void testSaveAll_CY_False_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, blArray, new boolean[2]);
    }

    public void testSaveAll_CY_False_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_CY_False_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    public void testSaveAll_CY_False_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    public void testSaveAll_CY_False_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, new boolean[2], new boolean[]{true, true});
    }

    public void testSaveAll_CY_False_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, new boolean[2], blArray);
    }

    public void testSaveAll_CY_False_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, new boolean[2], blArray);
    }

    public void testSaveAll_CY_False_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, new boolean[2], new boolean[2]);
    }

    public void testSaveAll_CN_True_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, new boolean[]{true, true}, new boolean[]{true, true});
    }

    public void testSaveAll_CN_True_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_CN_True_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_CN_True_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_CN_True_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    public void testSaveAll_CN_True_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    public void testSaveAll_CN_True_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, blArray, new boolean[2]);
    }

    public void testSaveAll_CN_True_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_CN_True_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    public void testSaveAll_CN_True_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    public void testSaveAll_CN_True_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, new boolean[2], new boolean[]{true, true});
    }

    public void testSaveAll_CN_True_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, new boolean[2], blArray);
    }

    public void testSaveAll_CN_True_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, new boolean[2], blArray);
    }

    public void testSaveAll_CN_True_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, new boolean[2], new boolean[2]);
    }

    public void testSaveAll_CN_False_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, new boolean[]{true, true}, new boolean[]{true, true});
    }

    public void testSaveAll_CN_False_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_CN_False_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_CN_False_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_CN_False_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    public void testSaveAll_CN_False_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    public void testSaveAll_CN_False_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, blArray, new boolean[2]);
    }

    public void testSaveAll_CN_False_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_CN_False_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    public void testSaveAll_CN_False_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    public void testSaveAll_CN_False_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, new boolean[2], new boolean[]{true, true});
    }

    public void testSaveAll_CN_False_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, new boolean[2], blArray);
    }

    public void testSaveAll_CN_False_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, new boolean[2], blArray);
    }

    public void testSaveAll_CN_False_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, new boolean[2], new boolean[2]);
    }

    public void testSaveAll_CC_True_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, new boolean[]{true, true}, new boolean[]{true, true});
    }

    public void testSaveAll_CC_True_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_CC_True_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_CC_True_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_CC_True_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    public void testSaveAll_CC_True_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    public void testSaveAll_CC_True_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, blArray, new boolean[2]);
    }

    public void testSaveAll_CC_True_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_CC_True_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    public void testSaveAll_CC_True_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    public void testSaveAll_CC_True_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, new boolean[2], new boolean[]{true, true});
    }

    public void testSaveAll_CC_True_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, new boolean[2], blArray);
    }

    public void testSaveAll_CC_True_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, new boolean[2], blArray);
    }

    public void testSaveAll_CC_True_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, new boolean[2], new boolean[2]);
    }

    public void testSaveAll_CC_False_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, new boolean[]{true, true}, new boolean[]{true, true});
    }

    public void testSaveAll_CC_False_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_CC_False_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_CC_False_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_CC_False_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    public void testSaveAll_CC_False_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    public void testSaveAll_CC_False_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, blArray, new boolean[2]);
    }

    public void testSaveAll_CC_False_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_CC_False_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    public void testSaveAll_CC_False_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    public void testSaveAll_CC_False_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, new boolean[2], new boolean[]{true, true});
    }

    public void testSaveAll_CC_False_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, new boolean[2], blArray);
    }

    public void testSaveAll_CC_False_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, new boolean[2], blArray);
    }

    public void testSaveAll_CC_False_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, new boolean[2], new boolean[2]);
    }

    private void testSaveAll_NoHandler(boolean beforeDirty, boolean throwException, boolean confirm) {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPart saveablePart = BasicFactoryImpl.eINSTANCE.createPart();
        saveablePart.setDirty(beforeDirty);
        saveablePart.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.ClientEditor");
        window.getChildren().add(saveablePart);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        ClientEditor editor = (ClientEditor)saveablePart.getObject();
        editor.setThrowException(throwException);
        this.applicationContext.set(ISaveHandler.class.getName(), null);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        if (beforeDirty) {
            EPartServiceTest.assertEquals((!throwException ? 1 : 0) != 0, (boolean)partService.saveAll(confirm));
        } else {
            EPartServiceTest.assertTrue((String)"The part is not dirty, the save operation should have complete successfully", (boolean)partService.saveAll(confirm));
        }
        EPartServiceTest.assertEquals((beforeDirty && throwException ? 1 : 0) != 0, (boolean)saveablePart.isDirty());
        EPartServiceTest.assertEquals((boolean)beforeDirty, (boolean)editor.wasSaveCalled());
    }

    public void testSaveAll_NoHandler_TTT() {
        this.testSaveAll_NoHandler(true, true, true);
    }

    public void testSaveAll_NoHandler_TTF() {
        this.testSaveAll_NoHandler(true, true, false);
    }

    public void testSaveAll_NoHandler_TFT() {
        this.testSaveAll_NoHandler(true, false, true);
    }

    public void testSaveAll_NoHandler_TFF() {
        this.testSaveAll_NoHandler(true, false, false);
    }

    public void testSaveAll_NoHandler_FTT() {
        this.testSaveAll_NoHandler(false, true, true);
    }

    public void testSaveAll_NoHandler_FTF() {
        this.testSaveAll_NoHandler(false, true, false);
    }

    public void testSaveAll_NoHandler_FFT() {
        this.testSaveAll_NoHandler(false, false, true);
    }

    public void testSaveAll_NoHandler_FFF() {
        this.testSaveAll_NoHandler(false, false, false);
    }

    private void testSaveAll_NoHandlers(boolean confirm, boolean[] beforeDirty, boolean[] afterDirty, boolean success, boolean[] saveCalled, boolean[] throwException) {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPart saveablePart = this.createSaveablePart((MElementContainer<MWindowElement>)window, beforeDirty[0]);
        MPart saveablePart2 = this.createSaveablePart((MElementContainer<MWindowElement>)window, beforeDirty[1]);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        ClientEditor editor = (ClientEditor)saveablePart.getObject();
        editor.setThrowException(throwException[0]);
        ClientEditor editor2 = (ClientEditor)saveablePart2.getObject();
        editor2.setThrowException(throwException[1]);
        window.getContext().set(ISaveHandler.class.getName(), null);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertEquals((boolean)success, (boolean)partService.saveAll(confirm));
        EPartServiceTest.assertEquals((boolean)afterDirty[0], (boolean)saveablePart.isDirty());
        EPartServiceTest.assertEquals((boolean)saveCalled[0], (boolean)editor.wasSaveCalled());
        EPartServiceTest.assertEquals((boolean)afterDirty[1], (boolean)saveablePart2.isDirty());
        EPartServiceTest.assertEquals((boolean)saveCalled[1], (boolean)editor2.wasSaveCalled());
    }

    private void testSaveAll_NoHandlers(boolean confirm, boolean[] beforeDirty, boolean[] throwException) {
        this.testSaveAll_NoHandlers(confirm, beforeDirty, this.afterDirty(beforeDirty, throwException), this.isSuccessful(beforeDirty, throwException), this.saveCalled(beforeDirty, throwException), throwException);
    }

    public void testSaveAll_NoHandlers_T_TT_TT() {
        this.testSaveAll_NoHandlers(true, new boolean[]{true, true}, new boolean[]{true, true});
    }

    public void testSaveAll_NoHandlers_T_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll_NoHandlers(true, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_NoHandlers_T_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll_NoHandlers(true, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_NoHandlers_T_TT_FF() {
        this.testSaveAll_NoHandlers(true, new boolean[]{true, true}, new boolean[2]);
    }

    public void testSaveAll_NoHandlers_T_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll_NoHandlers(true, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_NoHandlers_T_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll_NoHandlers(true, blArray, blArray2);
    }

    public void testSaveAll_NoHandlers_T_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll_NoHandlers(true, blArray, blArray2);
    }

    public void testSaveAll_NoHandlers_T_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll_NoHandlers(true, blArray, new boolean[2]);
    }

    public void testSaveAll_NoHandlers_T_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll_NoHandlers(true, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_NoHandlers_T_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll_NoHandlers(true, blArray, blArray2);
    }

    public void testSaveAll_NoHandlers_T_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll_NoHandlers(true, blArray, blArray2);
    }

    public void testSaveAll_NoHandlers_T_FT_FF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll_NoHandlers(true, blArray, new boolean[2]);
    }

    public void testSaveAll_NoHandlers_T_FF_TT() {
        this.testSaveAll_NoHandlers(true, new boolean[2], new boolean[]{true, true});
    }

    public void testSaveAll_NoHandlers_T_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll_NoHandlers(true, new boolean[2], blArray);
    }

    public void testSaveAll_NoHandlers_T_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll_NoHandlers(true, new boolean[2], blArray);
    }

    public void testSaveAll_NoHandlers_T_FF_FF() {
        this.testSaveAll_NoHandlers(true, new boolean[2], new boolean[2]);
    }

    public void testSaveAll_NoHandlers_F_TT_TT() {
        this.testSaveAll_NoHandlers(false, new boolean[]{true, true}, new boolean[]{true, true});
    }

    public void testSaveAll_NoHandlers_F_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll_NoHandlers(false, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_NoHandlers_F_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll_NoHandlers(false, new boolean[]{true, true}, blArray);
    }

    public void testSaveAll_NoHandlers_F_TT_FF() {
        this.testSaveAll_NoHandlers(false, new boolean[]{true, true}, new boolean[2]);
    }

    public void testSaveAll_NoHandlers_F_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll_NoHandlers(false, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_NoHandlers_F_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll_NoHandlers(false, blArray, blArray2);
    }

    public void testSaveAll_NoHandlers_F_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll_NoHandlers(false, blArray, blArray2);
    }

    public void testSaveAll_NoHandlers_F_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll_NoHandlers(false, blArray, new boolean[2]);
    }

    public void testSaveAll_NoHandlers_F_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll_NoHandlers(false, blArray, new boolean[]{true, true});
    }

    public void testSaveAll_NoHandlers_F_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll_NoHandlers(false, blArray, blArray2);
    }

    public void testSaveAll_NoHandlers_F_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll_NoHandlers(false, blArray, blArray2);
    }

    public void testSaveAll_NoHandlers_F_FT_FF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll_NoHandlers(false, blArray, new boolean[2]);
    }

    public void testSaveAll_NoHandlers_F_FF_TT() {
        this.testSaveAll_NoHandlers(false, new boolean[2], new boolean[]{true, true});
    }

    public void testSaveAll_NoHandlers_F_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll_NoHandlers(false, new boolean[2], blArray);
    }

    public void testSaveAll_NoHandlers_F_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll_NoHandlers(false, new boolean[2], blArray);
    }

    public void testSaveAll_NoHandlers_F_FF_FF() {
        this.testSaveAll_NoHandlers(false, new boolean[2], new boolean[2]);
    }

    public void testSwitchWindows() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window1 = BasicFactoryImpl.eINSTANCE.createWindow();
        MWindow window2 = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window1);
        application.getChildren().add(window2);
        application.setSelectedElement((MUIElement)window1);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window1.getChildren().add(part);
        window1.setSelectedElement((MUIElement)part);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window1);
        this.getEngine().createGui((MUIElement)window2);
        EPartService windowService1 = (EPartService)window1.getContext().get(EPartService.class.getName());
        EPartService windowService2 = (EPartService)window2.getContext().get(EPartService.class.getName());
        EPartServiceTest.assertNotNull((Object)windowService1);
        EPartServiceTest.assertNotNull((Object)windowService2);
        EPartServiceTest.assertNotNull((String)"The first part is active in the first window", (Object)windowService1.getActivePart());
        EPartServiceTest.assertNull((String)"There should be nothing active in the second window", (Object)windowService2.getActivePart());
        windowService1.activate(part);
        EPartServiceTest.assertEquals((String)"The part should have been activated", (Object)part, (Object)windowService1.getActivePart());
        EPartServiceTest.assertNull((String)"The second window has no parts, this should be null", (Object)windowService2.getActivePart());
        windowService1.deactivate(part);
        window2.getChildren().add(part);
        part.getContext().setParent(window2.getContext());
        windowService2.activate(part);
        EPartServiceTest.assertEquals((String)"No parts in this window, this should be null", null, (Object)windowService1.getActivePart());
        EPartServiceTest.assertEquals((String)"We activated it just now, this should be active", (Object)part, (Object)windowService2.getActivePart());
    }

    public void testApplicationContextHasActivePart() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(partA);
        window.getChildren().add(partB);
        window.setSelectedElement((MUIElement)partA);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        partService.activate(partA);
        Object o = this.applicationContext.get("e4ActivePart");
        EPartServiceTest.assertEquals((Object)partA, (Object)o);
        partService.activate(partB);
        o = this.applicationContext.get("e4ActivePart");
        EPartServiceTest.assertEquals((Object)partB, (Object)o);
    }

    private void testShowPart_Bug307747(EPartService.PartState partState) {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MPartDescriptor partDescriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        partDescriptor.setElementId("partId");
        partDescriptor.setCategory("category");
        application.getDescriptors().add(partDescriptor);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        stack.setElementId("category");
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        stack.getChildren().add(partA);
        stack.setSelectedElement((MUIElement)partA);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        partService.activate(partA);
        MPart partB = partService.showPart("partId", partState);
        EPartServiceTest.assertNotNull((String)"The part should have been rendered", (Object)partB.getContext());
    }

    public void testShowPart_Bug307747_CREATE() {
        this.testShowPart_Bug307747(EPartService.PartState.CREATE);
    }

    public void testShowPart_Bug307747_VISIBLE() {
        this.testShowPart_Bug307747(EPartService.PartState.VISIBLE);
    }

    public void testShowPart_Bug307747_ACTIVATE() {
        this.testShowPart_Bug307747(EPartService.PartState.ACTIVATE);
    }

    private MApplication createApplication(String partId) {
        return this.createApplication(new String[]{partId});
    }

    private MApplication createApplication(String ... partIds) {
        return this.createApplication(new String[][]{partIds});
    }

    private MApplication createApplication(String[] ... partIds) {
        return this.createApplication(partIds.length, partIds);
    }

    private MApplication createApplication(int windows, String[][] partIds) {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        int i = 0;
        while (i < windows) {
            MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
            application.getChildren().add(window);
            MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
            window.getChildren().add(partStack);
            int j = 0;
            while (j < partIds[i].length) {
                MPart part = BasicFactoryImpl.eINSTANCE.createPart();
                part.setElementId(partIds[i][j]);
                partStack.getChildren().add(part);
                ++j;
            }
            ++i;
        }
        this.initialize(this.applicationContext, application);
        return application;
    }

    private void initialize(IEclipseContext applicationContext, MApplication application) {
        application.setContext(applicationContext);
        applicationContext.set(MApplication.class.getName(), (Object)application);
        E4Workbench.processHierarchy((Object)application);
        ((Notifier)application).eAdapters().add((Object)new UIEventPublisher(applicationContext));
        applicationContext.set(ISaveHandler.class.getName(), (Object)new ISaveHandler(){

            public ISaveHandler.Save[] promptToSave(Collection<MPart> saveablePart) {
                Object[] ret = new ISaveHandler.Save[saveablePart.size()];
                Arrays.fill(ret, ISaveHandler.Save.YES);
                return ret;
            }

            public ISaveHandler.Save promptToSave(MPart saveablePart) {
                return ISaveHandler.Save.YES;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PartListener
    implements IPartListener {
        private List<MPart> activatedParts = new ArrayList<MPart>();
        private List<MPart> deactivatedParts = new ArrayList<MPart>();
        private List<MPart> hiddenParts = new ArrayList<MPart>();
        private List<MPart> visibleParts = new ArrayList<MPart>();
        private int activated = 0;
        private int deactivated = 0;
        private int hidden = 0;
        private int visible = 0;
        private boolean valid = true;

        PartListener() {
        }

        public void clear() {
            this.activated = 0;
            this.deactivated = 0;
            this.hidden = 0;
            this.visible = 0;
            this.activatedParts.clear();
            this.deactivatedParts.clear();
            this.hiddenParts.clear();
            this.visibleParts.clear();
            this.valid = true;
        }

        public int getActivated() {
            return this.activated;
        }

        public int getDeactivated() {
            return this.deactivated;
        }

        public int getHidden() {
            return this.hidden;
        }

        public int getVisible() {
            return this.visible;
        }

        public boolean isValid() {
            return this.valid;
        }

        public List<MPart> getActivatedParts() {
            return this.activatedParts;
        }

        public List<MPart> getDeactivatedParts() {
            return this.deactivatedParts;
        }

        public List<MPart> getHiddenParts() {
            return this.hiddenParts;
        }

        public List<MPart> getVisibleParts() {
            return this.visibleParts;
        }

        public void partActivated(MPart part) {
            if (this.valid && part == null) {
                this.valid = false;
            }
            ++this.activated;
            this.activatedParts.add(part);
        }

        public void partBroughtToTop(MPart part) {
        }

        public void partDeactivated(MPart part) {
            if (this.valid && part == null) {
                this.valid = false;
            }
            ++this.deactivated;
            this.deactivatedParts.add(part);
        }

        public void partHidden(MPart part) {
            if (this.valid && part == null) {
                this.valid = false;
            }
            ++this.hidden;
            this.hiddenParts.add(part);
        }

        public void partVisible(MPart part) {
            if (this.valid && part == null) {
                this.valid = false;
            }
            ++this.visible;
            this.visibleParts.add(part);
        }
    }
}

