/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import junit.framework.TestCase;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.internal.services.EclipseAdapter;
import org.eclipse.e4.core.services.adapter.Adapter;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.services.ActiveContextsFunction;
import org.eclipse.e4.ui.internal.workbench.ActivePartLookupFunction;
import org.eclipse.e4.ui.internal.workbench.ExceptionHandler;
import org.eclipse.e4.ui.internal.workbench.ReflectionContributionFactory;
import org.eclipse.e4.ui.internal.workbench.WorkbenchLogger;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.IExceptionHandler;
import org.eclipse.e4.ui.workbench.swt.WorkbenchSWTActivator;
import org.osgi.framework.BundleContext;

public abstract class HeadlessStartupTest
extends TestCase {
    protected IEclipseContext osgiContext;
    protected IEclipseContext applicationContext;

    protected void setUp() throws Exception {
        this.applicationContext = this.createApplicationContext();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.applicationContext.dispose();
    }

    private IEclipseContext createOSGiContext() {
        this.osgiContext = EclipseContextFactory.getServiceContext((BundleContext)WorkbenchSWTActivator.getDefault().getBundle().getBundleContext());
        return this.osgiContext;
    }

    private IEclipseContext createApplicationContext() {
        return this.createApplicationContext(this.createOSGiContext());
    }

    protected IEclipseContext createApplicationContext(IEclipseContext osgiContext) {
        HeadlessStartupTest.assertNotNull((Object)osgiContext);
        IEclipseContext appContext = osgiContext.createChild("Application Context");
        appContext.set(IEclipseContext.class.getName(), (Object)appContext);
        appContext.set(IContributionFactory.class.getName(), (Object)new ReflectionContributionFactory((IExtensionRegistry)appContext.get(IExtensionRegistry.class.getName())));
        appContext.set(IExceptionHandler.class.getName(), (Object)new ExceptionHandler());
        appContext.set(Logger.class.getName(), (Object)new WorkbenchLogger());
        appContext.set(Adapter.class.getName(), ContextInjectionFactory.make(EclipseAdapter.class, (IEclipseContext)appContext));
        appContext.set(ContextManager.class.getName(), (Object)new ContextManager());
        appContext.set("activeContexts", (Object)new ActiveContextsFunction());
        appContext.set("e4ActivePart", (Object)new ActivePartLookupFunction());
        appContext.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext eventsContext) {
                Object o = eventsContext.get("e4ActivePart");
                if (o instanceof MPart) {
                    eventsContext.set("activePartId", (Object)((MPart)o).getElementId());
                }
                return true;
            }

            public String toString() {
                return "HeadlessStartupTest$RunAndTrack[activePartId]";
            }
        });
        return appContext;
    }
}

