/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;

public class MPartTest
extends TestCase {
    protected IEclipseContext appContext;
    protected E4Workbench wb;

    protected void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
    }

    protected void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        if (this.appContext instanceof IDisposable) {
            this.appContext.dispose();
        }
    }

    public void testSetName() {
        MWindow window = this.createWindowWithOneView("Part Name");
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        CTabFolder folder = (CTabFolder)stack.getWidget();
        CTabItem item = folder.getItem(0);
        MPartTest.assertEquals((String)"Part Name", (String)item.getText());
        part.setLabel("Another Name");
        MPartTest.assertEquals((String)"Another Name", (String)item.getText());
    }

    public void testCTabItem_GetImage() {
        MWindow window = this.createWindowWithOneView("Part Name");
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        CTabFolder folder = (CTabFolder)stack.getWidget();
        CTabItem item = folder.getItem(0);
        MPartTest.assertNotNull((Object)item.getImage());
    }

    private void testDeclaredName(String declared, String expected) {
        MWindow window = this.createWindowWithOneView(declared);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        CTabFolder folder = (CTabFolder)stack.getWidget();
        CTabItem item = folder.getItem(0);
        MPartTest.assertEquals((String)expected, (String)item.getText());
    }

    public void testDeclaredNameNull() {
        this.testDeclaredName(null, "");
    }

    public void testDeclaredNameEmpty() {
        this.testDeclaredName("", "");
    }

    public void testDeclaredNameDefined() {
        this.testDeclaredName("partName", "partName");
    }

    private void testDeclaredTooltip(String partToolTip, String expectedToolTip) {
        MWindow window = this.createWindowWithOneView("Part Name", partToolTip);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        CTabFolder folder = (CTabFolder)stack.getWidget();
        CTabItem item = folder.getItem(0);
        MPartTest.assertEquals((String)expectedToolTip, (String)item.getToolTipText());
    }

    public void testDeclaredTooltipNull() {
        this.testDeclaredTooltip(null, null);
    }

    public void testDeclaredTooltipEmptyString() {
        this.testDeclaredTooltip("", "");
    }

    public void testDeclaredTooltipDefined() {
        this.testDeclaredTooltip("partToolTip", "partToolTip");
    }

    private void testMPart_setTooltip(String partToolTip, String expectedToolTip) {
        MWindow window = this.createWindowWithOneView("Part Name");
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        CTabFolder folder = (CTabFolder)stack.getWidget();
        CTabItem item = folder.getItem(0);
        MPartTest.assertEquals(null, (String)item.getToolTipText());
        part.setTooltip(partToolTip);
        MPartTest.assertEquals((String)expectedToolTip, (String)item.getToolTipText());
    }

    public void testMPart_setTooltipNull() {
        this.testMPart_setTooltip(null, null);
    }

    public void testMPart_setTooltipEmptyString() {
        this.testMPart_setTooltip("", "");
    }

    public void testMPart_setTooltipDefined() {
        this.testMPart_setTooltip("partToolTip", "partToolTip");
    }

    public void testMPart_getContext() {
        MWindow window = this.createWindowWithOneView("Part Name");
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        IPresentationEngine renderer = (IPresentationEngine)this.appContext.get(IPresentationEngine.class.getName());
        renderer.removeGui((MUIElement)part);
        MPartTest.assertNull((Object)part.getContext());
    }

    private MWindow createWindowWithOneView(String partName) {
        return this.createWindowWithOneView(partName, null);
    }

    private MWindow createWindowWithOneView(String partName, String toolTip) {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        window.setHeight(300);
        window.setWidth(400);
        window.setLabel("MyWindow");
        MPartSashContainer sash = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        window.getChildren().add(sash);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        sash.getChildren().add(stack);
        MPart contributedPart = BasicFactoryImpl.eINSTANCE.createPart();
        stack.getChildren().add(contributedPart);
        contributedPart.setLabel(partName);
        contributedPart.setTooltip(toolTip);
        contributedPart.setIconURI("platform:/plugin/org.eclipse.e4.ui.tests/icons/filenav_nav.gif");
        contributedPart.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        return window;
    }
}

