/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.swt.modeling.MenuServiceFilter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuRenderer
extends SWTPartRenderer {
    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MMenu)) {
            return null;
        }
        MMenu menuModel = (MMenu)element;
        Menu newMenu = null;
        if (parent instanceof Decorations) {
            MUIElement container = (MUIElement)((EObject)element).eContainer();
            newMenu = container instanceof MWindow ? new Menu((Decorations)parent, 2) : new Menu((Decorations)parent, 8);
        } else {
            if (parent instanceof Menu) {
                int addIndex = this.calcVisibleIndex((MUIElement)menuModel);
                MenuItem newItem = new MenuItem((Menu)parent, 64, addIndex);
                this.setItemText(menuModel, newItem);
                newItem.setImage(this.getImage((MUILabel)menuModel));
                newItem.setEnabled(menuModel.isEnabled());
                return newItem;
            }
            if (parent instanceof Control) {
                newMenu = new Menu((Control)parent);
            }
        }
        return newMenu;
    }

    @Override
    public void processContents(MElementContainer<MUIElement> container) {
        Object obj = container.getWidget();
        MElementContainer<MUIElement> menuModel = container;
        if (obj instanceof Menu && (((Menu)obj).getStyle() & 2) != 0 && menuModel instanceof MMenu) {
            if (container.getChildren().isEmpty()) {
                return;
            }
            IEclipseContext ctx = this.getContext((MUIElement)container);
            MenuServiceFilter filter = (MenuServiceFilter)ctx.get(MenuServiceFilter.class);
            filter.showMenu(null, (Menu)obj, (MMenu)menuModel);
            return;
        }
        if (container.getChildren().size() == 0) {
            MMenuSeparator sep = MenuFactoryImpl.eINSTANCE.createMenuSeparator();
            sep.setElementId("placeholder");
            container.getChildren().add(sep);
        }
        super.processContents(container);
    }

    private void setItemText(MMenu model, MenuItem item) {
        String text = model.getLabel();
        if (text == null) {
            text = "";
        }
        item.setText(text);
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        Widget widget = (Widget)child.getWidget();
        if (widget != null && !widget.isDisposed()) {
            widget.dispose();
        }
    }

    public Object getUIContainer(MUIElement element) {
        if (!(element instanceof MMenuElement)) {
            return null;
        }
        if (element.getParent().getWidget() instanceof MenuItem) {
            MenuItem mi = (MenuItem)element.getParent().getWidget();
            if (mi.getMenu() == null) {
                mi.setMenu(new Menu(mi));
            }
            return mi.getMenu();
        }
        return super.getUIContainer(element);
    }
}

