/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContributionsAnalyzer {
    private static boolean DEBUG = false;

    private static void trace(String msg, Object menu, Object menuModel) {
        System.err.println(String.valueOf(msg) + ": " + menu + ": " + menuModel);
    }

    public static void addMenuContributions(MMenu menuModel, ArrayList<MMenuContribution> toContribute, ArrayList<MMenuElement> menuContributionsToRemove) {
        HashSet<String> existingMenuIds = new HashSet<String>();
        HashSet<String> existingSeparatorNames = new HashSet<String>();
        for (MMenuElement child : menuModel.getChildren()) {
            String elementId = child.getElementId();
            if (child instanceof MMenu && elementId != null) {
                existingMenuIds.add(elementId);
                continue;
            }
            if (!(child instanceof MMenuSeparator) || elementId == null) continue;
            existingSeparatorNames.add(elementId);
        }
        boolean done = toContribute.size() == 0;
        while (!done) {
            ArrayList<MMenuContribution> curList = new ArrayList<MMenuContribution>(toContribute);
            int retryCount = toContribute.size();
            toContribute.clear();
            for (MMenuContribution menuContribution : curList) {
                if (ContributionsAnalyzer.processAddition(menuModel, menuContributionsToRemove, menuContribution, existingMenuIds, existingSeparatorNames)) continue;
                toContribute.add(menuContribution);
            }
            boolean bl = done = toContribute.size() == 0 || toContribute.size() == retryCount;
        }
    }

    private static boolean processAddition(MMenu menuModel, ArrayList<MMenuElement> menuContributionsToRemove, MMenuContribution menuContribution, HashSet<String> existingMenuIds, HashSet<String> existingSeparatorNames) {
        int idx = ContributionsAnalyzer.getIndex(menuModel, menuContribution.getPositionInParent());
        if (idx == -1) {
            return false;
        }
        for (MMenuElement item : menuContribution.getChildren()) {
            if (item instanceof MMenu && existingMenuIds.contains(item.getElementId()) || item instanceof MMenuSeparator && existingSeparatorNames.contains(item.getElementId())) continue;
            MMenuElement copy = (MMenuElement)EcoreUtil.copy((EObject)((EObject)item));
            if (DEBUG) {
                ContributionsAnalyzer.trace("addMenuContribution " + copy, menuModel.getWidget(), menuModel);
            }
            menuContributionsToRemove.add(copy);
            menuModel.getChildren().add(idx++, copy);
            if (!(copy instanceof MMenu)) continue;
            existingMenuIds.add(copy.getElementId());
        }
        return true;
    }

    public static List<MToolBarElement> addToolBarContributions(MToolBar menuModel, List<MToolBarContribution> toContribute) {
        ArrayList<MToolBarElement> contributions = new ArrayList<MToolBarElement>();
        boolean done = toContribute.size() == 0;
        while (!done) {
            ArrayList<MToolBarContribution> curList = new ArrayList<MToolBarContribution>(toContribute);
            int retryCount = toContribute.size();
            toContribute.clear();
            for (MToolBarContribution menuContribution : curList) {
                if (ContributionsAnalyzer.processAddition(menuModel, menuContribution, contributions)) continue;
                toContribute.add(menuContribution);
            }
            boolean bl = done = toContribute.size() == 0 || toContribute.size() == retryCount;
        }
        return contributions;
    }

    private static boolean processAddition(MToolBar toolBarModel, MToolBarContribution toolBarContribution, List<MToolBarElement> contributions) {
        int idx = ContributionsAnalyzer.getIndex(toolBarModel, toolBarContribution.getPositionInParent());
        if (idx == -1) {
            return false;
        }
        for (MToolBarElement item : toolBarContribution.getChildren()) {
            MToolBarElement copy = (MToolBarElement)EcoreUtil.copy((EObject)((EObject)item));
            if (DEBUG) {
                ContributionsAnalyzer.trace("addToolBarContribution " + copy, toolBarModel.getWidget(), toolBarModel);
            }
            toolBarModel.getChildren().add(idx++, copy);
            contributions.add(copy);
        }
        return true;
    }

    public static List<MTrimElement> addTrimBarContributions(MTrimBar trimBar, List<MTrimContribution> toContribute) {
        ArrayList<MTrimElement> contributions = new ArrayList<MTrimElement>();
        boolean done = toContribute.size() == 0;
        while (!done) {
            ArrayList<MTrimContribution> curList = new ArrayList<MTrimContribution>(toContribute);
            int retryCount = toContribute.size();
            toContribute.clear();
            for (MTrimContribution menuContribution : curList) {
                if (ContributionsAnalyzer.processAddition(trimBar, menuContribution, contributions)) continue;
                toContribute.add(menuContribution);
            }
            boolean bl = done = toContribute.size() == 0 || toContribute.size() == retryCount;
        }
        return contributions;
    }

    private static boolean processAddition(MTrimBar toolBarModel, MTrimContribution toolBarContribution, List<MTrimElement> contributions) {
        int idx = ContributionsAnalyzer.getIndex(toolBarModel, toolBarContribution.getPositionInParent());
        if (idx == -1) {
            return false;
        }
        for (MTrimElement item : toolBarContribution.getChildren()) {
            MTrimElement copy = (MTrimElement)EcoreUtil.copy((EObject)((EObject)item));
            if (DEBUG) {
                ContributionsAnalyzer.trace("addToolBarContribution " + copy, toolBarModel.getWidget(), toolBarModel);
            }
            toolBarModel.getChildren().add(idx++, copy);
            contributions.add(copy);
        }
        return true;
    }

    private static int getIndex(MElementContainer<?> menuModel, String positionInParent) {
        String id = null;
        String modifier = null;
        if (positionInParent != null && positionInParent.length() > 0) {
            String[] array = positionInParent.split("=");
            modifier = array[0];
            id = array[1];
        }
        if (id == null) {
            return menuModel.getChildren().size();
        }
        int idx = 0;
        int size = menuModel.getChildren().size();
        while (idx < size) {
            if (id.equals(((MUIElement)menuModel.getChildren().get(idx)).getElementId())) {
                if ("after".equals(modifier)) {
                    ++idx;
                }
                return idx;
            }
            ++idx;
        }
        return id.equals("additions") ? menuModel.getChildren().size() : -1;
    }
}

