/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.repository.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ease.ui.repository.IScript;
import org.eclipse.ease.ui.scripts.repository.impl.ScriptContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.services.IServiceLocator;

public class ScriptContributionFactory
extends AbstractContributionFactory {
    private final List<IScript> fScripts = new ArrayList<IScript>();
    private IContributionManager fContributionManager = null;

    public ScriptContributionFactory(String location, String namespace) {
        super(location, namespace);
        IMenuService menuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
        menuService.addContributionFactory((AbstractContributionFactory)this);
    }

    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        boolean rendered = this.fContributionManager instanceof MenuManager && ((MenuManager)this.fContributionManager).getMenu() != null;
        if (rendered |= this.fContributionManager instanceof ToolBarManager && ((ToolBarManager)this.fContributionManager).getControl() != null) {
            IContributionItem[] iContributionItemArray = this.fContributionManager.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                if (item instanceof ScriptContributionItem) {
                    return;
                }
                ++n2;
            }
        }
        if (this.getLocation().endsWith("org.eclipse.ui.popup.any?after=additions")) {
            for (IScript script : this.fScripts) {
                additions.addContributionItem((IContributionItem)new ScriptContributionItem(script, script.getParameters().get("popup")), null);
            }
        } else {
            for (IScript script : this.fScripts) {
                additions.addContributionItem((IContributionItem)new ScriptContributionItem(script), null);
            }
        }
    }

    public void addScript(IScript script) {
        this.fScripts.add(script);
    }

    public void removeScript(IScript script) {
        this.fScripts.remove(script);
    }

    public void setAffectedContribution(IContributionManager manager) {
        this.fContributionManager = manager;
    }
}

