/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui.handler;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.ease.modules.unittest.ui.Activator;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class RecentSuiteFilesContributionFactory
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator fServiceLocator;

    public void initialize(IServiceLocator serviceLocator) {
        this.fServiceLocator = serviceLocator;
    }

    protected IContributionItem[] getContributionItems() {
        List<IFile> files = Activator.getDefault().getRecentFiles();
        IContributionItem[] items = new IContributionItem[files.size()];
        int index = 0;
        for (IFile file : files) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("org.eclipse.ease.unittest.commands.loadTestSuite.suite", file.getFullPath().toString());
            CommandContributionItemParameter contributionParameter = new CommandContributionItemParameter(this.fServiceLocator, null, "org.eclipse.ease.unittest.commands.loadTestSuite", 8);
            contributionParameter.parameters = parameters;
            String name = file.getName();
            String extension = file.getFileExtension();
            if (extension != null) {
                name = name.substring(0, name.length() - extension.length() - 1);
            }
            contributionParameter.label = name;
            contributionParameter.visibleEnabled = true;
            Activator.getDefault();
            contributionParameter.icon = Activator.getImageDescriptor("/icons/eobj16/testsuite.png");
            items[index++] = new CommandContributionItem(contributionParameter);
        }
        return items;
    }
}

