/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.dnd;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.EnvironmentModule;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.ui.dnd.IShellDropHandler;
import org.eclipse.ease.ui.modules.ui.ModulesTools;

public class ModulesDropHandler
implements IShellDropHandler {
    @Override
    public boolean accepts(IScriptEngine scriptEngine, Object element) {
        return element instanceof ModuleDefinition || element instanceof Method || element instanceof Field;
    }

    @Override
    public void performDrop(IScriptEngine scriptEngine, Object element) {
        try {
            ICodeFactory codeFactory = ScriptService.getCodeFactory((IScriptEngine)scriptEngine);
            Method loadModuleMethod = EnvironmentModule.class.getMethod("loadModule", String.class);
            if (element instanceof ModuleDefinition) {
                String call = codeFactory.createFunctionCall(loadModuleMethod, new Object[]{((ModuleDefinition)element).getPath().toString()});
                scriptEngine.executeAsync((Object)call);
            } else if (element instanceof Method) {
                ModuleDefinition declaringModule = ModulesTools.getDeclaringModule((Method)element);
                if (!ModuleHelper.getLoadedModules((IScriptEngine)scriptEngine).contains(declaringModule)) {
                    String call = codeFactory.createFunctionCall(loadModuleMethod, new Object[]{declaringModule.getPath().toString()});
                    scriptEngine.executeAsync((Object)call);
                }
                scriptEngine.executeAsync((Object)(String.valueOf(((Method)element).getName()) + "()"));
            } else if (element instanceof Field) {
                ModuleDefinition declaringModule = ModulesTools.getDeclaringModule((Field)element);
                if (!ModuleHelper.getLoadedModules((IScriptEngine)scriptEngine).contains(declaringModule)) {
                    String call = codeFactory.createFunctionCall(loadModuleMethod, new Object[]{declaringModule.getPath().toString()});
                    scriptEngine.executeAsync((Object)call);
                }
                scriptEngine.executeAsync((Object)((Field)element).getName());
            } else {
                scriptEngine.executeAsync(element);
            }
        }
        catch (Exception e) {
            Logger.error((String)"org.eclipse.ease.ui", (String)"loadModule() method not found in Environment module", (Throwable)e);
            scriptEngine.executeAsync(element);
        }
    }
}

