/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.help.hovers;

import java.lang.reflect.Field;
import org.eclipse.ease.ui.help.hovers.JavaClassHelpResolver;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.ResolvedBinaryField;

public class JavaFieldHelpResolver
extends JavaClassHelpResolver {
    private final Field fField;

    public JavaFieldHelpResolver(Field field) {
        super(field.getDeclaringClass().getPackage().getName(), field.getDeclaringClass().getSimpleName());
        this.fField = field;
    }

    @Override
    protected IJavaElement resolveJavaElement(ITypeRoot javaElement) {
        IType type;
        if (javaElement instanceof ClassFile && (type = ((ClassFile)javaElement).getType()) instanceof JavaElement) {
            return new ResolvedBinaryField((JavaElement)type, this.fField.getName(), JavaFieldHelpResolver.getDescriptor(this.fField));
        }
        return null;
    }

    private static String getDescriptor(Field field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(JavaFieldHelpResolver.getDescriptor(field.getDeclaringClass()));
        buffer.append('.');
        buffer.append(field.getName());
        buffer.append(')');
        buffer.append(JavaFieldHelpResolver.getDescriptor(field.getType()));
        return buffer.toString();
    }
}

