/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.help.hovers;

import java.lang.reflect.Method;
import org.eclipse.ease.ui.help.hovers.JavaClassHelpResolver;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;

public class JavaMethodHelpResolver
extends JavaClassHelpResolver {
    private final Method fMethod;

    public JavaMethodHelpResolver(Method method) {
        super(method.getDeclaringClass().getPackage().getName(), method.getDeclaringClass().getSimpleName());
        this.fMethod = method;
    }

    @Override
    protected IJavaElement resolveJavaElement(ITypeRoot javaElement) {
        if (javaElement instanceof IClassFile) {
            Class<?>[] methodParameters = this.fMethod.getParameterTypes();
            String[] parameterTypes = new String[methodParameters.length];
            int index = 0;
            while (index < parameterTypes.length) {
                parameterTypes[index] = JavaMethodHelpResolver.getDescriptor(methodParameters[index]);
                ++index;
            }
            return ((IClassFile)javaElement).getType().getMethod(this.fMethod.getName(), parameterTypes);
        }
        return null;
    }
}

