/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.launching;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.tools.RunnableWithResult;
import org.eclipse.ease.ui.console.ScriptConsole;
import org.eclipse.ease.ui.tools.AbstractLaunchDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class EaseLaunchDelegate
extends AbstractLaunchDelegate {
    private static final String LAUNCH_CONFIGURATION_ID = "org.eclipse.ease.launchConfigurationType";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String parameterString;
        final Object resource = ResourceTools.resolveFile((Object)this.getFileLocation(configuration), null, (boolean)true);
        String engineID = configuration.getAttribute("Script engine", "");
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        EngineDescription engineDescription = scriptService.getEngineByID(engineID);
        if ("debug".equals(mode) && !engineDescription.supportsDebugging()) {
            engineDescription = null;
            ScriptType scriptType = scriptService.getScriptType(ResourceTools.toAbsoluteLocation((Object)resource, null));
            List engines = scriptService.getEngines(scriptType.getName());
            for (EngineDescription description : engines) {
                if (!description.supportsDebugging()) continue;
                engineDescription = description;
                break;
            }
            if (engineDescription != null) {
                RunnableWithResult<Boolean> runnable = new RunnableWithResult<Boolean>(){

                    public void run() {
                        boolean confirmEngineSwitch = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Configuration change needed", (String)"The currently selected script engine does not support debugging. However an alternative engine is available. Do you want to debug your script using that alternative engine?");
                        this.setResult(confirmEngineSwitch);
                    }
                };
                Display.getDefault().syncExec((Runnable)runnable);
                if (!((Boolean)runnable.getResult()).booleanValue()) {
                    return;
                }
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Launch error", (String)("No debug engine available for \"" + resource + "\""));
                    }
                });
                return;
            }
        }
        IScriptEngine engine = engineDescription.createEngine();
        engine.setTerminateOnIdle(true);
        ScriptConsole console = ScriptConsole.create(String.valueOf(engine.getName()) + ": " + resource, engine);
        engine.setOutputStream((OutputStream)console.getOutputStream());
        engine.setErrorStream((OutputStream)console.getErrorStream());
        engine.setInputStream((InputStream)console.getInputStream());
        if ("debug".equals(mode)) {
            this.setupDebugger(engine, configuration, launch);
        }
        String[] parameters = !(parameterString = configuration.getAttribute("Startup parameters", "").trim()).isEmpty() ? parameterString.split("\\s+") : new String[]{};
        engine.setVariable("argv", (Object)parameters);
        engine.executeAsync(resource);
        engine.schedule();
    }

    @Override
    protected ILaunchConfiguration createLaunchConfiguration(IResource file, String mode) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(LAUNCH_CONFIGURATION_ID);
        ILaunchConfigurationWorkingCopy configuration = type.newInstance(null, file.getName());
        configuration.setAttribute("File location", ResourceTools.toAbsoluteLocation((Object)file, null));
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        List engines = scriptService.getScriptType(ResourceTools.toAbsoluteLocation((Object)file, null)).getEngines();
        if (engines.isEmpty()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        configuration.setAttribute("Script engine", ((EngineDescription)engines.iterator().next()).getID());
        if ("debug".equals(mode)) {
            configuration.setAttribute("Suspend on startup", true);
        }
        configuration.doSave();
        return configuration;
    }

    @Override
    protected String getFileLocation(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("File location", "");
    }

    @Override
    protected String getLaunchConfigurationId() {
        return LAUNCH_CONFIGURATION_ID;
    }

    private void setupDebugger(IScriptEngine engine, ILaunchConfiguration configuration, ILaunch launch) {
        if (engine instanceof IDebugEngine) {
            boolean suspendOnStartup = false;
            try {
                suspendOnStartup = configuration.getAttribute("Suspend on startup", false);
            }
            catch (CoreException coreException) {}
            boolean suspendOnScriptLoad = false;
            try {
                suspendOnScriptLoad = configuration.getAttribute("Suspend on script load", false);
            }
            catch (CoreException coreException) {}
            boolean showDynamicCode = false;
            try {
                showDynamicCode = configuration.getAttribute("Display dynamic code", false);
            }
            catch (CoreException coreException) {}
            ((IDebugEngine)engine).setupDebugger(launch, suspendOnStartup, suspendOnScriptLoad, showDynamicCode);
        }
    }
}

