/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.Logger;
import org.eclipse.ease.tools.StringTools;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class ResourceTools {
    private static final String PROJECT_SCHEME = "project";

    @Deprecated
    private ResourceTools() {
    }

    public static Object resolveFile(Object location, Object parent, boolean exists) {
        if (location == null) {
            return null;
        }
        Object parentObject = ResourceTools.resolveParent(parent);
        Object candidate = ResourceTools.resolveAbsolute(location, parentObject, false);
        if (candidate == null && parentObject != null) {
            candidate = ResourceTools.resolveRelativeFile(location, parentObject, exists);
        }
        if (candidate instanceof IFile) {
            return ((IFile)candidate).exists() || !exists ? candidate : null;
        }
        if (candidate instanceof File && (((File)candidate).isFile() || !exists)) {
            return ((File)candidate).exists() || !exists ? candidate : null;
        }
        return null;
    }

    public static Object resolveFolder(Object location, Object parent, boolean exists) {
        if (location == null) {
            return null;
        }
        Object parentObject = ResourceTools.resolveParent(parent);
        Object candidate = ResourceTools.resolveAbsolute(location, parentObject, true);
        if (candidate == null && parentObject != null) {
            candidate = ResourceTools.resolveRelativeFolder(location, parentObject, exists);
        }
        if (candidate instanceof IContainer) {
            return ((IContainer)candidate).exists() || !exists ? candidate : null;
        }
        if (candidate instanceof File && (((File)candidate).isDirectory() || !exists)) {
            return ((File)candidate).exists() || !exists ? candidate : null;
        }
        return null;
    }

    private static Object resolveParent(Object parent) {
        Object parentReference;
        if (parent != null && !(parent instanceof IResource) && !(parent instanceof File) && (parent = ResourceTools.resolveFile(parentReference = parent, null, true)) == null) {
            parent = ResourceTools.resolveFolder(parentReference, null, true);
        }
        if (parent instanceof IFile) {
            return ((IFile)parent).getParent();
        }
        if (parent instanceof File && ((File)parent).isFile()) {
            return ((File)parent).getParentFile();
        }
        return parent;
    }

    private static Object resolveAbsolute(Object location, Object parent, boolean isFolder) {
        block21: {
            if (!isFolder && location instanceof IFile) {
                return location;
            }
            if (isFolder && location instanceof IContainer) {
                return location;
            }
            if (location instanceof String) {
                try {
                    location = URI.create((String)location);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (location instanceof URI) {
                try {
                    location = new File((URI)location);
                }
                catch (Exception exception) {
                    if (!location.toString().startsWith("file:")) break block21;
                    location = new File(location.toString().substring(5));
                }
            }
        }
        if (location instanceof File) {
            return location;
        }
        String reference = location.toString();
        if (reference.startsWith(PROJECT_SCHEME)) {
            IProject project;
            if (parent instanceof IResource && (project = ((IResource)parent).getProject()) != null) {
                if (isFolder) {
                    return project.getFolder((IPath)new Path(reference.substring(PROJECT_SCHEME.length() + 2)));
                }
                return project.getFile((IPath)new Path(reference.substring(PROJECT_SCHEME.length() + 2)));
            }
        } else if (reference.startsWith("workspace")) {
            Path path = new Path(reference.substring("workspace".length() + 2));
            if (isFolder) {
                if (path.segmentCount() > 1) {
                    return ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
                }
                if (path.segmentCount() == 1) {
                    return ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                }
            } else if (path.segmentCount() > 1) {
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            }
        } else {
            File systemFile = new File(reference);
            if (systemFile.isAbsolute()) {
                return systemFile;
            }
        }
        return null;
    }

    private static Object resolveRelativeFile(Object location, Object parent, boolean exists) {
        File systemFile;
        String reference = location.toString();
        if (parent instanceof IResource) {
            IFile relativeFile = ((IContainer)parent).getFile((IPath)new Path(reference));
            if (relativeFile.exists() || !exists) {
                return relativeFile;
            }
        } else if (parent instanceof File && ((systemFile = new File(String.valueOf(((File)parent).getAbsolutePath()) + File.separator + reference)).exists() && systemFile.isFile() || !exists)) {
            return systemFile;
        }
        return null;
    }

    private static Object resolveRelativeFolder(Object location, Object parent, boolean exists) {
        File systemFolder;
        if (parent instanceof IResource) {
            IPath targetPath = ((IResource)parent).getFullPath().append((IPath)new Path(location.toString()));
            IContainer relativeFolder = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(targetPath);
            if (relativeFolder == null && targetPath.segmentCount() == 1) {
                relativeFolder = ResourcesPlugin.getWorkspace().getRoot().getProject(targetPath.segment(0));
            }
            if (relativeFolder == null) {
                relativeFolder = ((IContainer)parent).getFolder((IPath)new Path(location.toString()));
            }
            if (relativeFolder.exists() || !exists) {
                return relativeFolder;
            }
        } else if (parent instanceof File && ((systemFolder = new File(String.valueOf(((File)parent).getAbsolutePath()) + File.separator + location)).exists() && systemFolder.isDirectory() || !exists)) {
            return systemFolder;
        }
        return null;
    }

    public static String toProjectRelativeLocation(Object location, Object parent) {
        Object resource = ResourceTools.resolveFile(location, parent, true);
        if (!(resource instanceof IResource)) {
            resource = ResourceTools.resolveFolder(location, parent, true);
        }
        if (resource instanceof IResource) {
            return "project://" + ((IResource)resource).getProjectRelativePath().toPortableString();
        }
        return null;
    }

    public static String toAbsoluteLocation(Object location, Object parent) {
        Object file = ResourceTools.resolveFile(location, parent, true);
        if (file instanceof IResource) {
            return "workspace:/" + ((IResource)file).getFullPath().toPortableString();
        }
        if (file instanceof File) {
            return ((File)file).toURI().toASCIIString();
        }
        Object folder = ResourceTools.resolveFolder(location, parent, true);
        if (folder instanceof IResource) {
            return "workspace:/" + ((IResource)folder).getFullPath().toPortableString();
        }
        if (folder instanceof File) {
            return ((File)folder).toURI().toASCIIString();
        }
        return null;
    }

    public static boolean exists(Object location) {
        if (location == null) {
            return false;
        }
        if (ResourceTools.resolveFile(location, null, true) != null) {
            return true;
        }
        try {
            URI uri = location instanceof URI ? (URI)location : URI.create(location.toString());
            InputStream stream = uri.toURL().openStream();
            if (stream != null) {
                stream.close();
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public static Object getResource(Object location) {
        Object file = ResourceTools.resolveFile(location, null, true);
        if (file != null) {
            return file;
        }
        file = ResourceTools.resolveFolder(location, null, true);
        if (file != null) {
            return file;
        }
        if (location instanceof URI) {
            return location;
        }
        try {
            if (location != null) {
                return URI.create(location.toString());
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static InputStream getInputStream(Object location) {
        try {
            Object resource = ResourceTools.getResource(location);
            if (resource instanceof IFile) {
                return ((IFile)resource).getContents();
            }
            if (resource instanceof File) {
                return new FileInputStream((File)resource);
            }
            if (resource instanceof URI) {
                return ((URI)resource).toURL().openStream();
            }
            if (location != null) {
                return new URL(location.toString()).openStream();
            }
        }
        catch (Exception e) {
            Logger.error("org.eclipse.ease", "Cannot open stream for \"" + location + "\"", e);
        }
        return null;
    }

    public static String resourceToString(Object location) {
        try {
            BufferedInputStream inputStream = new BufferedInputStream(ResourceTools.getInputStream(location));
            return StringTools.toString(inputStream);
        }
        catch (IOException e) {
            Logger.error("org.eclipse.ease", "Cannot read from resource \"" + location + "\"", e);
            return null;
        }
    }

    public static URI toURI(IPath path) {
        if (path == null) {
            return null;
        }
        if (path.isAbsolute()) {
            return ResourceTools.toURI(path.toFile().getAbsolutePath());
        }
        try {
            return new URI(ResourceTools.escapeColons(path.toString()));
        }
        catch (URISyntaxException uRISyntaxException) {
            return ResourceTools.toURI(path.toFile().getAbsolutePath());
        }
    }

    private static URI toURI(String pathString) {
        if (File.separatorChar != '/') {
            pathString = pathString.replace(File.separatorChar, '/');
        }
        int length = pathString.length();
        StringBuffer pathBuf = new StringBuffer(length + 1);
        if (length > 0 && pathString.charAt(0) != '/') {
            pathBuf.append('/');
        }
        if (pathString.startsWith("//")) {
            pathBuf.append('/').append('/');
        }
        pathBuf.append(pathString);
        try {
            return new URI("file", null, pathBuf.toString(), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(pathString).toURI();
        }
    }

    private static String escapeColons(String string) {
        if (string.indexOf(58) == -1) {
            return string;
        }
        int length = string.length();
        StringBuffer result = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            char c = string.charAt(i);
            if (c == ':') {
                result.append("%3A");
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static IPath toPath(String location) {
        if (location == null) {
            return null;
        }
        Object resource = ResourceTools.resolveAbsolute(location, null, true);
        if (resource == null) {
            resource = ResourceTools.resolveAbsolute(location, null, false);
        }
        return resource instanceof IResource ? ((IResource)resource).getFullPath() : null;
    }

    public static String toString(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return ResourceTools.toString(new InputStreamReader(stream));
    }

    public static String toString(Reader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        char[] buffer = new char[1024];
        int bytes = 0;
        do {
            if ((bytes = reader.read(buffer)) <= 0) continue;
            out.append(buffer, 0, bytes);
        } while (bytes != -1);
        return out.toString();
    }

    public static IFile getActiveFile() {
        IEditorPart editor;
        IWorkbenchPage workbenchPage;
        IWorkbenchWindow workbenchWindow;
        IFile file = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (workbenchPage = workbenchWindow.getActivePage()) != null && (editor = workbenchPage.getActiveEditor()) != null) {
            file = (IFile)editor.getEditorInput().getAdapter(IFile.class);
        }
        return file;
    }
}

