/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.handler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.ease.Logger;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.ui.scripts.ScriptEditorInput;
import org.eclipse.ease.ui.scripts.handler.RunScript;
import org.eclipse.ease.ui.scripts.repository.IRepositoryService;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class EditScript
extends AbstractHandler
implements IHandler {
    public static final String COMMAND_ID = "org.eclipse.ease.commands.script.edit";
    public static final String PARAMETER_NAME = "org.eclipse.ease.commands.script.edit.name";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IScript script = RunScript.getScript(event, PARAMETER_NAME);
        if (script != null) {
            final Object content = script.getResource();
            if (content instanceof IFile && ((IFile)content).exists()) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)content));
                }
                catch (PartInitException e) {
                    Logger.error((String)"org.eclipse.ease.ui.scripts", (String)("Could not open editor for file " + content), (Throwable)e);
                }
            } else if (content instanceof File && ((File)content).exists()) {
                ScriptType type = script.getType();
                IEditorDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor("foo." + type.getDefaultExtension());
                if (descriptor != null) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        final ScriptEditorInput editorInput = new ScriptEditorInput(script);
                        final IEditorPart editor = page.openEditor((IEditorInput)editorInput, descriptor.getId());
                        editor.addPropertyListener(new IPropertyListener(){

                            public void propertyChanged(Object source, int propId) {
                                if (257 == propId && editor instanceof AbstractDecoratedTextEditor && !editor.isDirty()) {
                                    block15: {
                                        IDocumentProvider documentProvider = ((AbstractTextEditor)editor).getDocumentProvider();
                                        String newSource = documentProvider.getDocument((Object)editorInput).get();
                                        FileOutputStream outputStream = null;
                                        try {
                                            try {
                                                outputStream = new FileOutputStream((File)content);
                                                outputStream.write(newSource.getBytes());
                                            }
                                            catch (Exception e) {
                                                Logger.error((String)"org.eclipse.ease.ui.scripts", (String)"Could not store recorded script.", (Throwable)e);
                                                if (outputStream != null) {
                                                    try {
                                                        outputStream.close();
                                                    }
                                                    catch (IOException iOException) {}
                                                }
                                                break block15;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            if (outputStream != null) {
                                                try {
                                                    outputStream.close();
                                                }
                                                catch (IOException iOException) {}
                                            }
                                            throw throwable;
                                        }
                                        if (outputStream != null) {
                                            try {
                                                outputStream.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                    }
                                    IRepositoryService repositoryService = (IRepositoryService)PlatformUI.getWorkbench().getService(IRepositoryService.class);
                                    repositoryService.update(false);
                                }
                            }
                        });
                    }
                    catch (PartInitException e) {
                        Logger.error((String)"org.eclipse.ease.ui.scripts", (String)("Could not open editor for file " + content), (Throwable)e);
                    }
                }
            } else {
                ScriptType type = script.getType();
                IEditorDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor("foo." + type.getDefaultExtension());
                if (descriptor != null) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        ScriptEditorInput editorInput = new ScriptEditorInput(script);
                        page.openEditor((IEditorInput)editorInput, descriptor.getId());
                    }
                    catch (PartInitException e) {
                        Logger.error((String)"org.eclipse.ease.ui.scripts", (String)("Could not open editor for file " + content), (Throwable)e);
                    }
                }
            }
        }
        return null;
    }
}

