/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.keywordhandler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.ease.ui.tools.AbstractWorkbenchRunnable;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class SaveEditorHandler
implements EventHandler,
IPartListener,
IPropertyListener {
    private final Map<String, Collection<IScript>> fRegisteredScripts = new HashMap<String, Collection<IScript>>();

    private static List<String> createPattern(String fileMask) {
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = fileMask.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            result.add(token.startsWith("^") ? token : token.replaceAll("\\*", ".*"));
            ++n2;
        }
        return result;
    }

    public SaveEditorHandler() {
        new AbstractWorkbenchRunnable(){

            public void run() {
                SaveEditorHandler.this.initialize();
            }
        }.launch();
    }

    private void initialize() {
        IEditorPart editor;
        IPartService service = (IPartService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IPartService.class);
        service.addPartListener((IPartListener)this);
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && (editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) != null) {
            editor.addPropertyListener((IPropertyListener)this);
        }
    }

    public void handleEvent(Event event) {
        IScript script = (IScript)event.getProperty("script");
        String value = (String)event.getProperty("value");
        String oldValue = (String)event.getProperty("oldValue");
        if (oldValue != null) {
            for (String pattern : SaveEditorHandler.createPattern(oldValue)) {
                if (!this.fRegisteredScripts.containsKey(pattern)) continue;
                this.fRegisteredScripts.get(pattern).remove(script);
            }
        }
        if (value != null) {
            for (String pattern : SaveEditorHandler.createPattern(value)) {
                if (!this.fRegisteredScripts.containsKey(pattern)) {
                    this.fRegisteredScripts.put(pattern, new HashSet());
                }
                this.fRegisteredScripts.get(pattern).add(script);
            }
        }
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            part.addPropertyListener((IPropertyListener)this);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            part.addPropertyListener((IPropertyListener)this);
        }
    }

    public void propertyChanged(Object source, int propId) {
        IEditorInput input;
        if (propId == 257 && source instanceof IEditorPart && !((IEditorPart)source).isDirty() && (input = ((IEditorPart)source).getEditorInput()) instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)input).getFile();
            String location = ResourceTools.toAbsoluteLocation((Object)file, null);
            for (Map.Entry<String, Collection<IScript>> entry : this.fRegisteredScripts.entrySet()) {
                if (!Pattern.matches(entry.getKey(), location)) continue;
                for (IScript script : entry.getValue()) {
                    script.run(location);
                }
            }
        }
    }
}

