/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui.views;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.modules.unittest.ITestListener;
import org.eclipse.ease.modules.unittest.components.TestFile;
import org.eclipse.ease.modules.unittest.components.TestStatus;
import org.eclipse.ease.modules.unittest.components.TestSuite;
import org.eclipse.ease.modules.unittest.ui.Activator;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class SuiteRuntimeInformation
implements ITestListener {
    private static final String XML_PARAMETER_TIMING = "timing";
    private static final String XML_PARAMETER_INDEX = "index";
    private static final String XML_NODE_RUN = "run";
    private static final String XML_NODE_FILE = "file";
    private static final long DEFAULT_RUNTIME = 10000L;
    private static final int RUNS_TO_SAVE = 10;
    private final HashMap<String, RuntimeInformation> fRuntimes = new HashMap();
    private List<TestFile> fTestFiles;
    private long fEstimatedEndOfTests;
    private final TestSuite fTestSuite;

    public SuiteRuntimeInformation(TestSuite suite) {
        this.fTestSuite = suite;
        this.load();
        this.fTestFiles = this.fTestSuite.getActiveTestFiles();
        suite.addTestListener((ITestListener)this);
    }

    private void load() {
        try {
            XMLMemento root = XMLMemento.createReadRoot((Reader)new FileReader(this.getSettingsFile()));
            ResourcesPlugin.getWorkspace().getRoot();
            IMemento[] iMementoArray = root.getChildren(XML_NODE_FILE);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento fileNode = iMementoArray[n2];
                IMemento[] iMementoArray2 = fileNode.getChildren(XML_NODE_RUN);
                int n3 = iMementoArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento runNode = iMementoArray2[n4];
                    this.addTiming(fileNode.getTextData(), Long.parseLong(runNode.getString(XML_PARAMETER_TIMING)));
                    ++n4;
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
    }

    public synchronized void save() {
        block13: {
            FileOutputStream outputStream = null;
            try {
                try {
                    outputStream = new FileOutputStream(this.getSettingsFile());
                    XMLMemento rootNode = XMLMemento.createWriteRoot((String)"root");
                    for (Map.Entry<String, RuntimeInformation> entry : this.fRuntimes.entrySet()) {
                        IMemento fileNode = rootNode.createChild(XML_NODE_FILE);
                        fileNode.putTextData(entry.getKey());
                        ArrayList<Long> timings = entry.getValue().getTimings();
                        int nodeIndex = 0;
                        int index = Math.max(0, timings.size() - 10);
                        while (index < timings.size()) {
                            IMemento runNode = fileNode.createChild(XML_NODE_RUN);
                            runNode.putInteger(XML_PARAMETER_INDEX, nodeIndex++);
                            runNode.putString(XML_PARAMETER_TIMING, Long.toString((Long)timings.get(index)));
                            ++index;
                        }
                    }
                    rootNode.save((Writer)new OutputStreamWriter(outputStream));
                }
                catch (Exception exception) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public synchronized void notify(Object testObject, TestStatus status) {
        if (testObject instanceof TestSuite && status == TestStatus.RUNNING) {
            this.fTestFiles = this.fTestSuite.getActiveTestFiles();
            this.estimateEndOfTests();
        } else if (testObject instanceof TestFile && status != TestStatus.RUNNING && status != TestStatus.NOT_RUN) {
            this.addTiming(SuiteRuntimeInformation.createTestToken((TestFile)testObject), ((TestFile)testObject).getExecutionTime());
            this.fTestFiles.remove(testObject);
            this.estimateEndOfTests();
        }
    }

    private static String createTestToken(TestFile testFile) {
        Object file = testFile.getFile();
        if (file instanceof IFile) {
            return ((IFile)file).getFullPath().toPortableString();
        }
        if (file instanceof File) {
            return ((File)file).getAbsolutePath();
        }
        if (file != null) {
            return file.toString();
        }
        return "<undefind>";
    }

    private synchronized void addTiming(String fileIdentifier, long timing) {
        if (!this.fRuntimes.containsKey(fileIdentifier)) {
            this.fRuntimes.put(fileIdentifier, new RuntimeInformation());
        }
        this.fRuntimes.get(fileIdentifier).addRuntime(timing);
    }

    private File getSettingsFile() {
        IPath path = Activator.getDefault().getStateLocation().append("timing_" + this.fTestSuite.getModel().getFile().getProject().hashCode() + ".xml");
        return path.toFile();
    }

    private synchronized void estimateEndOfTests() {
        long time = 0L;
        for (TestFile file : this.fTestFiles) {
            RuntimeInformation info = this.fRuntimes.get(SuiteRuntimeInformation.createTestToken(file));
            time += info != null ? info.getEstimatedRuntime() : this.getAverageTestTime();
        }
        this.fEstimatedEndOfTests = System.currentTimeMillis() + time;
    }

    private synchronized long getAverageTestTime() {
        long time = 0L;
        int items = 0;
        for (RuntimeInformation info : this.fRuntimes.values()) {
            if (info.getEstimatedRuntime() <= 0L) continue;
            time += info.getEstimatedRuntime();
            ++items;
        }
        if (items > 0) {
            return time / (long)items;
        }
        return 10000L;
    }

    public long getEstimatedTestTime() {
        return this.fEstimatedEndOfTests - System.currentTimeMillis();
    }

    private class RuntimeInformation {
        private final ArrayList<Long> fTimings = new ArrayList();

        private RuntimeInformation() {
        }

        public synchronized long getEstimatedRuntime() {
            if (this.fTimings.isEmpty()) {
                return 10000L;
            }
            int weight = 0;
            long timing = 0L;
            for (Long time : this.fTimings) {
                timing += time * (long)(++weight);
            }
            timing = (long)((double)timing / ((double)(weight + 1) * ((double)weight / 2.0)));
            return timing;
        }

        public synchronized void addRuntime(long time) {
            this.fTimings.add(time);
        }

        public ArrayList<Long> getTimings() {
            return this.fTimings;
        }
    }
}

