/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion.provider;

import java.io.File;
import java.nio.file.Path;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.ui.completion.AbstractCompletionProvider;
import org.eclipse.ease.ui.completion.provider.LocationResolver;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class AbstractFileLocationCompletionProvider
extends AbstractCompletionProvider {
    private static final int ORDER_URI_SCHEME = 100;
    private static final int ORDER_PROJECT = 101;
    private static final int ORDER_FOLDER = 102;
    private static final int ORDER_FILE = 103;
    private final ILabelProvider fLabelProvider = new WorkbenchLabelProvider();

    @Override
    public boolean isActive(ICompletionContext context) {
        return context.getType() == ICompletionContext.Type.STRING_LITERAL;
    }

    @Override
    protected void prepareProposals(ICompletionContext context) {
        LocationResolver resolver = new LocationResolver(context.getFilter(), context.getResource());
        if (resolver.getResolvedFolder() == null || !resolver.isAbsolute() || resolver.getType() == LocationResolver.Type.UNKNOWN) {
            if (AbstractFileLocationCompletionProvider.matches(context.getFilter(), "workspace:/") && this.showCandidate("workspace://")) {
                this.addProposal("workspace://", "workspace://", null, 100, null);
            }
            if (AbstractFileLocationCompletionProvider.matches(context.getFilter(), "project:/") && this.getContext().getResource() instanceof IResource && this.showCandidate("project://")) {
                this.addProposal("project://", "project://", null, 100, null);
            }
            if (AbstractFileLocationCompletionProvider.matches(context.getFilter(), "file://") && this.showCandidate("file:///")) {
                this.addProposal("file:///", "file:///", null, 100, null);
            }
        }
        for (Object object : resolver.getChildren()) {
            if (object instanceof File) {
                String name = ((File)object).getName();
                String suffix = "";
                if (name.isEmpty()) {
                    name = ((File)object).toString().replace('\\', '/');
                } else if (((File)object).isDirectory()) {
                    suffix = "/";
                }
                if (AbstractFileLocationCompletionProvider.matchesIgnoreCase(resolver.getFilterPart(), name) && this.showCandidate(object)) {
                    this.addProposal(name, String.valueOf(resolver.getParentString()) + name + suffix, AbstractFileLocationCompletionProvider.getImage((File)object), 103, null);
                }
            }
            if (!(object instanceof IResource) || !AbstractFileLocationCompletionProvider.matchesIgnoreCase(resolver.getFilterPart(), ((IResource)object).getName()) || !this.showCandidate(object)) continue;
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromImage((Image)this.fLabelProvider.getImage(object));
            if (object instanceof IProject) {
                this.addProposal(((IProject)object).getName(), String.valueOf(resolver.getParentString()) + ((IProject)object).getName() + '/', imageDescriptor, 101, null);
                continue;
            }
            if (object instanceof IContainer) {
                this.addProposal(((IContainer)object).getName(), String.valueOf(resolver.getParentString()) + ((IContainer)object).getName() + '/', imageDescriptor, 102, null);
                continue;
            }
            this.addProposal(((IResource)object).getName(), String.valueOf(resolver.getParentString()) + ((IResource)object).getName(), imageDescriptor, 103, null);
        }
        if (AbstractFileLocationCompletionProvider.matches(resolver.getFilterPart(), "..") && this.showCandidate("..")) {
            Object object = resolver.getResolvedFolder();
            if (object instanceof IResource && !(object instanceof IProject) && !(object instanceof IWorkspaceRoot)) {
                this.addProposal("..", String.valueOf(resolver.getParentString()) + "../", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"), 102, null);
            } else if (object instanceof File && !AbstractFileLocationCompletionProvider.isRootFile((File)object)) {
                this.addProposal("..", String.valueOf(resolver.getParentString()) + "../", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"), 102, null);
            }
        }
    }

    private static boolean isRootFile(File file) {
        Path filePath = file.toPath().normalize();
        File[] fileArray = File.listRoots();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File rootFile = fileArray[n2];
            if (rootFile.toPath().equals(filePath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static ImageDescriptor getImage(File file) {
        if (AbstractFileLocationCompletionProvider.isRootFile(file)) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
        }
        if (file.isFile()) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE");
        }
        if (file.isDirectory()) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
        }
        return null;
    }

    protected boolean showCandidate(Object candidate) {
        return !(candidate instanceof IProject) || ((IProject)candidate).isOpen();
    }

    protected static boolean hasFileExtension(Object candidate, String extension) {
        if (candidate instanceof File) {
            return ((File)candidate).getName().toLowerCase().endsWith("." + extension.toLowerCase());
        }
        if (candidate instanceof IFile) {
            return ((IFile)candidate).getFileExtension().equalsIgnoreCase(extension);
        }
        return false;
    }

    protected static boolean isFileSystemResource(Object candidate) {
        return "file:///".equals(candidate) || candidate instanceof File;
    }

    protected static boolean isWorkspaceResource(Object candidate) {
        return "workspace:///".equals(candidate) || "project:///".equals(candidate) || candidate instanceof IResource;
    }

    protected static boolean isFile(Object candidate) {
        return candidate instanceof File && ((File)candidate).isFile() || candidate instanceof IFile;
    }

    protected static boolean isFolder(Object candidate) {
        return candidate instanceof File && ((File)candidate).isDirectory() || candidate instanceof IContainer;
    }
}

