/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.definition;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Flag implements Enumerator
{
    UNDEFINED(0, "UNDEFINED", "UNDEFINED"),
    THREAD_COUNT(1, "THREAD_COUNT", "THREAD_COUNT"),
    PROMOTE_FAILURE_TO_ERROR(2, "PROMOTE_FAILURE_TO_ERROR", "PROMOTE_FAILURE_TO_ERROR"),
    STOP_SUITE_ON_ERROR(3, "STOP_SUITE_ON_ERROR", "STOP_SUITE_ON_ERROR"),
    RUN_TEARDOWN_ON_ERROR(4, "RUN_TEARDOWN_ON_ERROR", "RUN_TEARDOWN_ON_ERROR"),
    PREFERRED_ENGINE_ID(5, "PREFERRED_ENGINE_ID", "PREFERRED_ENGINE_ID");

    public static final int UNDEFINED_VALUE = 0;
    public static final int THREAD_COUNT_VALUE = 1;
    public static final int PROMOTE_FAILURE_TO_ERROR_VALUE = 2;
    public static final int STOP_SUITE_ON_ERROR_VALUE = 3;
    public static final int RUN_TEARDOWN_ON_ERROR_VALUE = 4;
    public static final int PREFERRED_ENGINE_ID_VALUE = 5;
    private static final Flag[] VALUES_ARRAY;
    public static final List<Flag> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Flag[]{UNDEFINED, THREAD_COUNT, PROMOTE_FAILURE_TO_ERROR, STOP_SUITE_ON_ERROR, RUN_TEARDOWN_ON_ERROR, PREFERRED_ENGINE_ID};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Flag get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Flag result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Flag getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Flag result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Flag get(int value) {
        switch (value) {
            case 0: {
                return UNDEFINED;
            }
            case 1: {
                return THREAD_COUNT;
            }
            case 2: {
                return PROMOTE_FAILURE_TO_ERROR;
            }
            case 3: {
                return STOP_SUITE_ON_ERROR;
            }
            case 4: {
                return RUN_TEARDOWN_ON_ERROR;
            }
            case 5: {
                return PREFERRED_ENGINE_ID;
            }
        }
        return null;
    }

    private Flag(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

