/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ease.ICodeParser;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.sign.ScriptSignatureException;
import org.eclipse.ease.sign.SignatureInfo;

public abstract class AbstractCodeParser
implements ICodeParser {
    public static final Pattern PARAMETER_PATTERN = Pattern.compile("[^\\p{Alnum}-_]*?\\s*([\\p{Alnum}-_]+)\\s*:(.*)");

    public static Map<String, String> extractKeywords(String comment) {
        HashMap<String, String> keywords = new HashMap<String, String>();
        String key = null;
        String[] stringArray = comment.split("\\r?\\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Matcher matcher = PARAMETER_PATTERN.matcher(line);
            if (matcher.matches()) {
                key = matcher.group(1);
                keywords.put(key, matcher.group(2).trim());
            } else if (key != null) {
                if (!line.trim().isEmpty()) {
                    if (!Pattern.matches("[" + (line = line.trim()).charAt(0) + "]+", line)) {
                        keywords.put(key, String.valueOf((String)keywords.get(key)) + " " + line.trim());
                    } else {
                        key = null;
                    }
                } else {
                    key = null;
                }
            }
            ++n2;
        }
        return keywords;
    }

    @Override
    public String getHeaderComment(InputStream stream) {
        StringBuilder comment = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        boolean isComment = true;
        boolean isBlock = false;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                if (isBlock) {
                    if (line.contains(this.getBlockCommentEndToken())) {
                        isBlock = false;
                        line = line.substring(0, line.indexOf(this.getBlockCommentEndToken()));
                    }
                    comment.append(this.stripCommentLine(line.trim())).append('\n');
                } else if (this.hasBlockComment() && line.startsWith(this.getBlockCommentStartToken())) {
                    isBlock = true;
                    line = line.substring(this.getBlockCommentStartToken().length()).trim();
                    comment.append(this.stripCommentLine(line)).append('\n');
                } else if (line.startsWith(this.getLineCommentToken())) {
                    comment.append(this.stripCommentLine(line.substring(this.getLineCommentToken().length()).trim())).append('\n');
                } else if (!line.isEmpty() && !this.isAcceptedBeforeHeader(line)) {
                    isComment = false;
                }
                if (isComment) continue;
                break;
            }
        }
        catch (IOException e) {
            Logger.error("org.eclipse.ease", "Could not parse input stream header", e);
            return "";
        }
        return comment.toString();
    }

    protected String stripCommentLine(String commentLine) {
        return commentLine;
    }

    @Override
    public boolean isAcceptedBeforeHeader(String line) {
        return false;
    }

    @Override
    public ICompletionContext getContext(IScriptEngine scriptEngine, Object resource, String contents, int position, int selectionRange) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SignatureInfo getSignatureInfo(InputStream stream) throws ScriptSignatureException {
        BufferedReader bReader = new BufferedReader(new InputStreamReader(stream));
        try {
            StringBuffer certBuf;
            StringBuffer signBuf;
            String provider;
            String messageDigestAlgo;
            StringBuffer contentOnlyBuffer;
            StringBuffer contentBuffer = new StringBuffer();
            String cur = bReader.readLine();
            if (cur == null) {
                return null;
            }
            String prev = cur;
            block18: while (true) {
                block38: {
                    if ((cur = bReader.readLine()) == null) {
                        return null;
                    }
                    do {
                        if (cur.equals("-----BEGIN SIGNATURE-----")) {
                            contentOnlyBuffer = new StringBuffer(contentBuffer);
                            if (contentOnlyBuffer.length() > 0) {
                                contentOnlyBuffer.deleteCharAt(contentOnlyBuffer.length() - 1);
                            }
                            contentBuffer.append(String.valueOf(prev) + "\n");
                            if (!prev.equals(this.getBlockCommentStartToken())) {
                                prev = cur;
                                continue block18;
                            }
                            break block38;
                        }
                        contentBuffer.append(String.valueOf(prev) + "\n");
                        prev = cur;
                    } while ((cur = bReader.readLine()) != null);
                    return null;
                }
                contentBuffer.append(String.valueOf(cur) + "\n");
                cur = bReader.readLine();
                if (cur == null) return null;
                if (!cur.equals("hash:")) {
                    prev = cur;
                    continue;
                }
                contentBuffer.append(String.valueOf(cur) + "\n");
                cur = bReader.readLine();
                if (cur == null) return null;
                messageDigestAlgo = cur;
                contentBuffer.append(String.valueOf(cur) + "\n");
                cur = bReader.readLine();
                if (cur == null) return null;
                if (!cur.isEmpty()) {
                    prev = cur;
                    continue;
                }
                contentBuffer.append(String.valueOf(cur) + "\n");
                cur = bReader.readLine();
                if (cur == null) return null;
                if (!cur.equals("provider:")) {
                    prev = cur;
                    continue;
                }
                contentBuffer.append(String.valueOf(cur) + "\n");
                cur = bReader.readLine();
                if (cur == null) return null;
                provider = cur;
                contentBuffer.append(String.valueOf(cur) + "\n");
                cur = bReader.readLine();
                if (cur == null) return null;
                if (!cur.isEmpty()) {
                    prev = cur;
                    continue;
                }
                contentBuffer.append(String.valueOf(cur) + "\n");
                cur = bReader.readLine();
                if (cur == null) return null;
                if (!cur.equals("signature:")) {
                    prev = cur;
                    continue;
                }
                contentBuffer.append(String.valueOf(cur) + "\n");
                signBuf = new StringBuffer();
                while (true) {
                    if ((cur = bReader.readLine()) == null || cur.isEmpty()) {
                        if (cur != null) break;
                        return null;
                    }
                    signBuf.append(cur);
                    contentBuffer.append(String.valueOf(cur) + "\n");
                }
                contentBuffer.append(String.valueOf(cur) + "\n");
                cur = bReader.readLine();
                if (cur == null) return null;
                if (!cur.equals("certificate/s:")) {
                    prev = cur;
                    continue;
                }
                contentBuffer.append(String.valueOf(cur) + "\n");
                certBuf = new StringBuffer();
                while (true) {
                    if ((cur = bReader.readLine()) == null || cur.isEmpty()) {
                        if (cur != null) break;
                        return null;
                    }
                    certBuf.append(cur);
                    contentBuffer.append(String.valueOf(cur) + "\n");
                }
                contentBuffer.append(String.valueOf(cur) + "\n");
                cur = bReader.readLine();
                if (cur == null) return null;
                if (!cur.equals("-----END SIGNATURE-----")) {
                    prev = cur;
                    continue;
                }
                contentBuffer.append(String.valueOf(cur) + "\n");
                cur = bReader.readLine();
                if (cur == null) return null;
                if (cur.equals(this.getBlockCommentEndToken())) break;
                prev = cur;
            }
            contentBuffer.append(String.valueOf(cur) + "\n");
            cur = bReader.readLine();
            if (cur != null) {
                throw new ScriptSignatureException("Text after signature is not allowed");
            }
            String signature = signBuf.toString();
            String[] certificates = certBuf.toString().split(":");
            SignatureInfo signatureInfo = new SignatureInfo(signature, provider, messageDigestAlgo, certificates, contentOnlyBuffer.toString());
            return signatureInfo;
        }
        catch (IOException e) {
            Logger.error("org.eclipse.ease", "An IO error occurred while reading file.", e);
            throw new ScriptSignatureException("An IO error occurred while reading file.", e);
        }
        finally {
            try {
                if (bReader != null) {
                    bReader.close();
                }
            }
            catch (IOException e) {
                Logger.error("org.eclipse.ease", "File already closed.", e);
            }
        }
    }

    protected abstract boolean hasBlockComment();

    protected abstract String getBlockCommentEndToken();

    protected abstract String getBlockCommentStartToken();

    protected abstract String getLineCommentToken();
}

