/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
@Documented
public @interface ScriptParameter {
    public static final String NULL = "org.eclipse.ease.modules.ScriptParameter.null";
    public static final String UNDEFINED = "org.eclipse.ease.modules.ScriptParameter.undefined";

    public String defaultValue() default "org.eclipse.ease.modules.ScriptParameter.undefined";

    public static class Helper {
        public static boolean isOptional(ScriptParameter parameter) {
            return !parameter.defaultValue().equals(ScriptParameter.UNDEFINED);
        }
    }

    public static class OptionalParameterHelper {
        protected static String getDefaultValue(ScriptParameter in) {
            String defaultValue = in.defaultValue();
            if (defaultValue == null) {
                try {
                    Method method = ScriptParameter.class.getMethod("defaultValue", null);
                    Object defaultV = method.getDefaultValue();
                    if (defaultV instanceof String) {
                        defaultValue = (String)defaultV;
                    }
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
            return defaultValue;
        }

        public static Object getDefaultValue(ScriptParameter in, Class<?> type) {
            String defaultValue = OptionalParameterHelper.getDefaultValue(in);
            if (defaultValue == null || ScriptParameter.UNDEFINED.equals(defaultValue)) {
                return null;
            }
            if (Integer.class.isAssignableFrom(type)) {
                return Integer.getInteger(defaultValue);
            }
            if (String.class.isAssignableFrom(type)) {
                return defaultValue;
            }
            if (Boolean.class.isAssignableFrom(type)) {
                return Boolean.getBoolean(defaultValue);
            }
            return null;
        }
    }
}

