/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.svn;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.modules.platform.UIModule;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.remote.CheckoutOperation;
import org.eclipse.team.svn.core.operation.remote.LocateProjectsOperation;
import org.eclipse.team.svn.core.operation.remote.management.AddRepositoryLocationOperation;
import org.eclipse.team.svn.core.operation.remote.management.SaveRepositoryLocationsOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.extension.ExtensionsManager;
import org.eclipse.team.svn.ui.utility.ICancellableOperationWrapper;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class SVNModule
extends AbstractScriptModule {
    @WrapToScript
    public IRepositoryLocation createRepositoryLocation(String rootUrl, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String username, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String password) {
        IRepositoryLocation location;
        IRepositoryLocation[] iRepositoryLocationArray = SVNRemoteStorage.instance().getRepositoryLocations();
        int n = iRepositoryLocationArray.length;
        int n2 = 0;
        while (n2 < n) {
            location = iRepositoryLocationArray[n2];
            if (location.getUrlAsIs().equals(rootUrl) || location.getUrl().equals(rootUrl)) {
                return location;
            }
            ++n2;
        }
        location = SVNRemoteStorage.instance().newRepositoryLocation();
        location.setUrl(rootUrl);
        location.setTrunkLocation("trunk");
        location.setTagsLocation("tags");
        location.setBranchesLocation("branches");
        location.setStructureEnabled(true);
        if (username != null) {
            location.setUsername(username);
        }
        if (password != null) {
            location.setPassword(password);
        }
        location.setPasswordSaved(true);
        AddRepositoryLocationOperation operation = new AddRepositoryLocationOperation(location);
        CompositeOperation compositeOperation = new CompositeOperation(operation.getId(), operation.getMessagesClass());
        compositeOperation.add((IActionOperation)operation);
        compositeOperation.add((IActionOperation)new SaveRepositoryLocationsOperation());
        this.executeOperation((IActionOperation)compositeOperation);
        return location;
    }

    @WrapToScript
    public void importProjectsFromSVN(Object rootLocation, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String[] projectLocations) {
        IRepositoryLocation repoLocation = this.getRepositoryLocation(rootLocation);
        IRepositoryResource[] checkoutResources = projectLocations != null ? this.getCheckoutResourcesFromList(repoLocation, projectLocations) : this.getCheckoutResourcesFromRoot(repoLocation);
        this.checkoutResources(checkoutResources);
    }

    private IRepositoryLocation getRepositoryLocation(Object rootLocation) {
        if (rootLocation instanceof IRepositoryLocation) {
            return (IRepositoryLocation)rootLocation;
        }
        return this.createRepositoryLocation(rootLocation.toString(), null, null);
    }

    private IRepositoryResource[] getCheckoutResourcesFromList(IRepositoryLocation repoLocation, String[] projectLocations) {
        ArrayList<IRepositoryResource> checkoutList = new ArrayList<IRepositoryResource>();
        String[] stringArray = projectLocations;
        int n = projectLocations.length;
        int n2 = 0;
        while (n2 < n) {
            String location = stringArray[n2];
            IRepositoryResource projectResource = SVNRemoteStorage.instance().asRepositoryResource(repoLocation, String.valueOf(repoLocation.getUrl()) + "/" + location, false);
            checkoutList.add(projectResource);
            ++n2;
        }
        return checkoutList.toArray(new IRepositoryResource[checkoutList.size()]);
    }

    private IRepositoryResource[] getCheckoutResourcesFromRoot(IRepositoryLocation repoLocation) {
        IRepositoryResource res = SVNRemoteStorage.instance().asRepositoryResource(repoLocation, repoLocation.getUrl(), false);
        IRepositoryResource[] doCeckout = new IRepositoryResource[]{res};
        LocateProjectsOperation locateProjectsOp = new LocateProjectsOperation(doCeckout, ExtensionsManager.getInstance().getCurrentCheckoutFactory().getLocateFilter(), 5);
        this.executeOperation((IActionOperation)locateProjectsOp);
        return locateProjectsOp.getRepositoryResources();
    }

    private void checkoutResources(IRepositoryResource[] checkoutResources) {
        if (UIModule.isHeadless()) {
            HashMap<String, IRepositoryResource> operateMap = new HashMap<String, IRepositoryResource>();
            IRepositoryResource[] iRepositoryResourceArray = checkoutResources;
            int n = checkoutResources.length;
            int n2 = 0;
            while (n2 < n) {
                IRepositoryResource resource = iRepositoryResourceArray[n2];
                operateMap.put(resource.getName(), resource);
                ++n2;
            }
            CheckoutOperation operation = new CheckoutOperation(operateMap, true, null, SVNDepth.INFINITY, false);
            this.executeOperation((IActionOperation)operation);
        } else {
            Display.getDefault().syncExec(() -> {
                IActionOperation operation = ExtensionsManager.getInstance().getCurrentCheckoutFactory().getCheckoutOperation(Display.getDefault().getActiveShell(), checkoutResources, null, true, null, SVNDepth.INFINITY, false);
                UIMonitorUtility.doTaskNowDefault((IActionOperation)operation, (boolean)false);
            });
        }
    }

    @WrapToScript
    public long getRevision(Object resource) {
        Object file = ResourceTools.resolve((Object)resource, (Object)this.getScriptEngine().getExecutedFile());
        if (file instanceof IResource) {
            ILocalResource localResource = SVNRemoteStorage.instance().asLocalResource((IResource)file);
            return localResource.getRevision();
        }
        return -1L;
    }

    private void executeOperation(IActionOperation operation) {
        if (UIModule.isHeadless()) {
            operation.run((IProgressMonitor)new NullProgressMonitor());
        } else {
            Display.getDefault().syncExec(() -> {
                ICancellableOperationWrapper iCancellableOperationWrapper = UIMonitorUtility.doTaskNowDefault((IActionOperation)operation, (boolean)false);
            });
        }
    }
}

