/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.reporters;

import java.text.SimpleDateFormat;
import org.eclipse.ease.lang.unittest.definition.IVariable;
import org.eclipse.ease.lang.unittest.reporters.IReportGenerator;
import org.eclipse.ease.lang.unittest.runtime.IMetadata;
import org.eclipse.ease.lang.unittest.runtime.ITest;
import org.eclipse.ease.lang.unittest.runtime.ITestContainer;
import org.eclipse.ease.lang.unittest.runtime.ITestEntity;
import org.eclipse.ease.lang.unittest.runtime.ITestResult;
import org.eclipse.ease.lang.unittest.runtime.ITestSuite;
import org.eclipse.ease.lang.unittest.runtime.TestStatus;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public final class JUnitReportGenerator
implements IReportGenerator {
    private static int countTests(ITestEntity testEntity, ITestCounter counter) {
        if (testEntity instanceof ITest) {
            return counter.getCount(testEntity);
        }
        if (testEntity instanceof ITestContainer) {
            int tests = 0;
            if (((ITestContainer)testEntity).getChildren().isEmpty()) {
                return counter.getCount(testEntity);
            }
            for (ITestEntity child : ((ITestContainer)testEntity).getChildren()) {
                tests += JUnitReportGenerator.countTests(child, counter);
            }
            return tests;
        }
        return 0;
    }

    private static String escape(String variable) {
        return variable.replace("<", "&lt;").replace(">", "&gt;");
    }

    private static String getClassName(ITestEntity testEntity) {
        if (testEntity.getParent() != null && testEntity.getParent().getParent() != null) {
            return String.valueOf(JUnitReportGenerator.getClassName(testEntity.getParent())) + "." + testEntity.getName().replaceAll("\\s", "_").replaceAll("\\.", "_");
        }
        return testEntity.getName().replaceAll("\\s", "_").replaceAll("\\.", "_");
    }

    @Override
    public String createReport(String title, String description, ITestEntity testEntity) {
        IMemento propertyNode;
        SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        XMLMemento suiteNode = XMLMemento.createWriteRoot((String)"testsuite");
        suiteNode.putString("name", title);
        suiteNode.putString("hostname", "localhost");
        suiteNode.putInteger("tests", JUnitReportGenerator.countTests(testEntity, test -> 1));
        suiteNode.putInteger("failures", JUnitReportGenerator.countTests(testEntity, test -> test.getResults(TestStatus.FAILURE).size()));
        suiteNode.putInteger("errors", JUnitReportGenerator.countTests(testEntity, test -> test.getResults(TestStatus.ERROR).size()));
        suiteNode.putInteger("disabled", JUnitReportGenerator.countTests(testEntity, test -> TestStatus.DISABLED.equals((Object)test.getStatus()) ? 1 : 0));
        suiteNode.putFloat("time", (float)((double)testEntity.getDuration() / 1000.0));
        suiteNode.putString("timestamp", timeFormat.format(testEntity.getStartTimestamp()));
        suiteNode.putInteger("id", 0);
        IMemento propertiesNode = suiteNode.createChild("properties");
        for (IMetadata metadata : testEntity.getMetadata()) {
            propertyNode = propertiesNode.createChild("property");
            propertyNode.putString("name", JUnitReportGenerator.escape(metadata.getKey()));
            propertyNode.putString("value", JUnitReportGenerator.escape(metadata.getValue() != null ? metadata.getValue().toString() : "null"));
        }
        if (testEntity instanceof ITestSuite && ((ITestSuite)testEntity).getDefinition() != null) {
            for (IVariable variable : ((ITestSuite)testEntity).getDefinition().getVariables()) {
                propertyNode = propertiesNode.createChild("property");
                propertyNode.putString("name", JUnitReportGenerator.escape(variable.getName()));
                propertyNode.putTextData(JUnitReportGenerator.escape(variable.getContent()));
            }
        }
        this.addTestResults((IMemento)suiteNode, testEntity);
        return suiteNode.toString();
    }

    private void addTestResults(IMemento suiteNode, ITestEntity testEntity) {
        if (testEntity instanceof ITestContainer) {
            for (ITestEntity child : ((ITestContainer)testEntity).getChildren()) {
                this.addTestResults(suiteNode, child);
            }
        }
        if (!(testEntity instanceof ITestContainer) || !testEntity.getResults().isEmpty()) {
            IMemento testcaseNode = suiteNode.createChild("testcase");
            testcaseNode.putString("name", JUnitReportGenerator.escape(testEntity.getName()));
            testcaseNode.putString("classname", JUnitReportGenerator.escape(JUnitReportGenerator.getClassName(testEntity.getParent())));
            testcaseNode.putFloat("time", (float)((double)testEntity.getDuration() / 1000.0));
            if (TestStatus.DISABLED.equals((Object)testEntity.getStatus())) {
                IMemento skippedNode = testcaseNode.createChild("skipped");
                skippedNode.putString("message", JUnitReportGenerator.escape(((ITestResult)testEntity.getResults(TestStatus.DISABLED).get(0)).getMessage()));
            } else {
                for (ITestResult testResult : testEntity.getResults()) {
                    if (testResult.getStatus() == TestStatus.FAILURE) {
                        IMemento failureNode = testcaseNode.createChild("failure");
                        failureNode.putString("message", JUnitReportGenerator.escape(testResult.getMessage()));
                        failureNode.putString("type", "verification mismatch");
                        continue;
                    }
                    if (testResult.getStatus() != TestStatus.ERROR) continue;
                    IMemento errorNode = testcaseNode.createChild("error");
                    errorNode.putString("message", JUnitReportGenerator.escape(testResult.getMessage()));
                    errorNode.putString("type", "script aborted");
                }
            }
        }
    }

    @Override
    public String getDefaultExtension() {
        return "xml";
    }

    private static interface ITestCounter {
        public int getCount(ITestEntity var1);
    }
}

