/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.fx.internal.projects;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.layout.VBoxBuilder;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.fx.emf.edit.ui.AdapterFactoryTreeCellFactory;
import org.eclipse.fx.emf.edit.ui.AdapterFactoryTreeItem;

public class CreateEObjectStage
extends Stage {
    private EClass selectedEClass;
    private ComposedAdapterFactory adapterFactory;

    public CreateEObjectStage() {
        this.initModality(Modality.WINDOW_MODAL);
        this.setTitle("Select EClass");
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        final TreeView treeView = new TreeView();
        treeView.setMaxHeight(Double.MAX_VALUE);
        treeView.setMaxWidth(Double.MAX_VALUE);
        TreeItem<Object> root = this.getRegistryTreeItem((TreeView<Object>)treeView);
        treeView.setRoot(root);
        treeView.setShowRoot(false);
        AdapterFactoryTreeCellFactory cellFactory = new AdapterFactoryTreeCellFactory((AdapterFactory)this.adapterFactory);
        treeView.setCellFactory((Callback)cellFactory);
        final Button button = new Button("Create");
        button.setMaxWidth(Double.MAX_VALUE);
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Object value = ((TreeItem)treeView.getSelectionModel().getSelectedItem()).getValue();
                if (EClass.class.isInstance(value)) {
                    CreateEObjectStage.this.selectedEClass = (EClass)value;
                    CreateEObjectStage.this.close();
                }
            }
        });
        button.setDisable(true);
        treeView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<TreeItem<Object>>(){

            public void changed(ObservableValue<? extends TreeItem<Object>> observable, TreeItem<Object> oldValue, TreeItem<Object> newValue) {
                if (newValue == null) {
                    return;
                }
                Object value = newValue.getValue();
                if (!EClass.class.isInstance(value)) {
                    button.setDisable(true);
                    return;
                }
                EClass eClass = (EClass)value;
                button.setDisable(eClass.isAbstract() || eClass.isInterface());
            }
        });
        this.setScene(new Scene((Parent)((VBoxBuilder)VBoxBuilder.create().children(new Node[]{treeView, button})).build()));
        VBox.setVgrow((Node)treeView, (Priority)Priority.ALWAYS);
    }

    private TreeItem<Object> getRegistryTreeItem(TreeView<Object> treeView) {
        TreeItemExtension result = new TreeItemExtension(treeView);
        return result;
    }

    public void close() {
        this.adapterFactory.dispose();
        super.close();
    }

    public EObject getResult() {
        if (this.selectedEClass == null) {
            return null;
        }
        return EcoreUtil.create((EClass)this.selectedEClass);
    }

    private final class TreeItemExtension
    extends TreeItem<Object> {
        private final TreeView<Object> treeView;
        private ObservableList<TreeItem<Object>> children;

        private TreeItemExtension(TreeView<Object> treeView) {
            this.treeView = treeView;
            this.children = FXCollections.unmodifiableObservableList((ObservableList)super.getChildren());
            this.updateChildren();
        }

        private void updateChildren() {
            ObservableList children = super.getChildren();
            children.clear();
            for (String nsURI : EPackage.Registry.INSTANCE.keySet()) {
                EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
                AdapterFactoryTreeItem rootItem = new AdapterFactoryTreeItem((Object)ePackage, this.treeView, (AdapterFactory)CreateEObjectStage.this.adapterFactory);
                children.add((Object)rootItem);
            }
        }

        public ObservableList<TreeItem<Object>> getChildren() {
            return this.children;
        }
    }
}

