/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.wizards;

import org.eclipse.emf.ecp.core.ECPRepository;
import org.eclipse.emf.ecp.core.util.ECPCheckoutSource;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.internal.ui.Activator;
import org.eclipse.emf.ecp.internal.ui.Messages;
import org.eclipse.emf.ecp.spi.common.ui.ECPWizard;
import org.eclipse.emf.ecp.ui.common.CheckoutProjectComposite;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CheckoutProjectWizard
extends ECPWizard<CheckoutProjectComposite> {
    public boolean performFinish() {
        return true;
    }

    public void addPages() {
        WizardPage wp = new WizardPage("Checkout"){

            public void createControl(Composite parent) {
                Composite composite = ((CheckoutProjectComposite)CheckoutProjectWizard.this.getCompositeProvider()).createUI(parent);
                ((CheckoutProjectComposite)CheckoutProjectWizard.this.getCompositeProvider()).setListener(new CheckoutProjectComposite.CheckoutProjectChangeListener(){

                    @Override
                    public void projectNameChanged(String projectName) {
                        this.validateName(projectName);
                    }
                });
                this.validateName(((CheckoutProjectComposite)CheckoutProjectWizard.this.getCompositeProvider()).getProjectName());
                this.setControl((Control)composite);
            }

            private void validateName(String projectName) {
                if (ECPUtil.getECPProjectManager().getProject(projectName) != null) {
                    this.setPageComplete(false);
                    this.setErrorMessage("A project with name " + projectName + " already exists in the workspace.");
                } else {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                }
            }
        };
        this.addPage((IWizardPage)wp);
        wp.setTitle(Messages.CheckoutProjectWizard_PageTitle_CheckoutProject);
        wp.setImageDescriptor(Activator.getImageDescriptor("icons/checkout_project_wiz.png"));
        ECPCheckoutSource checkoutSource = ((CheckoutProjectComposite)this.getCompositeProvider()).getCheckoutSource();
        ECPRepository repository = checkoutSource.getRepository();
        if (checkoutSource == repository) {
            wp.setMessage(String.valueOf(Messages.CheckoutProjectWizard_PageMessage_CheckoutRepositrory) + repository.getLabel() + ".");
        } else {
            wp.setMessage(String.valueOf(Messages.CheckoutProjectWizard_PageMessage_CheckoutProject) + ((CheckoutProjectComposite)this.getCompositeProvider()).getUiProvider().getText(checkoutSource) + Messages.CheckoutProjectWizard_PageMessage_CheckoutFrom + repository.getLabel() + ".");
        }
        this.setWindowTitle(Messages.CheckoutProjectWizard_Title_Checkout);
    }
}

