/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments.index;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.internal.EMFValueProperty;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class EMFIndexedValueProperty
extends EMFValueProperty {
    private final int index;
    private final EditingDomain editingDomain;

    public EMFIndexedValueProperty(EditingDomain editingDomain, int index, EStructuralFeature eStructuralFeature) {
        super(eStructuralFeature);
        this.editingDomain = editingDomain;
        if (index < 0) {
            throw new IllegalArgumentException("\t \t \t \t \t Who thinks it's a good idea to use a negative list index?!");
        }
        this.index = index;
    }

    protected Object doGetValue(Object source) {
        Object result = super.doGetValue(source);
        EList list = (EList)result;
        if (list == null || this.index >= list.size()) {
            return null;
        }
        return list.get(this.index);
    }

    protected void doSetValue(Object source, Object value) {
        EObject eObject = (EObject)source;
        Object result = super.doGetValue(source);
        EList list = (EList)result;
        Command command = this.index == list.size() ? AddCommand.create((EditingDomain)this.editingDomain, (Object)eObject, (Object)this.getFeature(), (Object)value, (int)this.index) : SetCommand.create((EditingDomain)this.editingDomain, (Object)eObject, (Object)this.getFeature(), (Object)value, (int)this.index);
        this.editingDomain.getCommandStack().execute(command);
    }

    public String toString() {
        String s = super.toString();
        s = String.valueOf(s) + " index " + this.index;
        return s;
    }
}

