/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.handler;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.ui.view.swt.reference.CreateNewModelElementStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.ReferenceServiceCustomizationVendor;
import org.eclipse.emf.ecp.view.internal.editor.handler.CreateSegmentDmrWizard;
import org.eclipse.emf.ecp.view.spi.editor.controls.EStructuralFeatureSelectionValidator;
import org.eclipse.emf.ecp.view.spi.editor.controls.Helper;
import org.eclipse.emf.ecp.view.spi.editor.controls.ToolingModeUtil;
import org.eclipse.emf.ecp.view.spi.rule.model.LeafCondition;
import org.eclipse.emf.ecp.view.spi.rule.model.RulePackage;
import org.eclipse.emfforms.bazaar.Create;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="LeafConditionDmrNewModelElementStrategyProvider", property={"service.ranking:Integer=50"})
public class LeafConditionDmrNewModelElementStrategyProvider
extends ReferenceServiceCustomizationVendor<CreateNewModelElementStrategy>
implements CreateNewModelElementStrategy.Provider {
    private ReportService reportService;

    protected boolean handles(EObject owner, EReference reference) {
        return this.isSegmentToolingEnabled() && owner instanceof LeafCondition && reference == RulePackage.Literals.LEAF_CONDITION__DOMAIN_MODEL_REFERENCE;
    }

    boolean isSegmentToolingEnabled() {
        return ToolingModeUtil.isSegmentToolingEnabled();
    }

    @Reference(unbind="-")
    void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Create
    public CreateNewModelElementStrategy createCreateNewModelElementStrategy() {
        return new Strategy();
    }

    class Strategy
    implements CreateNewModelElementStrategy {
        Strategy() {
        }

        public Optional<EObject> createNewModelElement(EObject owner, EReference reference) {
            EClass rootEClass = Helper.getRootEClass(owner);
            if (rootEClass == null) {
                String message = MessageFormat.format("Could not create a new domain model reference for leaf condition ''{0}'' because the VView containing it has no root EClass.", owner);
                LeafConditionDmrNewModelElementStrategyProvider.this.reportService.report(new AbstractReport(message, 2));
                return Optional.empty();
            }
            EStructuralFeatureSelectionValidator validator = feature -> feature instanceof EAttribute ? null : "A leaf condition's domain model reference must point to an attribute.";
            CreateSegmentDmrWizard dmrWizard = new CreateSegmentDmrWizard(rootEClass, "New Domain Model Reference", null, validator);
            WizardDialog wizardDialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)dmrWizard);
            wizardDialog.setBlockOnOpen(true);
            wizardDialog.open();
            return Optional.fromJavaOptional(dmrWizard.getDomainModelReference().map(EObject.class::cast));
        }
    }
}

