/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.bazaar.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.emfforms.bazaar.Bazaar;
import org.eclipse.emfforms.bazaar.BazaarContext;
import org.eclipse.emfforms.bazaar.BazaarContextFunction;
import org.eclipse.emfforms.bazaar.Bid;
import org.eclipse.emfforms.bazaar.Create;
import org.eclipse.emfforms.bazaar.Exchange;
import org.eclipse.emfforms.bazaar.Precondition;
import org.eclipse.emfforms.bazaar.Preconditions;
import org.eclipse.emfforms.bazaar.StaticBid;
import org.eclipse.emfforms.bazaar.Vendor;

public class BazaarImpl<T>
implements Bazaar<T> {
    private final Set<Vendor<? extends T>> vendors = new LinkedHashSet<Vendor<? extends T>>();
    private Bazaar.PriorityOverlapCallBack<? super T> priorityOverlapCallBack;
    private final Map<String, BazaarContextFunction> contextFunctionMap = new HashMap<String, BazaarContextFunction>();

    @Override
    public void addVendor(Vendor<? extends T> vendor) {
        this.vendors.add(vendor);
    }

    @Override
    public void removeVendor(Vendor<? extends T> vendor) {
        this.vendors.remove(vendor);
    }

    public T createProduct(Vendor<? extends T> vendor, IEclipseContext context) {
        try {
            return (T)ContextInjectionFactory.invoke(vendor, Create.class, (IEclipseContext)context);
        }
        catch (InjectionException e) {
            return null;
        }
    }

    public IEclipseContext addContextFunctions(IEclipseContext context) {
        Set<Map.Entry<String, BazaarContextFunction>> entrySet = this.contextFunctionMap.entrySet();
        for (final Map.Entry<String, BazaarContextFunction> entry : entrySet) {
            IContextFunction iContextFunction = new IContextFunction(){

                public Object compute(IEclipseContext context, String contextKey) {
                    try {
                        Object transformed = ContextInjectionFactory.invoke(entry.getValue(), Exchange.class, (IEclipseContext)context);
                        if (transformed != null) {
                            context.set((String)entry.getKey(), transformed);
                        }
                        return transformed;
                    }
                    catch (InjectionException e) {
                        return null;
                    }
                }
            };
            context.set(entry.getKey(), (Object)iContextFunction);
        }
        return context;
    }

    public IEclipseContext createEclipseContext(BazaarContext bazaarContext) {
        IEclipseContext context = EclipseContextFactory.create();
        Set<String> keySet = bazaarContext.getContextMap().keySet();
        for (String string : keySet) {
            context.set(string, bazaarContext.getContextMap().get(string));
        }
        return context;
    }

    public Vendor<? extends T> getBestVendor(IEclipseContext context) {
        Double winningBid = null;
        Vendor<? extends T> winner = null;
        for (Vendor<? extends T> vendor : this.vendors) {
            Double bid = this.bid(vendor, context);
            if (bid == null) continue;
            if (winningBid == null || bid > winningBid) {
                winningBid = bid;
                winner = vendor;
                continue;
            }
            if (!bid.equals(winningBid)) continue;
            this.reportPriorityOverlap(winner, vendor);
        }
        return winner;
    }

    private Double bid(Vendor<? extends T> vendor, IEclipseContext context) {
        if (!this.checkPreConditions(vendor, context)) {
            return null;
        }
        Double result = null;
        result = this.staticBid(vendor);
        if (result != null) {
            return result;
        }
        try {
            result = (Double)ContextInjectionFactory.invoke(vendor, Bid.class, (IEclipseContext)context);
        }
        catch (InjectionException injectionException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return result;
    }

    private Double staticBid(Vendor<? extends T> vendor) {
        StaticBid staticBid = vendor.getClass().getAnnotation(StaticBid.class);
        if (staticBid != null) {
            return staticBid.bid();
        }
        return null;
    }

    private Queue<Vendor<? extends T>> createVendorPriorityQueue(IEclipseContext context) {
        final HashMap<Vendor<? extends T>, Double> priorities = new HashMap<Vendor<? extends T>, Double>();
        for (Vendor<? extends T> vendor : this.vendors) {
            Double bid = this.bid(vendor, context);
            if (bid == null) continue;
            priorities.put(vendor, bid);
        }
        if (priorities.isEmpty()) {
            return new PriorityQueue<Vendor<? extends T>>();
        }
        Comparator comparator = new Comparator<Vendor<? extends T>>(){

            @Override
            public int compare(Vendor<? extends T> o1, Vendor<? extends T> o2) {
                return ((Double)priorities.get(o2)).compareTo((Double)priorities.get(o1));
            }
        };
        PriorityQueue<Vendor<T>> result = new PriorityQueue<Vendor<T>>(priorities.size(), comparator);
        result.addAll(priorities.keySet());
        return result;
    }

    private void reportPriorityOverlap(Vendor<? extends T> existingVendorWithSamePriority, Vendor<? extends T> vendor) {
        if (this.priorityOverlapCallBack == null) {
            return;
        }
        this.priorityOverlapCallBack.priorityOverlap(existingVendorWithSamePriority, vendor);
    }

    @Override
    public void setPriorityOverlapCallBack(Bazaar.PriorityOverlapCallBack<? super T> priorityOverlapCallBack) {
        this.priorityOverlapCallBack = priorityOverlapCallBack;
    }

    @Override
    public void addContextFunction(String key, BazaarContextFunction contextFunction) {
        this.contextFunctionMap.put(key, contextFunction);
    }

    @Override
    public T createProduct(BazaarContext bazaarContext) {
        IEclipseContext eclipseContext = this.createEclipseContextWithFunctions(bazaarContext);
        Vendor<T> bestVendor = this.getBestVendor(eclipseContext);
        if (bestVendor == null) {
            return null;
        }
        T createProduct = this.createProduct(bestVendor, eclipseContext);
        return createProduct;
    }

    private IEclipseContext createEclipseContextWithFunctions(BazaarContext bazaarContext) {
        IEclipseContext eclipseContext = this.createEclipseContext(bazaarContext);
        eclipseContext = this.addContextFunctions(eclipseContext);
        return eclipseContext;
    }

    @Override
    public List<T> createProducts(BazaarContext bazaarContext) {
        IEclipseContext eclipseContext = this.createEclipseContextWithFunctions(bazaarContext);
        Queue<Vendor<T>> vendorQueue = this.createVendorPriorityQueue(eclipseContext);
        if (vendorQueue.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> ret = new ArrayList<T>();
        Vendor<T> vendor = vendorQueue.poll();
        while (vendor != null) {
            T createProduct = this.createProduct(vendor, eclipseContext);
            if (createProduct != null) {
                ret.add(createProduct);
            }
            vendor = vendorQueue.poll();
        }
        return ret;
    }

    public boolean checkPreConditions(Vendor<? extends T> vendor, IEclipseContext context) {
        Preconditions conditions;
        LinkedHashSet<Precondition> preConditionList = new LinkedHashSet<Precondition>();
        Precondition preConditionAnnotation = vendor.getClass().getAnnotation(Precondition.class);
        if (preConditionAnnotation != null) {
            preConditionList.add(preConditionAnnotation);
        }
        if ((conditions = vendor.getClass().getAnnotation(Preconditions.class)) != null) {
            preConditionList.addAll(Arrays.asList(conditions.preconditions()));
        }
        for (Precondition preCondition : preConditionList) {
            if (this.checkPreCondition(preCondition, vendor, context)) continue;
            return false;
        }
        return true;
    }

    private boolean checkPreCondition(Precondition preCondition, Vendor<? extends T> vendor, IEclipseContext context) {
        if (preCondition.value().equals("[unassigned]")) {
            return context.containsKey(preCondition.key());
        }
        Object object = context.get(preCondition.key());
        if (object == null) {
            return false;
        }
        return object.equals(preCondition.value());
    }
}

