/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ecore.editor.internal;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecp.ecore.editor.IEcoreGenModelLinker;
import org.eclipse.emf.ecp.ecore.editor.util.EcoreGenException;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.ecore.EcoreImporter;

public class EcoreGenModelLinkerImpl
implements IEcoreGenModelLinker {
    private final Monitor monitor = CodeGenUtil.EclipseUtil.createMonitor((IProgressMonitor)new NullProgressMonitor(), (int)1);
    private IPath modelProjectLocationPath;
    private IPath modelFragmentPath;
    private IPath genModelPath;
    private String modelLocation;
    private final ModelImporter modelImporter = new EcoreImporter();
    private final IPath defaultSrcPath = new Path("src");

    @Override
    public void generateGenModel(String ecorePath, String genModelPathParam, String modelProjectPath) throws EcoreGenException {
        this.modelProjectLocationPath = this.getPathFromPathString(modelProjectPath);
        this.modelFragmentPath = this.defaultSrcPath;
        this.genModelPath = this.getPathFromPathString(genModelPathParam);
        this.modelLocation = ecorePath;
        this.adjustModelImporter();
        this.computeEPackages();
        this.adjustEPackages();
        this.createGenModel();
    }

    private IPath getPathFromPathString(String pathString) {
        return new Path(new File(pathString).getAbsolutePath());
    }

    private void adjustModelImporter() {
        this.modelImporter.setUsePlatformURI(false);
        this.modelImporter.setGenModelProjectLocation(this.modelProjectLocationPath);
        this.modelImporter.setModelPluginDirectory(this.modelProjectLocationPath + "/./" + this.modelFragmentPath + "/.");
        this.handleGenModelPath(this.genModelPath);
        File modelFile = new File(this.modelLocation);
        URI modelFileURI = URI.createFileURI((String)modelFile.getPath());
        this.modelImporter.setModelLocation(modelFileURI.toString());
    }

    private void handleGenModelPath(IPath genModelPath) {
        this.modelImporter.setGenModelContainerPath(genModelPath.removeLastSegments(1));
        this.modelImporter.setGenModelFileName(genModelPath.lastSegment());
    }

    private void computeEPackages() throws EcoreGenException {
        try {
            this.modelImporter.computeEPackages(this.monitor);
        }
        catch (Exception e) {
            throw new EcoreGenException("The packages could not be computed by the model importer. This might lead to unexpected results.", e);
        }
    }

    private void adjustEPackages() {
        List ePackages = this.modelImporter.getEPackages();
        this.traverseEPackages(ePackages);
        this.modelImporter.adjustEPackages(this.monitor);
    }

    private void createGenModel() throws EcoreGenException {
        this.modelImporter.prepareGenModelAndEPackages(this.monitor);
        this.adjustModelImporterAfterPrepare();
        try {
            this.modelImporter.saveGenModelAndEPackages(this.monitor);
        }
        catch (Exception e) {
            throw new EcoreGenException("Gen model and packages could not be saved!", e);
        }
    }

    private void adjustModelImporterAfterPrepare() {
        GenModel genModel = this.modelImporter.getGenModel();
        genModel.setComplianceLevel(GenJDKLevel.JDK50_LITERAL);
        genModel.setImportOrganizing(true);
        genModel.setOperationReflection(true);
    }

    private void traverseEPackages(List<EPackage> ePackages) {
        for (EPackage ePackage : ePackages) {
            this.handleQualifiedEPackageName(ePackage);
            this.traverseEPackages((List<EPackage>)ePackage.getESubpackages());
        }
    }

    private void handleQualifiedEPackageName(EPackage ePackage) {
        String packageName = ePackage.getName();
        int index = packageName.lastIndexOf(".");
        if (index != -1) {
            this.modelImporter.getEPackageImportInfo(ePackage).setBasePackage(packageName.substring(0, index));
            ePackage.setName(packageName.substring(index + 1));
        }
    }
}

