/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common.spi.asserts;

public final class Assert<T> {
    private final T object;

    private Assert(T object) {
        this.object = object;
    }

    public static <T> Assert<T> create(T object) {
        return new Assert<T>(object);
    }

    public Assert<T> notNull() {
        if (this.object == null) {
            throw new IllegalArgumentException("Object must not be null.");
        }
        return this;
    }

    public Assert<?> ofClass(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null.");
        }
        if (!clazz.isInstance(this.object)) {
            String message = String.format("%1$s is not of type %2$s.", this.object == null ? this.object : this.object.getClass().getName(), clazz.getName());
            throw new IllegalArgumentException(message);
        }
        return this;
    }

    public T check() {
        return this.object;
    }
}

