/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.context;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.view.internal.context.Activator;
import org.eclipse.emf.ecp.view.internal.context.OneShotViewModelServiceProvider;
import org.eclipse.emf.ecp.view.spi.context.EMFFormsLegacyServicesManager;
import org.eclipse.emf.ecp.view.spi.context.GlobalViewModelService;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextDisposeListener;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.context.ViewModelServiceNotAvailableReport;
import org.eclipse.emf.ecp.view.spi.context.ViewModelServiceProvider;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeAddRemoveListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.controlmapper.EMFFormsSettingToControlMapper;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDomainExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsExpandingFailedException;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsContextListener;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewContext;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewServiceManager;
import org.eclipse.emfforms.spi.core.services.view.RootDomainModelChangeListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ViewModelContextImpl
implements ViewModelContext {
    private static BundleContext bundleContext;
    private static final String MODEL_CHANGE_LISTENER_MUST_NOT_BE_NULL = "ModelChangeAddRemoveListener must not be null.";
    private static final String ROOT_DOMAIN_MODEL_CHANGE_LISTENER_MUST_NOT_BE_NULL = "RootDomainModelChangeListener must not be null.";
    private static final String THE_VIEW_MODEL_CONTEXT_WAS_ALREADY_DISPOSED = "The ViewModelContext was already disposed.";
    private final VElement view;
    private EObject domainObject;
    private final List<ModelChangeListener> viewModelChangeListener = new CopyOnWriteArrayList<ModelChangeListener>();
    private final List<ModelChangeListener> domainModelChangeListener = new CopyOnWriteArrayList<ModelChangeListener>();
    private final List<RootDomainModelChangeListener> rootDomainModelChangeListeners = new CopyOnWriteArrayList<RootDomainModelChangeListener>();
    private EContentAdapter domainModelContentAdapter;
    private EContentAdapter viewModelContentAdapter;
    private final Set<EMFFormsContextListener> contextListeners = new CopyOnWriteArraySet<EMFFormsContextListener>();
    private final SortedSet<ViewModelService> viewServices = new TreeSet<ViewModelService>(new Comparator<ViewModelService>(){

        @Override
        public int compare(ViewModelService arg0, ViewModelService arg1) {
            if (arg0.getPriority() == arg1.getPriority()) {
                return arg0.getClass().getName().compareTo(arg1.getClass().getName());
            }
            return arg0.getPriority() - arg1.getPriority();
        }
    });
    private final ViewModelServiceProvider viewServiceProvider;
    private boolean isDisposed;
    private final Map<String, Object> keyObjectMap = new LinkedHashMap<String, Object>();
    private boolean isDisposing;
    private Resource resource;
    private final Map<EObject, Set<ViewModelContext>> childContexts = new LinkedHashMap<EObject, Set<ViewModelContext>>();
    private final Map<ViewModelContext, VElement> childContextUsers = new LinkedHashMap<ViewModelContext, VElement>();
    private final ViewModelContext parentContext;
    private final Set<ViewModelContextDisposeListener> disposeListeners = new LinkedHashSet<ViewModelContextDisposeListener>();
    private final Map<Class<?>, Object> serviceMap = new LinkedHashMap();
    private final Map<ServiceReference<?>, Class<?>> usedOSGiServices = new LinkedHashMap();
    private ServiceListener serviceListener;
    private final VElement parentVElement;
    private final Set<Object> users = new LinkedHashSet<Object>();
    private EMFFormsViewServiceManager servicesManager;

    static {
        Bundle bundle = FrameworkUtil.getBundle(ViewModelContextImpl.class);
        if (bundle != null) {
            bundleContext = bundle.getBundleContext();
        }
    }

    public ViewModelContextImpl(VElement view, EObject domainObject) {
        this(view, domainObject, ViewModelServiceProvider.NULL);
    }

    public ViewModelContextImpl(VElement view, EObject domainObject, ViewModelContext parent, VElement parentVElement) {
        this(view, domainObject, parent, parentVElement, ViewModelServiceProvider.NULL);
    }

    @Deprecated
    public ViewModelContextImpl(VElement view, EObject domainObject, ViewModelService ... modelServices) {
        this(view, domainObject, new OneShotViewModelServiceProvider(modelServices));
    }

    public ViewModelContextImpl(VElement view, EObject domainObject, ViewModelServiceProvider modelServiceProvider) {
        this(view, domainObject, null, null, modelServiceProvider);
    }

    @Deprecated
    public ViewModelContextImpl(VElement view, EObject domainObject, ViewModelContext parent, VElement parentVElement, ViewModelService ... modelServices) {
        this(view, domainObject, parent, parentVElement, new OneShotViewModelServiceProvider(modelServices));
    }

    public ViewModelContextImpl(VElement view, EObject domainObject, ViewModelContext parent, VElement parentVElement, ViewModelServiceProvider modelServiceProvider) {
        this.view = view;
        this.domainObject = domainObject;
        this.parentContext = parent;
        this.viewServiceProvider = modelServiceProvider == null ? ViewModelServiceProvider.NULL : modelServiceProvider;
        this.viewServices.addAll(this.viewServiceProvider.getViewModelServices(view, domainObject));
        this.parentVElement = parentVElement;
        this.instantiate();
    }

    private void resolveDomainReferences(EObject resolvable, EObject domainModelRoot) {
        EMFFormsDomainExpander domainExpander = this.getService(EMFFormsDomainExpander.class);
        if (domainExpander == null) {
            return;
        }
        this.expandAndInitDMR(domainModelRoot, domainExpander, resolvable);
        TreeIterator eAllContents = resolvable.eAllContents();
        while (eAllContents.hasNext()) {
            EObject eObject = (EObject)eAllContents.next();
            this.expandAndInitDMR(domainModelRoot, domainExpander, eObject);
        }
    }

    private void expandAndInitDMR(EObject domainModelRoot, EMFFormsDomainExpander domainExpander, EObject eObject) {
        if (VDomainModelReference.class.isInstance(eObject) && !VDomainModelReference.class.isInstance(eObject.eContainer())) {
            VDomainModelReference domainModelReference = (VDomainModelReference)VDomainModelReference.class.cast(eObject);
            try {
                domainExpander.prepareDomainObject(domainModelReference, domainModelRoot);
            }
            catch (EMFFormsExpandingFailedException ex) {
                Activator.getInstance().getReportService().report(new AbstractReport((Throwable)ex));
            }
        }
    }

    private void instantiate() {
        this.addResourceIfNecessary();
        this.resolveDomainReferences((EObject)this.getViewModel(), this.getDomainModel());
        if (this.parentContext == null) {
            this.domainModelContentAdapter = new DomainModelContentAdapter();
            this.domainObject.eAdapters().add((Object)this.domainModelContentAdapter);
        }
        this.loadImmediateServices();
        this.viewModelContentAdapter = new ViewModelContentAdapter();
        this.view.eAdapters().add((Object)this.viewModelContentAdapter);
        for (ViewModelService viewService : this.viewServices) {
            viewService.instantiate(this);
        }
        for (EMFFormsContextListener contextListener : this.contextListeners) {
            contextListener.contextInitialised();
        }
    }

    private void loadImmediateServices() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle != null) {
            Optional service;
            BundleContext bundleContext = bundle.getBundleContext();
            ServiceReference serviceReferenceLegacy = bundleContext.getServiceReference(EMFFormsLegacyServicesManager.class);
            if (serviceReferenceLegacy != null) {
                EMFFormsLegacyServicesManager legacyServicesFactory = (EMFFormsLegacyServicesManager)bundleContext.getService(serviceReferenceLegacy);
                legacyServicesFactory.instantiate();
                bundleContext.ungetService(serviceReferenceLegacy);
            }
            this.servicesManager = this.getService(EMFFormsViewServiceManager.class);
            for (Class localImmediateService : this.servicesManager.getAllLocalImmediateServiceTypes()) {
                service = this.servicesManager.createLocalImmediateService(localImmediateService, (EMFFormsViewContext)this);
                if (!service.isPresent()) continue;
                this.serviceMap.put(localImmediateService, service.get());
            }
            if (this.parentContext == null) {
                for (Class globalImmediateService : this.servicesManager.getAllGlobalImmediateServiceTypes()) {
                    service = this.servicesManager.createGlobalImmediateService(globalImmediateService, (EMFFormsViewContext)this);
                    if (!service.isPresent()) continue;
                    Object serviceObject = service.get();
                    this.serviceMap.put(globalImmediateService, serviceObject);
                }
            }
            this.serviceListener = new ServiceListener(){

                public void serviceChanged(ServiceEvent event) {
                    if (event.getType() == 4 && ViewModelContextImpl.this.usedOSGiServices.containsKey(event.getServiceReference())) {
                        Class remove = (Class)ViewModelContextImpl.this.usedOSGiServices.remove(event.getServiceReference());
                        ViewModelContextImpl.this.serviceMap.remove(remove);
                    }
                }
            };
            bundleContext.addServiceListener(this.serviceListener);
        }
    }

    private void addResourceIfNecessary() {
        if (this.domainObject.eResource() != null) {
            return;
        }
        EObject rootObject = EcoreUtil.getRootContainer((EObject)this.domainObject);
        ResourceSetImpl rs = new ResourceSetImpl();
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)new BasicCommandStack(), (ResourceSet)rs);
        rs.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)domain));
        this.resource = rs.createResource(URI.createURI((String)"VIRTAUAL_URI"));
        if (this.resource != null) {
            this.resource.getContents().add((Object)rootObject);
        }
    }

    @Override
    @Deprecated
    public Set<VControl> getControlsFor(EStructuralFeature.Setting setting) {
        Set elements = this.getService(EMFFormsSettingToControlMapper.class).getControlsFor(UniqueSetting.createSetting((EStructuralFeature.Setting)setting));
        LinkedHashSet<VControl> controls = new LinkedHashSet<VControl>();
        for (VElement element : elements) {
            if (!VControl.class.isInstance(element)) continue;
            controls.add((VControl)element);
        }
        return controls;
    }

    @Override
    @Deprecated
    public Set<VElement> getControlsFor(UniqueSetting setting) {
        return this.getService(EMFFormsSettingToControlMapper.class).getControlsFor(setting);
    }

    @Override
    public VElement getViewModel() {
        if (this.isDisposed) {
            throw new IllegalStateException(THE_VIEW_MODEL_CONTEXT_WAS_ALREADY_DISPOSED);
        }
        return this.view;
    }

    @Override
    public EObject getDomainModel() {
        if (this.isDisposed) {
            throw new IllegalStateException(THE_VIEW_MODEL_CONTEXT_WAS_ALREADY_DISPOSED);
        }
        return this.domainObject;
    }

    @Override
    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposing = true;
        for (ViewModelContextDisposeListener listener : this.disposeListeners) {
            listener.contextDisposed(this);
        }
        this.innerDispose();
        this.viewModelChangeListener.clear();
        this.rootDomainModelChangeListeners.clear();
        this.isDisposing = false;
        this.isDisposed = true;
    }

    private void releaseOSGiServices() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle != null) {
            BundleContext bundleContext = bundle.getBundleContext();
            for (ServiceReference<?> serviceReference : this.usedOSGiServices.keySet()) {
                bundleContext.ungetService(serviceReference);
            }
        }
        this.usedOSGiServices.clear();
    }

    @Override
    public void registerViewChangeListener(ModelChangeListener modelChangeListener) {
        if (this.isDisposed) {
            throw new IllegalStateException(THE_VIEW_MODEL_CONTEXT_WAS_ALREADY_DISPOSED);
        }
        if (modelChangeListener == null) {
            throw new IllegalArgumentException(MODEL_CHANGE_LISTENER_MUST_NOT_BE_NULL);
        }
        this.viewModelChangeListener.add(modelChangeListener);
    }

    @Override
    public void unregisterViewChangeListener(ModelChangeListener modelChangeListener) {
        this.viewModelChangeListener.remove(modelChangeListener);
    }

    @Override
    public void registerDomainChangeListener(ModelChangeListener modelChangeListener) {
        if (this.isDisposed) {
            throw new IllegalStateException(THE_VIEW_MODEL_CONTEXT_WAS_ALREADY_DISPOSED);
        }
        if (modelChangeListener == null) {
            throw new IllegalArgumentException(MODEL_CHANGE_LISTENER_MUST_NOT_BE_NULL);
        }
        if (this.parentContext == null) {
            if (VDomainModelReference.class.isInstance(modelChangeListener)) {
                this.domainModelChangeListener.add(0, modelChangeListener);
            } else {
                int positionToInsert = -1;
                int i = 0;
                while (i < this.domainModelChangeListener.size()) {
                    ModelChangeListener listener = this.domainModelChangeListener.get(i);
                    if (modelChangeListener.getClass().isInstance(listener)) {
                        positionToInsert = i;
                        break;
                    }
                    ++i;
                }
                if (positionToInsert == -1) {
                    this.domainModelChangeListener.add(modelChangeListener);
                } else {
                    this.domainModelChangeListener.add(positionToInsert, modelChangeListener);
                }
            }
        } else {
            this.parentContext.registerDomainChangeListener(modelChangeListener);
        }
    }

    @Override
    public void unregisterDomainChangeListener(ModelChangeListener modelChangeListener) {
        if (this.parentContext == null) {
            this.domainModelChangeListener.remove(modelChangeListener);
        } else {
            this.parentContext.unregisterDomainChangeListener(modelChangeListener);
        }
    }

    @Override
    public <T> boolean hasService(Class<T> serviceType) {
        for (ViewModelService service : this.viewServices) {
            if (!serviceType.isInstance(service)) continue;
            return true;
        }
        if (this.parentContext != null) {
            return this.parentContext.hasService(serviceType);
        }
        return false;
    }

    @Override
    public <T> T getService(Class<T> serviceType) {
        ServiceReference serviceReference;
        Object t;
        Optional lazyService;
        for (ViewModelService service : this.viewServices) {
            if (!serviceType.isInstance(service)) continue;
            return (T)service;
        }
        if (this.serviceMap.containsKey(serviceType)) {
            return (T)this.serviceMap.get(serviceType);
        }
        if (this.servicesManager != null && (lazyService = this.servicesManager.createLocalLazyService(serviceType, (EMFFormsViewContext)this)).isPresent()) {
            t = lazyService.get();
            this.serviceMap.put(serviceType, t);
            return (T)t;
        }
        if (this.servicesManager != null && this.parentContext == null && (lazyService = this.servicesManager.createGlobalLazyService(serviceType, (EMFFormsViewContext)this)).isPresent()) {
            t = lazyService.get();
            this.serviceMap.put(serviceType, t);
            return (T)t;
        }
        if (this.parentContext != null) {
            return this.parentContext.getService(serviceType);
        }
        if (bundleContext != null && (serviceReference = bundleContext.getServiceReference(serviceType)) != null) {
            this.usedOSGiServices.put(serviceReference, serviceType);
            Object service = bundleContext.getService(serviceReference);
            this.serviceMap.put(serviceType, service);
            return (T)service;
        }
        this.report(new ViewModelServiceNotAvailableReport(serviceType));
        return null;
    }

    private void report(AbstractReport report) {
        ReportService reportService;
        Activator activator = Activator.getInstance();
        if (activator != null && (reportService = activator.getReportService()) != null) {
            reportService.report(report);
        }
    }

    @Override
    public void addContextUser(Object user) {
        this.users.add(user);
    }

    @Override
    public void removeContextUser(Object user) {
        this.users.remove(user);
        if (this.users.isEmpty()) {
            this.dispose();
        }
    }

    @Override
    public Object getContextValue(String key) {
        if (this.parentContext != null) {
            return this.parentContext.getContextValue(key);
        }
        return this.keyObjectMap.get(key);
    }

    @Override
    public void putContextValue(String key, Object value) {
        if (this.parentContext != null) {
            this.parentContext.putContextValue(key, value);
            return;
        }
        this.keyObjectMap.put(key, value);
    }

    private void addChildContext(VElement vElement, EObject eObject, ViewModelContext childContext) {
        if (!this.childContexts.containsKey(eObject)) {
            this.childContexts.put(eObject, new LinkedHashSet());
        }
        this.childContexts.get(eObject).add(childContext);
        this.childContextUsers.put(childContext, vElement);
        for (EMFFormsContextListener contextListener : this.contextListeners) {
            contextListener.childContextAdded(vElement, (EMFFormsViewContext)childContext);
        }
        for (ViewModelService viewModelService : this.viewServices) {
            if (!GlobalViewModelService.class.isInstance(viewModelService)) continue;
            ((GlobalViewModelService)GlobalViewModelService.class.cast(viewModelService)).childViewModelContextAdded(childContext);
        }
    }

    private void removeChildContext(EObject eObject) {
        Set<ViewModelContext> removedContexts = this.childContexts.remove(eObject);
        if (removedContexts != null) {
            for (ViewModelContext removedContext : removedContexts) {
                this.childContextUsers.remove(removedContext);
            }
        }
    }

    protected ViewModelServiceProvider getViewModelServiceProvider() {
        return this.viewServiceProvider;
    }

    @Override
    @Deprecated
    public ViewModelContext getChildContext(EObject eObject, VElement parent, VView vView, ViewModelService ... viewModelServices) {
        return this.getChildContext(eObject, parent, vView, new OneShotViewModelServiceProvider(viewModelServices));
    }

    @Override
    public ViewModelContext getChildContext(final EObject eObject, VElement parent, VView vView, ViewModelServiceProvider viewModelServiceProvider) {
        Set<ViewModelContext> contexts = this.childContexts.get(eObject);
        if (contexts != null) {
            for (ViewModelContext context : contexts) {
                if (!this.childContextUsers.get(context).equals(parent)) continue;
                return context;
            }
        }
        ViewModelServiceProvider serviceProvider = this.getViewModelServiceProvider();
        if (viewModelServiceProvider != null) {
            serviceProvider = new ViewModelServiceProvider.Composed(viewModelServiceProvider, serviceProvider);
        }
        final ViewModelContextImpl childContext = new ViewModelContextImpl((VElement)vView, eObject, (ViewModelContext)this, parent, serviceProvider);
        childContext.registerDisposeListener(new ViewModelContextDisposeListener(){

            @Override
            public void contextDisposed(ViewModelContext viewModelContext) {
                ViewModelContextImpl.this.removeChildContext(eObject);
                for (EMFFormsContextListener contextListener : ViewModelContextImpl.this.contextListeners) {
                    contextListener.childContextDisposed((EMFFormsViewContext)childContext);
                }
            }
        });
        this.addChildContext(parent, eObject, childContext);
        return childContext;
    }

    @Override
    public ViewModelContext getParentContext() {
        return this.parentContext;
    }

    @Override
    public VElement getParentVElement() {
        return this.parentVElement;
    }

    @Override
    public void registerDisposeListener(ViewModelContextDisposeListener listener) {
        this.disposeListeners.add(listener);
    }

    public void registerEMFFormsContextListener(EMFFormsContextListener contextListener) {
        this.contextListeners.add(contextListener);
    }

    public void unregisterEMFFormsContextListener(EMFFormsContextListener contextListener) {
        this.contextListeners.remove(contextListener);
    }

    public void changeDomainModel(EObject newDomainModel) {
        if (this.isDisposed) {
            throw new IllegalStateException(THE_VIEW_MODEL_CONTEXT_WAS_ALREADY_DISPOSED);
        }
        this.innerDispose();
        this.domainObject = newDomainModel;
        this.instantiate();
        for (RootDomainModelChangeListener listener : this.rootDomainModelChangeListeners) {
            listener.notifyChange();
        }
    }

    private void innerDispose() {
        if (this.resource != null) {
            this.resource.getContents().remove((Object)this.domainObject);
        }
        this.view.eAdapters().remove((Object)this.viewModelContentAdapter);
        this.domainObject.eAdapters().remove((Object)this.domainModelContentAdapter);
        this.domainModelChangeListener.clear();
        for (ViewModelService viewService : this.viewServices) {
            viewService.dispose();
        }
        this.viewServices.clear();
        for (EMFFormsContextListener contextListener : this.contextListeners) {
            contextListener.contextDispose();
        }
        LinkedHashSet<ViewModelContext> toDispose = new LinkedHashSet<ViewModelContext>(this.childContextUsers.keySet());
        for (ViewModelContext vmc : toDispose) {
            vmc.dispose();
        }
        this.childContextUsers.clear();
        this.childContexts.clear();
        this.releaseOSGiServices();
        this.serviceMap.clear();
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle != null) {
            BundleContext bundleContext = bundle.getBundleContext();
            bundleContext.removeServiceListener(this.serviceListener);
            this.serviceListener = null;
        }
    }

    public void registerRootDomainModelChangeListener(RootDomainModelChangeListener rootDomainModelChangeListener) {
        if (this.isDisposed) {
            throw new IllegalStateException(THE_VIEW_MODEL_CONTEXT_WAS_ALREADY_DISPOSED);
        }
        if (rootDomainModelChangeListener == null) {
            throw new IllegalArgumentException(ROOT_DOMAIN_MODEL_CHANGE_LISTENER_MUST_NOT_BE_NULL);
        }
        this.rootDomainModelChangeListeners.add(rootDomainModelChangeListener);
    }

    public void unregisterRootDomainModelChangeListener(RootDomainModelChangeListener rootDomainModelChangeListener) {
        this.rootDomainModelChangeListeners.remove(rootDomainModelChangeListener);
    }

    private class DomainModelContentAdapter
    extends EContentAdapter {
        private DomainModelContentAdapter() {
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (ViewModelContextImpl.this.isDisposing) {
                return;
            }
            ModelChangeNotification modelChangeNotification = new ModelChangeNotification(notification);
            for (ModelChangeListener modelChangeListener : ViewModelContextImpl.this.domainModelChangeListener) {
                modelChangeListener.notifyChange(modelChangeNotification);
            }
        }

        protected void addAdapter(Notifier notifier) {
            super.addAdapter(notifier);
            if (ViewModelContextImpl.this.isDisposing) {
                return;
            }
            for (ModelChangeListener modelChangeListener : ViewModelContextImpl.this.domainModelChangeListener) {
                if (!ModelChangeAddRemoveListener.class.isInstance(modelChangeListener)) continue;
                ((ModelChangeAddRemoveListener)ModelChangeAddRemoveListener.class.cast(modelChangeListener)).notifyAdd(notifier);
            }
        }

        protected void removeAdapter(Notifier notifier) {
            super.removeAdapter(notifier);
            if (ViewModelContextImpl.this.isDisposing) {
                return;
            }
            for (ModelChangeListener modelChangeListener : ViewModelContextImpl.this.domainModelChangeListener) {
                if (!ModelChangeAddRemoveListener.class.isInstance(modelChangeListener)) continue;
                ((ModelChangeAddRemoveListener)ModelChangeAddRemoveListener.class.cast(modelChangeListener)).notifyRemove(notifier);
            }
        }
    }

    private class ViewModelContentAdapter
    extends EContentAdapter {
        private ViewModelContentAdapter() {
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (ViewModelContextImpl.this.isDisposing) {
                return;
            }
            if (ViewModelContextImpl.this.isDisposed) {
                return;
            }
            if (notification.isTouch()) {
                return;
            }
            ModelChangeNotification modelChangeNotification = new ModelChangeNotification(notification);
            for (ModelChangeListener modelChangeListener : ViewModelContextImpl.this.viewModelChangeListener) {
                modelChangeListener.notifyChange(modelChangeNotification);
            }
        }

        protected void addAdapter(Notifier notifier) {
            super.addAdapter(notifier);
            if (ViewModelContextImpl.this.isDisposing || ViewModelContextImpl.this.isDisposed) {
                return;
            }
            for (ModelChangeListener modelChangeListener : ViewModelContextImpl.this.viewModelChangeListener) {
                if (!ModelChangeAddRemoveListener.class.isInstance(modelChangeListener)) continue;
                ((ModelChangeAddRemoveListener)ModelChangeAddRemoveListener.class.cast(modelChangeListener)).notifyAdd(notifier);
            }
        }

        protected void removeAdapter(Notifier notifier) {
            super.removeAdapter(notifier);
            if (ViewModelContextImpl.this.isDisposing) {
                return;
            }
            if (VElement.class.isInstance(notifier)) {
                ((VElement)VElement.class.cast(notifier)).setDiagnostic(null);
            }
            for (ModelChangeListener modelChangeListener : ViewModelContextImpl.this.viewModelChangeListener) {
                if (!ModelChangeAddRemoveListener.class.isInstance(modelChangeListener)) continue;
                ((ModelChangeAddRemoveListener)ModelChangeAddRemoveListener.class.cast(modelChangeListener)).notifyRemove(notifier);
            }
        }
    }
}

