/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.spreadsheet.core.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.spi.view.migrator.string.StringViewModelMigrator;
import org.eclipse.emf.ecp.spi.view.migrator.string.StringViewModelMigratorUtil;
import org.eclipse.emf.ecp.view.migrator.ViewModelMigrationException;
import org.eclipse.emf.ecp.view.migrator.ViewModelMigratorUtil;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDomainExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsExpandingFailedException;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsConverterException;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsSpreadsheetValueConverter;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsSpreadsheetValueConverterRegistry;
import org.eclipse.emfforms.spi.spreadsheet.core.error.model.ErrorFactory;
import org.eclipse.emfforms.spi.spreadsheet.core.error.model.SettingLocation;
import org.eclipse.emfforms.spi.spreadsheet.core.error.model.Severity;
import org.eclipse.emfforms.spi.spreadsheet.core.error.model.SpreadsheetImportResult;
import org.eclipse.emfforms.spi.spreadsheet.core.transfer.EMFFormsSpreadsheetImporter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class EMFFormsSpreadsheetImporterImpl
implements EMFFormsSpreadsheetImporter {
    private static final String IGNORE_SHEET = "Ignore Sheet";
    private EMFFormsDomainExpander domainExpander;

    @Override
    public SpreadsheetImportResult importSpreadsheet(Workbook workbook, EClass eClass) {
        BundleContext bundleContext = FrameworkUtil.getBundle(EMFFormsSpreadsheetImporterImpl.class).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(EMFFormsDomainExpander.class);
        this.domainExpander = (EMFFormsDomainExpander)bundleContext.getService(serviceReference);
        SpreadsheetImportResult result = this.readData(workbook, eClass);
        this.domainExpander = null;
        bundleContext.ungetService(serviceReference);
        return result;
    }

    private SpreadsheetImportResult readData(Workbook workbook, EClass eClass) {
        SpreadsheetImportResult result = ErrorFactory.eINSTANCE.createSpreadsheetImportResult();
        ResourceSetImpl rs = new ResourceSetImpl();
        MigrationInformation information = new MigrationInformation();
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), (CommandStack)new BasicCommandStack(), (ResourceSet)rs);
        rs.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)domain));
        Resource resource = rs.createResource(URI.createURI((String)"VIRTUAL_URI"));
        Map<String, Map<Integer, Integer>> mapIdToSheetIdWithRowId = this.parseIds(workbook, result);
        LinkedHashMap<String, VDomainModelReference> sheetColumnToDMRMap = new LinkedHashMap<String, VDomainModelReference>();
        LinkedHashMap<VDomainModelReference, EMFFormsSpreadsheetValueConverter> converter = new LinkedHashMap<VDomainModelReference, EMFFormsSpreadsheetValueConverter>();
        ArrayList<EObject> importedEObjects = new ArrayList<EObject>(mapIdToSheetIdWithRowId.size());
        for (String eObjectId : mapIdToSheetIdWithRowId.keySet()) {
            Map<Integer, Integer> sheetIdToRowId = mapIdToSheetIdWithRowId.get(eObjectId);
            EObject eObject = EcoreUtil.create((EClass)eClass);
            resource.getContents().add((Object)eObject);
            for (Integer sheetId : sheetIdToRowId.keySet()) {
                Sheet sheet = workbook.getSheetAt(sheetId.intValue());
                Row labelRow = sheet.getRow(0);
                Row row = sheet.getRow(sheetIdToRowId.get(sheetId).intValue());
                this.extractRowInformation(labelRow, row, eObject, result, sheet.getSheetName(), sheetId, sheetColumnToDMRMap, converter, information);
            }
            importedEObjects.add(eObject);
        }
        result.getImportedEObjects().addAll(importedEObjects);
        return result;
    }

    private void extractRowInformation(Row dmrRow, Row eObjectRow, EObject eObject, SpreadsheetImportResult errorReports, String sheetname, int sheetId, Map<String, VDomainModelReference> sheetColumnToDMRMap, Map<VDomainModelReference, EMFFormsSpreadsheetValueConverter> converterMap, MigrationInformation information) {
        int columnId = 1;
        while (columnId < dmrRow.getLastCellNum()) {
            block18: {
                VDomainModelReference dmr;
                String sheetColId = String.valueOf(sheetId) + "_" + columnId;
                Cell cell = dmrRow.getCell(columnId);
                if (!sheetColumnToDMRMap.containsKey(sheetColId)) {
                    dmr = this.getDomainModelReference(cell, errorReports, eObject, sheetname, columnId, information);
                    sheetColumnToDMRMap.put(sheetColId, dmr);
                }
                if ((dmr = sheetColumnToDMRMap.get(sheetColId)) != null) {
                    EMFFormsSpreadsheetValueConverter converter;
                    EStructuralFeature.Setting setting;
                    try {
                        this.resolveDMR(dmr, eObject);
                    }
                    catch (EMFFormsExpandingFailedException eMFFormsExpandingFailedException) {
                        errorReports.reportError(Severity.ERROR, LocalizationServiceHelper.getString(EMFFormsSpreadsheetImporterImpl.class, (String)"ImportError_DMRResolvementFailed"), ErrorFactory.eINSTANCE.createEMFLocation(eObject, ErrorFactory.eINSTANCE.createDMRLocation(dmr)), ErrorFactory.eINSTANCE.createSheetLocation(sheetname, columnId, 0, this.getStringCellValue(cell, errorReports, sheetname, columnId)));
                        break block18;
                    }
                    try {
                        setting = this.getSetting(dmr, eObject);
                    }
                    catch (DatabindingFailedException ex) {
                        errorReports.reportError(Severity.ERROR, LocalizationServiceHelper.getString(EMFFormsSpreadsheetImporterImpl.class, (String)MessageFormat.format("ImportError_DatabindingFailed", ex.getMessage())), ErrorFactory.eINSTANCE.createEMFLocation(eObject, ErrorFactory.eINSTANCE.createDMRLocation(dmr)), ErrorFactory.eINSTANCE.createSheetLocation(sheetname, columnId, 0, this.getStringCellValue(cell, errorReports, sheetname, columnId)));
                        break block18;
                    }
                    if (!converterMap.containsKey(dmr)) {
                        try {
                            converter = this.getValueConverter(dmr, eObject);
                            converterMap.put(dmr, converter);
                        }
                        catch (EMFFormsConverterException eMFFormsConverterException) {
                            errorReports.reportError(Severity.ERROR, LocalizationServiceHelper.getString(EMFFormsSpreadsheetImporterImpl.class, (String)"ImportError_NoValueConverter"), ErrorFactory.eINSTANCE.createEMFLocation(eObject, ErrorFactory.eINSTANCE.createDMRLocation(dmr)), ErrorFactory.eINSTANCE.createSheetLocation(sheetname, columnId, 0, this.getStringCellValue(cell, errorReports, sheetname, columnId)));
                            break block18;
                        }
                    }
                    converter = converterMap.get(dmr);
                    EStructuralFeature feature = setting.getEStructuralFeature();
                    Cell rowCell = feature.isUnsettable() ? eObjectRow.getCell(columnId, Row.RETURN_NULL_AND_BLANK) : eObjectRow.getCell(columnId, Row.CREATE_NULL_AS_BLANK);
                    if (rowCell == null) {
                        errorReports.getSettingToSheetMap().add((Object)ErrorFactory.eINSTANCE.createSettingToSheetMapping(this.createSettingLocation(setting), ErrorFactory.eINSTANCE.createSheetLocation(sheetname, columnId, eObjectRow.getRowNum(), this.getStringCellValue(cell, errorReports, sheetname, columnId))));
                    } else {
                        Object convertedValue;
                        try {
                            convertedValue = converter.getCellValue(rowCell, feature);
                        }
                        catch (EMFFormsConverterException ex) {
                            errorReports.reportError(Severity.ERROR, MessageFormat.format(LocalizationServiceHelper.getString(EMFFormsSpreadsheetImporterImpl.class, (String)"ImportError_ValueConversionFailed"), ex.getMessage()), ErrorFactory.eINSTANCE.createEMFLocation(eObject, this.createSettingLocation(setting), ErrorFactory.eINSTANCE.createDMRLocation(dmr)), ErrorFactory.eINSTANCE.createSheetLocation(sheetname, columnId, eObjectRow.getRowNum(), this.getStringCellValue(cell, errorReports, sheetname, columnId)));
                            break block18;
                        }
                        if (convertedValue != null && !this.checkTypes(feature, convertedValue)) {
                            errorReports.reportError(Severity.ERROR, LocalizationServiceHelper.getString(EMFFormsSpreadsheetImporterImpl.class, (String)"ImportError_InvalidType"), ErrorFactory.eINSTANCE.createEMFLocation(eObject, this.createSettingLocation(setting), ErrorFactory.eINSTANCE.createDMRLocation(dmr)), ErrorFactory.eINSTANCE.createSheetLocation(sheetname, columnId, eObjectRow.getRowNum(), this.getStringCellValue(cell, errorReports, sheetname, columnId)));
                        } else {
                            if (convertedValue == null && feature.isUnsettable()) {
                                setting.unset();
                            } else {
                                setting.set(convertedValue);
                            }
                            errorReports.getSettingToSheetMap().add((Object)ErrorFactory.eINSTANCE.createSettingToSheetMapping(this.createSettingLocation(setting), ErrorFactory.eINSTANCE.createSheetLocation(sheetname, columnId, eObjectRow.getRowNum(), this.getStringCellValue(cell, errorReports, sheetname, columnId))));
                        }
                    }
                }
            }
            ++columnId;
        }
    }

    private VDomainModelReference getDomainModelReference(Cell cell, SpreadsheetImportResult errorReports, EObject eObject, String sheetname, int columnId, MigrationInformation information) {
        if (cell == null) {
            errorReports.reportError(Severity.ERROR, LocalizationServiceHelper.getString(EMFFormsSpreadsheetImporterImpl.class, (String)"ImportError_LabelCellDeleted"), ErrorFactory.eINSTANCE.createEMFLocation(eObject), ErrorFactory.eINSTANCE.createSheetLocation(sheetname, columnId, 0, "NO CELL"));
            return null;
        }
        Comment cellComment = cell.getCellComment();
        if (cellComment == null) {
            errorReports.reportError(Severity.ERROR, LocalizationServiceHelper.getString(EMFFormsSpreadsheetImporterImpl.class, (String)"ImportError_CommentDeleted"), ErrorFactory.eINSTANCE.createEMFLocation(eObject), ErrorFactory.eINSTANCE.createSheetLocation(sheetname, columnId, 0, this.getStringCellValue(cell, errorReports, sheetname, columnId)));
            return null;
        }
        String serializedDMR = cellComment.getString().getString();
        if (serializedDMR == null || serializedDMR.isEmpty()) {
            errorReports.reportError(Severity.ERROR, LocalizationServiceHelper.getString(EMFFormsSpreadsheetImporterImpl.class, (String)"ImportError_CommentEmpty"), ErrorFactory.eINSTANCE.createEMFLocation(eObject), ErrorFactory.eINSTANCE.createSheetLocation(sheetname, columnId, 0, this.getStringCellValue(cell, errorReports, sheetname, columnId)));
            return null;
        }
        try {
            return this.deserializeDMR(serializedDMR, information);
        }
        catch (IOException iOException) {
            errorReports.reportError(Severity.ERROR, LocalizationServiceHelper.getString(EMFFormsSpreadsheetImporterImpl.class, (String)"ImportError_DMRDeserializationFailed"), ErrorFactory.eINSTANCE.createEMFLocation(eObject), ErrorFactory.eINSTANCE.createSheetLocation(sheetname, columnId, 0, this.getStringCellValue(cell, errorReports, sheetname, columnId)));
            return null;
        }
    }

    private boolean checkTypes(EStructuralFeature feature, Object convertedValue) {
        Class featureType = feature.getEType().getInstanceClass();
        if (convertedValue == null) {
            return !featureType.isPrimitive();
        }
        Class<?> valueType = convertedValue.getClass();
        if (feature.isMany() && Collection.class.isInstance(convertedValue)) {
            Collection collection = (Collection)Collection.class.cast(convertedValue);
            for (Object object : collection) {
                if (this.checkTypes(feature, object)) continue;
                return false;
            }
            return true;
        }
        if (featureType.isPrimitive() && !valueType.isPrimitive()) {
            Class<?> primitiveClass = this.getPrimitiveClass(valueType);
            if (primitiveClass == null) {
                return false;
            }
            return featureType.isAssignableFrom(primitiveClass);
        }
        if (!featureType.isPrimitive() && valueType.isPrimitive()) {
            Class<?> primitiveClass = this.getPrimitiveClass(featureType);
            if (primitiveClass == null) {
                return false;
            }
            return primitiveClass.isAssignableFrom(valueType);
        }
        return featureType.isAssignableFrom(valueType);
    }

    private Class<?> getPrimitiveClass(Class<?> clazz) {
        try {
            return (Class)clazz.getField("TYPE").get(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {}
        return null;
    }

    private SettingLocation createSettingLocation(EStructuralFeature.Setting setting) {
        return ErrorFactory.eINSTANCE.createSettingLocation(setting.getEObject(), setting.getEStructuralFeature());
    }

    private void resolveDMR(VDomainModelReference dmr, EObject eObject) throws EMFFormsExpandingFailedException {
        this.domainExpander.prepareDomainObject(dmr, eObject);
    }

    private Map<String, Map<Integer, Integer>> parseIds(Workbook workbook, SpreadsheetImportResult errorReports) {
        LinkedHashMap<String, Map<Integer, Integer>> result = new LinkedHashMap<String, Map<Integer, Integer>>();
        int sheetId = 0;
        while (sheetId < workbook.getNumberOfSheets()) {
            Sheet sheet = workbook.getSheetAt(sheetId);
            Row labelRow = sheet.getRow(0);
            if (labelRow == null) {
                errorReports.reportError(Severity.ERROR, MessageFormat.format(LocalizationServiceHelper.getString(EMFFormsSpreadsheetImporterImpl.class, (String)"ImportError_SheetEmpty"), sheet.getSheetName()), ErrorFactory.eINSTANCE.createSheetLocation(workbook.getSheetName(sheetId), 0, 0, "NO CELL"));
            } else {
                Cell idColumnLabelCell = labelRow.getCell(0, Row.CREATE_NULL_AS_BLANK);
                Comment cellComment = idColumnLabelCell.getCellComment();
                if (cellComment == null || cellComment.getString() == null || !IGNORE_SHEET.equals(cellComment.getString().getString())) {
                    String idColumnLabel = this.getStringCellValue(idColumnLabelCell, errorReports, workbook.getSheetName(sheetId), 0);
                    if (!"EOBJECT_ID".equals(idColumnLabel)) {
                        errorReports.reportError(Severity.ERROR, MessageFormat.format(LocalizationServiceHelper.getString(EMFFormsSpreadsheetImporterImpl.class, (String)"ImportError_FirstColumnWrong"), "EOBJECT_ID", idColumnLabel), ErrorFactory.eINSTANCE.createSheetLocation(workbook.getSheetName(sheetId), 0, 0, "NO CELL"));
                    } else {
                        int rowId = 3;
                        while (rowId <= sheet.getLastRowNum()) {
                            Row row = sheet.getRow(rowId);
                            if (row == null || EMFFormsSpreadsheetImporterImpl.isRowEmpty(row)) {
                                errorReports.reportError(Severity.INFO, LocalizationServiceHelper.getString(EMFFormsSpreadsheetImporterImpl.class, (String)"ImportError_EmptyRow"), ErrorFactory.eINSTANCE.createSheetLocation(workbook.getSheetName(sheetId), 0, rowId, "EOBJECT_ID"));
                            } else {
                                String eObjectId = this.getStringCellValue(row.getCell(0, Row.CREATE_NULL_AS_BLANK), errorReports, workbook.getSheetName(sheetId), 0, rowId);
                                if (eObjectId == null || eObjectId.isEmpty()) {
                                    errorReports.reportError(Severity.ERROR, LocalizationServiceHelper.getString(EMFFormsSpreadsheetImporterImpl.class, (String)"ImportError_NoEObjectID"), ErrorFactory.eINSTANCE.createSheetLocation(workbook.getSheetName(sheetId), 0, rowId, "EOBJECT_ID"));
                                } else {
                                    if (!result.containsKey(eObjectId)) {
                                        result.put(eObjectId, new LinkedHashMap());
                                    }
                                    if (((Map)result.get(eObjectId)).containsKey(sheetId)) {
                                        errorReports.reportError(Severity.ERROR, LocalizationServiceHelper.getString(EMFFormsSpreadsheetImporterImpl.class, (String)"ImportError_DuplicateEObjectID"), ErrorFactory.eINSTANCE.createSheetLocation(workbook.getSheetName(sheetId), 0, rowId, "EOBJECT_ID"));
                                    } else {
                                        ((Map)result.get(eObjectId)).put(sheetId, rowId);
                                    }
                                }
                            }
                            ++rowId;
                        }
                    }
                }
            }
            ++sheetId;
        }
        return result;
    }

    private EStructuralFeature.Setting getSetting(VDomainModelReference dmr, EObject eObject) throws DatabindingFailedException {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(EMFFormsDatabindingEMF.class);
        EMFFormsDatabindingEMF emfFormsDatabinding = (EMFFormsDatabindingEMF)bundleContext.getService(serviceReference);
        return emfFormsDatabinding.getSetting(dmr, eObject);
    }

    private EMFFormsSpreadsheetValueConverter getValueConverter(VDomainModelReference dmr, EObject eObject) throws EMFFormsConverterException {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(EMFFormsSpreadsheetValueConverterRegistry.class);
        EMFFormsSpreadsheetValueConverterRegistry emfFormsDatabinding = (EMFFormsSpreadsheetValueConverterRegistry)bundleContext.getService(serviceReference);
        return emfFormsDatabinding.getConverter(eObject, dmr);
    }

    private VDomainModelReference deserializeDMR(String serializedDMR, MigrationInformation information) throws IOException {
        if (ViewModelMigratorUtil.getStringViewModelMigrator() != null) {
            try {
                serializedDMR = this.migrateIfNeeded(serializedDMR, information);
            }
            catch (ViewModelMigrationException ex) {
                throw new IOException(ex);
            }
        }
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource resource = rs.createResource(URI.createURI((String)"VIRTAUAL_URI"));
        URIConverter.ReadableInputStream is = new URIConverter.ReadableInputStream(serializedDMR, "UTF-8");
        resource.load((InputStream)is, null);
        return (VDomainModelReference)resource.getContents().get(0);
    }

    private String migrateIfNeeded(String serializedDMR, MigrationInformation information) throws ViewModelMigrationException {
        List namespaceURIs = StringViewModelMigratorUtil.getNamespaceURIs((String)serializedDMR);
        MigrationInformation.State migrationState = information.isMigrationNeeded(namespaceURIs);
        if (migrationState == MigrationInformation.State.ok) {
            return serializedDMR;
        }
        StringViewModelMigrator migrator = ViewModelMigratorUtil.getStringViewModelMigrator();
        if (migrationState == MigrationInformation.State.unknown) {
            if (migrator.checkMigration(serializedDMR)) {
                information.noMigrationNeeded(namespaceURIs);
                return serializedDMR;
            }
            information.migrationNeeded(namespaceURIs);
        }
        return migrator.performMigration(serializedDMR);
    }

    private String getStringCellValue(Cell cell, SpreadsheetImportResult errorReports, String sheetName, int columnId) {
        return this.getStringCellValue(cell, errorReports, sheetName, columnId, 0);
    }

    private String getStringCellValue(Cell cell, SpreadsheetImportResult errorReports, String sheetName, int columnId, int rowId) {
        try {
            return cell.getStringCellValue();
        }
        catch (IllegalStateException ex) {
            errorReports.reportError(Severity.ERROR, ex.getMessage(), ErrorFactory.eINSTANCE.createEMFLocation(), ErrorFactory.eINSTANCE.createSheetLocation(sheetName, columnId, rowId, ""));
            return "";
        }
    }

    private static boolean isRowEmpty(Row row) {
        int c = row.getFirstCellNum();
        while (c < row.getLastCellNum()) {
            Cell cell = row.getCell(c);
            if (cell != null && cell.getCellType() != 3) {
                return false;
            }
            ++c;
        }
        return true;
    }

    static class MigrationInformation {
        private final Set<Set<String>> migrationNeeded = new LinkedHashSet<Set<String>>();
        private final Set<Set<String>> noMigrationNeeded = new LinkedHashSet<Set<String>>();

        MigrationInformation() {
        }

        State isMigrationNeeded(List<String> namespaceURIs) {
            LinkedHashSet<String> set = new LinkedHashSet<String>(namespaceURIs);
            if (this.noMigrationNeeded.contains(set)) {
                return State.ok;
            }
            if (this.migrationNeeded.contains(set)) {
                return State.migrate;
            }
            return State.unknown;
        }

        void migrationNeeded(List<String> namespaceURIs) {
            Set<String> set = Collections.unmodifiableSet(new LinkedHashSet<String>(namespaceURIs));
            this.migrationNeeded.add(set);
        }

        void noMigrationNeeded(List<String> namespaceURIs) {
            Set<String> set = Collections.unmodifiableSet(new LinkedHashSet<String>(namespaceURIs));
            this.noMigrationNeeded.add(set);
        }

        static enum State {
            migrate,
            ok,
            unknown;

        }
    }
}

