/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.swt.internal.reference.table;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.ui.view.swt.reference.SelectionCompositeStrategy;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewModelLoadingProperties;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emfforms.bazaar.Bid;
import org.eclipse.emfforms.bazaar.Create;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.swt.internal.reference.table.TableSelectionCompositeImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="selectionTableCompositeStrategyProvider")
public class SelectionTableCompositeStrategyProvider
implements SelectionCompositeStrategy.Provider {
    public static final String VIEW_FILTER_KEY = "selectionTableComposite";
    private static final Double BID = 1.0;
    private final Map<UniqueSetting, VTableControl> recentlyQueriedTables = new HashMap<UniqueSetting, VTableControl>();
    private EMFFormsDatabindingEMF databinding;

    @Bid
    public Double provides(EObject owner, EReference reference) {
        UniqueSetting key = UniqueSetting.createSetting((EObject)owner, (EStructuralFeature)reference);
        VTableControl table = this.getTableControl(key);
        if (table != null) {
            this.recentlyQueriedTables.put(key, table);
        }
        return table != null ? BID : null;
    }

    private VTableControl getTableControl(UniqueSetting key) {
        VTableControl result = this.recentlyQueriedTables.get(key);
        if (result == null) {
            result = this.getTableControl(key.getEObject(), key.getEStructuralFeature());
        }
        return result;
    }

    protected VTableControl getTableControl(EObject owner, EStructuralFeature feature) {
        VTableControl result = null;
        VViewModelProperties loadingProperties = this.getLoadingProperties(owner, feature);
        VView view = ViewProviderHelper.getView((EObject)owner, (VViewModelProperties)loadingProperties, Collections.singleton(VIEW_FILTER_KEY));
        if (view != null) {
            result = this.findTableControl(view, owner, feature);
        }
        return result;
    }

    protected VViewModelProperties getLoadingProperties(EObject owner, EStructuralFeature feature) {
        VViewModelLoadingProperties result = VViewFactory.eINSTANCE.createViewModelLoadingProperties();
        result.addNonInheritableProperty(VIEW_FILTER_KEY, (Object)feature.getName());
        return result;
    }

    @Create
    public SelectionCompositeStrategy create(EObject owner, EReference reference) {
        SelectionCompositeStrategy result = null;
        UniqueSetting key = UniqueSetting.createSetting((EObject)owner, (EStructuralFeature)reference);
        VTableControl table = this.getTableControl(key);
        if (table != null) {
            this.recentlyQueriedTables.remove(key);
            result = this.strategy(table);
        }
        return result;
    }

    private SelectionCompositeStrategy strategy(VTableControl table) {
        return (owner, reference, extent) -> new TableSelectionCompositeImpl(extent, table, owner, reference);
    }

    private VTableControl findTableControl(VView view, EObject owner, EStructuralFeature feature) {
        VTableControl result = null;
        TreeIterator iter = view.eAllContents();
        while (result == null && iter.hasNext()) {
            VTableControl table;
            VDomainModelReference dmr;
            EObject next = (EObject)iter.next();
            if (!(next instanceof VTableControl) || (dmr = (table = (VTableControl)next).getDomainModelReference()) == null) continue;
            if (dmr instanceof VTableDomainModelReference) {
                VTableDomainModelReference tdmr = (VTableDomainModelReference)dmr;
                if (tdmr.getDomainModelEFeature() != feature && !this.resolvesTo(tdmr.getDomainModelReference(), owner, feature)) continue;
                result = table;
                continue;
            }
            if (!this.resolvesTo(dmr, owner, feature)) continue;
            result = table;
        }
        return result;
    }

    private boolean resolvesTo(VDomainModelReference dmr, EObject owner, EStructuralFeature feature) {
        boolean result = false;
        try {
            EStructuralFeature.Setting setting = this.databinding.getSetting(dmr, owner);
            result = setting != null && setting.getEStructuralFeature() == feature;
        }
        catch (DatabindingFailedException databindingFailedException) {
            // empty catch block
        }
        return result;
    }

    @Reference(unbind="-")
    void setDatabinding(EMFFormsDatabindingEMF databinding) {
        this.databinding = databinding;
    }
}

