/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.swt.core.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.swt.core.ui.SWTValidationHelper;
import org.eclipse.emfforms.spi.swt.core.ui.SWTValidationUiService;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.osgi.service.component.annotations.Component;

@Component
public class SWTValidationUiServiceImpl
implements SWTValidationUiService {
    private final Map<Integer, Color> severityBackgroundColorMap = new HashMap<Integer, Color>();
    private final Map<Integer, Color> severityForegroundColorMap = new HashMap<Integer, Color>();
    private final Map<Integer, Image> severityIconMap = new HashMap<Integer, Image>();
    private SWTValidationHelper validationHelper = SWTValidationHelper.INSTANCE;

    public SWTValidationUiServiceImpl() {
    }

    SWTValidationUiServiceImpl(SWTValidationHelper validationHelper) {
        this.validationHelper = validationHelper;
    }

    @Override
    public Image getValidationIcon(Diagnostic diagnostic, VElement vElement, ViewModelContext viewModelContext) {
        int severity = SWTValidationUiServiceImpl.severity(diagnostic);
        if (!this.severityIconMap.containsKey(severity)) {
            Image validationIcon = this.validationHelper.getValidationIcon(severity, vElement, viewModelContext);
            this.severityIconMap.put(severity, validationIcon);
        }
        return this.severityIconMap.get(severity);
    }

    @Override
    public Image getValidationIcon(VElement vElement, ViewModelContext viewModelContext) {
        return this.getValidationIcon(SWTValidationUiServiceImpl.highestSeverityDiagnostic(vElement), vElement, viewModelContext);
    }

    @Override
    public Color getValidationForegroundColor(Diagnostic diagnostic, VElement vElement, ViewModelContext viewModelContext) {
        int severity = SWTValidationUiServiceImpl.severity(diagnostic);
        if (!this.severityForegroundColorMap.containsKey(severity)) {
            Color validationForegroundColor = this.validationHelper.getValidationForegroundColor(severity, vElement, viewModelContext);
            this.severityForegroundColorMap.put(severity, validationForegroundColor);
        }
        return this.severityForegroundColorMap.get(severity);
    }

    @Override
    public Color getValidationForegroundColor(VElement vElement, ViewModelContext viewModelContext) {
        return this.getValidationForegroundColor(SWTValidationUiServiceImpl.highestSeverityDiagnostic(vElement), vElement, viewModelContext);
    }

    @Override
    public Color getValidationBackgroundColor(Diagnostic diagnostic, VElement vElement, ViewModelContext viewModelContext) {
        int severity = SWTValidationUiServiceImpl.severity(diagnostic);
        if (!this.severityBackgroundColorMap.containsKey(severity)) {
            Color validationBackgroundColor = this.validationHelper.getValidationBackgroundColor(severity, vElement, viewModelContext);
            this.severityBackgroundColorMap.put(severity, validationBackgroundColor);
        }
        return this.severityBackgroundColorMap.get(severity);
    }

    @Override
    public Color getValidationBackgroundColor(VElement vElement, ViewModelContext viewModelContext) {
        return this.getValidationBackgroundColor(SWTValidationUiServiceImpl.highestSeverityDiagnostic(vElement), vElement, viewModelContext);
    }

    private static Diagnostic highestSeverityDiagnostic(VElement element) {
        Diagnostic mostSevere = Diagnostic.OK_INSTANCE;
        VDiagnostic vDiagnostic = element.getDiagnostic();
        if (vDiagnostic != null && vDiagnostic.getDiagnostics().size() > 0) {
            for (Object o : vDiagnostic.getDiagnostics()) {
                Diagnostic diagnostic = (Diagnostic)o;
                Diagnostic diagnostic2 = mostSevere = mostSevere.getSeverity() >= diagnostic.getSeverity() ? mostSevere : diagnostic;
            }
        }
        return mostSevere;
    }

    private static int severity(Diagnostic diagnostic) {
        return diagnostic != null ? diagnostic.getSeverity() : 0;
    }
}

