/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.editor.ecore.controls;

import java.util.ArrayList;
import javax.inject.Inject;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecp.view.model.common.AbstractGridCell;
import org.eclipse.emf.ecp.view.model.common.AbstractRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.AbstractControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class TypedElementBoundsRenderer
extends AbstractControlSWTRenderer<VControl> {
    private SWTGridDescription rendererGridDescription;

    @Inject
    public TypedElementBoundsRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
    }

    public final SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            boolean showLabel = ((VControl)this.getVElement()).getLabelAlignment() != LabelAlignment.NONE;
            int columns = showLabel ? 3 : 2;
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createEmptyGridDescription();
            this.rendererGridDescription.setRows(1);
            this.rendererGridDescription.setColumns(columns);
            ArrayList<SWTGridCell> grid = new ArrayList<SWTGridCell>();
            if (columns == 3) {
                SWTGridCell labelCell = this.createLabelCell(grid.size());
                grid.add(labelCell);
            }
            SWTGridCell validationCell = this.createValidationCell(grid.size());
            grid.add(validationCell);
            SWTGridCell controlCel = this.createControlCell(grid.size());
            grid.add(controlCel);
            this.rendererGridDescription.setGrid(grid);
        }
        return this.rendererGridDescription;
    }

    private SWTGridCell createLabelCell(int column) {
        SWTGridCell labelCell = new SWTGridCell(0, column, (AbstractSWTRenderer)this);
        labelCell.setHorizontalGrab(false);
        labelCell.setVerticalGrab(false);
        labelCell.setHorizontalFill(false);
        labelCell.setHorizontalAlignment(AbstractGridCell.Alignment.BEGINNING);
        labelCell.setVerticalFill(false);
        labelCell.setVerticalAlignment(AbstractGridCell.Alignment.CENTER);
        labelCell.setRenderer((AbstractRenderer)this);
        return labelCell;
    }

    private SWTGridCell createValidationCell(int column) {
        SWTGridCell validationCell = new SWTGridCell(0, column, (AbstractSWTRenderer)this);
        validationCell.setHorizontalGrab(false);
        validationCell.setVerticalGrab(false);
        validationCell.setHorizontalFill(false);
        validationCell.setHorizontalAlignment(AbstractGridCell.Alignment.CENTER);
        validationCell.setVerticalFill(false);
        validationCell.setVerticalAlignment(AbstractGridCell.Alignment.CENTER);
        validationCell.setRenderer((AbstractRenderer)this);
        validationCell.setPreferredSize(16, 17);
        return validationCell;
    }

    private SWTGridCell createControlCell(int column) {
        SWTGridCell controlCell = new SWTGridCell(0, column, (AbstractSWTRenderer)this);
        controlCell.setHorizontalGrab(true);
        controlCell.setVerticalGrab(false);
        controlCell.setHorizontalFill(true);
        controlCell.setVerticalFill(false);
        controlCell.setVerticalAlignment(AbstractGridCell.Alignment.CENTER);
        controlCell.setRenderer((AbstractRenderer)this);
        return controlCell;
    }

    protected final Control renderControl(SWTGridCell gridCell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        int controlIndex = gridCell.getColumn();
        if (((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.NONE) {
            ++controlIndex;
        }
        switch (controlIndex) {
            case 0: {
                return this.createBoundsLabel(parent);
            }
            case 1: {
                return this.createValidationIcon(parent);
            }
            case 2: {
                return this.createControl(parent);
            }
        }
        throw new IllegalArgumentException(String.format("The provided SWTGridCell (%1$s) cannot be used by this (%2$s) renderer.", gridCell.toString(), ((Object)((Object)this)).toString()));
    }

    private Control createBoundsLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_label");
        label.setText(this.getLocalizedString("TypedElementBoundsRenderer_Bounds"));
        return label;
    }

    private Control createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(main);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)main);
        Spinner lowerBound = new Spinner(main, 2048);
        lowerBound.setMaximum(Integer.MAX_VALUE);
        lowerBound.setLayoutData((Object)new GridData(4, -1, true, true));
        Spinner upperBound = new Spinner(main, 2048);
        upperBound.setLayoutData((Object)new GridData(4, -1, true, true));
        upperBound.setMinimum(-1);
        upperBound.setMaximum(Integer.MAX_VALUE);
        Button unbounded = new Button(main, 32);
        unbounded.setText(this.getLocalizedString("TypedElementBoundsRenderer_Unbounded"));
        this.createDataBindings(lowerBound, upperBound, unbounded);
        this.applyValidation();
        return main;
    }

    private String getLocalizedString(String string) {
        return LocalizationServiceHelper.getString(TypedElementBoundsRenderer.class, (String)string);
    }

    private void createDataBindings(final Spinner lowerBound, Spinner upperBound, Button unbounded) {
        EObject domainObject = this.getViewModelContext().getDomainModel();
        DataBindingContext dbc = this.getDataBindingContext();
        ISWTObservableValue lowerBoundSelectionTargetValue = WidgetProperties.selection().observe((Widget)lowerBound);
        IObservableValue lowerBoundModelValue = EMFEditObservables.observeValue((EditingDomain)this.getEditingDomain(domainObject), (EObject)domainObject, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_LowerBound());
        dbc.bindValue((IObservableValue)lowerBoundSelectionTargetValue, lowerBoundModelValue);
        IObservableValue upperBoundModelValue = EMFEditObservables.observeValue((EditingDomain)this.getEditingDomain(domainObject), (EObject)domainObject, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_UpperBound());
        ISWTObservableValue upperBoundSelectionTargetValue = WidgetProperties.selection().observe((Widget)upperBound);
        dbc.bindValue((IObservableValue)upperBoundSelectionTargetValue, upperBoundModelValue);
        this.bindUpperAndLowerBounds(dbc, lowerBoundModelValue, upperBoundModelValue);
        ISWTObservableValue upperBoundEnabledTargetValue = WidgetProperties.enabled().observe((Widget)upperBound);
        dbc.bindValue((IObservableValue)upperBoundEnabledTargetValue, upperBoundModelValue, null, new UpdateValueStrategy(){

            public Object convert(Object value) {
                if (!Integer.class.isInstance(value)) {
                    return null;
                }
                if ((Integer)value != -1) {
                    return true;
                }
                return false;
            }
        });
        ISWTObservableValue unboundedSelectionTargetValue = WidgetProperties.selection().observe((Widget)unbounded);
        dbc.bindValue((IObservableValue)unboundedSelectionTargetValue, upperBoundModelValue, new UpdateValueStrategy(){

            public Object convert(Object value) {
                Boolean unbounded = (Boolean)value;
                if (!unbounded.booleanValue()) {
                    return Math.max(1, lowerBound.getSelection());
                }
                return -1;
            }
        }, new UpdateValueStrategy(){

            public Object convert(Object value) {
                if (!Integer.class.isInstance(value)) {
                    return null;
                }
                if ((Integer)value == -1) {
                    return true;
                }
                return false;
            }
        });
    }

    private void bindUpperAndLowerBounds(DataBindingContext dbc, final IObservableValue lowerBoundModelValue, final IObservableValue upperBoundModelValue) {
        dbc.bindValue(upperBoundModelValue, lowerBoundModelValue, new UpdateValueStrategy(){

            public Object convert(Object value) {
                if (!Integer.class.isInstance(value)) {
                    return null;
                }
                Integer upperValue = (Integer)value;
                Integer lowerValue = (Integer)lowerBoundModelValue.getValue();
                if (upperValue < lowerValue && upperValue != -1) {
                    return upperValue;
                }
                return lowerValue;
            }

            protected IStatus doSet(IObservableValue observableValue, Object value) {
                if (observableValue.getValue().equals(value)) {
                    return Status.OK_STATUS;
                }
                return super.doSet(observableValue, value);
            }
        }, new UpdateValueStrategy(){

            public Object convert(Object value) {
                if (!Integer.class.isInstance(value)) {
                    return null;
                }
                Integer lowerValue = (Integer)value;
                Integer upperValue = (Integer)upperBoundModelValue.getValue();
                if (upperValue >= 0 && upperValue < lowerValue) {
                    return lowerValue;
                }
                return upperValue;
            }

            protected IStatus doSet(IObservableValue observableValue, Object value) {
                if (observableValue.getValue().equals(value)) {
                    return Status.OK_STATUS;
                }
                return super.doSet(observableValue, value);
            }
        });
    }

    private void setValidationColor(Control control, Color validationColor) {
        control.setBackground(validationColor);
    }

    protected final void applyValidation() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TypedElementBoundsRenderer.this.applyInnerValidation();
            }
        });
    }

    private void applyInnerValidation() {
        Control editControl;
        Label validationIcon;
        switch (this.getControls().size()) {
            case 2: {
                validationIcon = (Label)Label.class.cast(this.getControls().get(new SWTGridCell(0, 0, (AbstractSWTRenderer)this)));
                editControl = (Control)this.getControls().get(new SWTGridCell(0, 1, (AbstractSWTRenderer)this));
                break;
            }
            case 3: {
                validationIcon = (Label)Label.class.cast(this.getControls().get(new SWTGridCell(0, 1, (AbstractSWTRenderer)this)));
                editControl = (Control)this.getControls().get(new SWTGridCell(0, 2, (AbstractSWTRenderer)this));
                break;
            }
            default: {
                return;
            }
        }
        if (validationIcon == null || editControl == null) {
            return;
        }
        if (validationIcon.isDisposed()) {
            return;
        }
        if (((VControl)this.getVElement()).getDiagnostic() == null) {
            return;
        }
        validationIcon.setImage(this.getValidationIcon(((VControl)this.getVElement()).getDiagnostic().getHighestSeverity()));
        validationIcon.setToolTipText(((VControl)this.getVElement()).getDiagnostic().getMessage());
        this.setValidationColor(editControl, this.getValidationBackgroundColor(((VControl)this.getVElement()).getDiagnostic().getHighestSeverity()));
    }

    protected void rootDomainModelChanged() throws DatabindingFailedException {
    }
}

