/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.diagnostician;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EValidatorRegistryImpl;
import org.eclipse.emf.ecp.diagnostician.ECPValidator;
import org.eclipse.emf.ecp.internal.diagnostician.Activator;
import org.eclipse.emf.ecp.internal.diagnostician.ClassifierValidatorWrapper;
import org.eclipse.emf.ecp.internal.diagnostician.PackageValidatorWrapper;

public final class ECPValidatorRegistry
extends EValidatorRegistryImpl {
    public static final ECPValidatorRegistry INSTANCE = new ECPValidatorRegistry();
    private static final long serialVersionUID = -1274718490799689910L;
    private final Map<EClassifier, Set<ECPValidator>> eclassifierToAllValidatorsMap = new LinkedHashMap<EClassifier, Set<ECPValidator>>();

    private ECPValidatorRegistry() {
        Map<EPackage, Map<EClassifier, ECPValidator>> registeredValidatorsPerPackage = this.readElementsFromExtensionPoint();
        this.registerValidators(registeredValidatorsPerPackage);
    }

    private Map<EPackage, Map<EClassifier, ECPValidator>> readElementsFromExtensionPoint() {
        IConfigurationElement[] batchValidators;
        LinkedHashMap<EPackage, Map<EClassifier, ECPValidator>> registeredValidatorsPerPackage = new LinkedHashMap<EPackage, Map<EClassifier, ECPValidator>>();
        IConfigurationElement[] iConfigurationElementArray = batchValidators = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.ecp.validation.diagnostician.ecpValidators");
        int n = batchValidators.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            batchValidators = null;
            try {
                ECPValidator validator = (ECPValidator)element.createExecutableExtension("class");
                Set<EClassifier> validatedEClassifier = validator.getValidatedEClassifier();
                for (EClassifier eClassifier : validatedEClassifier) {
                    if (!this.eclassifierToAllValidatorsMap.containsKey(eClassifier)) {
                        this.eclassifierToAllValidatorsMap.put(eClassifier, new LinkedHashSet());
                    }
                    this.eclassifierToAllValidatorsMap.get(eClassifier).add(validator);
                }
                for (EClassifier classifier : this.eclassifierToAllValidatorsMap.keySet()) {
                    ECPValidator validatorToRegister = this.eclassifierToAllValidatorsMap.get(classifier).size() == 1 ? this.eclassifierToAllValidatorsMap.get(classifier).iterator().next() : new ClassifierValidatorWrapper(classifier, this.eclassifierToAllValidatorsMap.get(classifier));
                    EPackage ePackage = classifier.getEPackage();
                    if (!registeredValidatorsPerPackage.containsKey(ePackage)) {
                        registeredValidatorsPerPackage.put(ePackage, new LinkedHashMap());
                    }
                    ((Map)registeredValidatorsPerPackage.get(ePackage)).put(classifier, validatorToRegister);
                }
            }
            catch (CoreException e) {
                Activator.log(e);
            }
            ++n2;
        }
        return registeredValidatorsPerPackage;
    }

    private void registerValidators(Map<EPackage, Map<EClassifier, ECPValidator>> registeredValidatorsPerPackage) {
        for (EPackage ePackage : registeredValidatorsPerPackage.keySet()) {
            Map<EClassifier, ECPValidator> map = registeredValidatorsPerPackage.get(ePackage);
            PackageValidatorWrapper validator = new PackageValidatorWrapper(map);
            this.put(ePackage, validator);
        }
    }

    public boolean hasValidator(EClassifier classifier) {
        return this.eclassifierToAllValidatorsMap.containsKey(classifier);
    }
}

