/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.internal.ui.Activator;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.provider.IViewProvider;
import org.eclipse.emf.ecp.view.spi.provider.reporting.NoViewProviderFoundReport;
import org.eclipse.emf.ecp.view.spi.provider.reporting.ViewModelIsNullReport;
import org.eclipse.emf.ecp.view.spi.provider.reporting.ViewProviderInitFailedReport;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.osgi.framework.Bundle;

public class ViewProviderImpl {
    private static final String CLASS_CANNOT_BE_RESOLVED = "%1$s cannot be loaded because bundle %2$s cannot be resolved.";
    private static final String CLASS = "class";
    private static final String EXTENSION_POINT_ID = "org.eclipse.emf.ecp.ui.view.viewModelProviders";
    private final Set<IViewProvider> viewProviders = new LinkedHashSet<IViewProvider>();
    private final boolean shouldReadExtensionPointPerRequest;

    public ViewProviderImpl() {
        this(true);
    }

    public ViewProviderImpl(boolean shouldReadExtensionPointPerRequest) {
        this.shouldReadExtensionPointPerRequest = shouldReadExtensionPointPerRequest;
    }

    public void clearProviders() {
        this.viewProviders.clear();
    }

    public void addProvider(IViewProvider provider) {
        this.viewProviders.add(provider);
    }

    private Set<IViewProvider> getViewProviders() {
        if (this.viewProviders == null || this.viewProviders.isEmpty()) {
            this.viewProviders.addAll(ViewProviderImpl.readViewProviders());
        }
        return this.viewProviders;
    }

    private static Set<IViewProvider> readViewProviders() {
        IConfigurationElement[] controls = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        LinkedHashSet<IViewProvider> providers = new LinkedHashSet<IViewProvider>();
        IConfigurationElement[] iConfigurationElementArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                String clazz = e.getAttribute(CLASS);
                Class resolvedClass = ViewProviderImpl.loadClass(e.getContributor().getName(), clazz);
                Constructor controlConstructor = resolvedClass.getConstructor(new Class[0]);
                IViewProvider viewProvider = (IViewProvider)controlConstructor.newInstance(new Object[0]);
                providers.add(viewProvider);
            }
            catch (ClassNotFoundException ex) {
                ViewProviderImpl.report(new ViewProviderInitFailedReport(ex));
            }
            catch (NoSuchMethodException ex) {
                ViewProviderImpl.report(new ViewProviderInitFailedReport(ex));
            }
            catch (SecurityException ex) {
                ViewProviderImpl.report(new ViewProviderInitFailedReport(ex));
            }
            catch (InstantiationException ex) {
                ViewProviderImpl.report(new ViewProviderInitFailedReport(ex));
            }
            catch (IllegalAccessException ex) {
                ViewProviderImpl.report(new ViewProviderInitFailedReport(ex));
            }
            catch (IllegalArgumentException ex) {
                ViewProviderImpl.report(new ViewProviderInitFailedReport(ex));
            }
            catch (InvocationTargetException ex) {
                ViewProviderImpl.report(new ViewProviderInitFailedReport(ex));
            }
            ++n2;
        }
        return providers;
    }

    private static void report(AbstractReport reportEntity) {
        Activator.getDefault().getReportService().report(reportEntity);
    }

    private static <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.format(CLASS_CANNOT_BE_RESOLVED, clazz, bundleName));
        }
        return bundle.loadClass(clazz);
    }

    public VView getView(EObject eObject, Map<String, Object> context) {
        Set<IViewProvider> providers;
        int highestPrio = -1;
        IViewProvider selectedProvider = null;
        if (context == null) {
            context = new LinkedHashMap<String, Object>();
        }
        if ((providers = this.shouldReadExtensionPointPerRequest ? this.getViewProviders() : this.viewProviders).isEmpty()) {
            ViewProviderImpl.report(new NoViewProviderFoundReport());
        }
        for (IViewProvider viewProvider : providers) {
            int prio = viewProvider.canRender(eObject, context);
            if (prio <= highestPrio) continue;
            highestPrio = prio;
            selectedProvider = viewProvider;
        }
        if (selectedProvider != null) {
            VView view = selectedProvider.generate(eObject, context);
            if (view == null) {
                ViewProviderImpl.report(new ViewModelIsNullReport());
            }
            return view;
        }
        return null;
    }
}

