/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.categorization.swt;

import java.util.Set;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.categorization.model.VAbstractCategorization;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.model.reporting.StatusReport;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.template.model.VTStyleProperty;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.ecp.view.template.style.tab.model.VTTabStyleProperty;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererFactory;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractSWTTabRenderer<VELEMENT extends VElement>
extends AbstractSWTRenderer<VELEMENT> {
    private final EMFFormsRendererFactory emfFormsRendererFactory;
    private final EMFDataBindingContext dataBindingContext;
    private final VTViewTemplateProvider viewTemplateProvider;

    private EMFFormsRendererFactory getEMFFormsRendererFactory() {
        return this.emfFormsRendererFactory;
    }

    public AbstractSWTTabRenderer(VELEMENT vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsRendererFactory emfFormsRendererFactory, VTViewTemplateProvider viewTemplateProvider) {
        super(vElement, viewContext, reportService);
        this.emfFormsRendererFactory = emfFormsRendererFactory;
        this.viewTemplateProvider = viewTemplateProvider;
        this.dataBindingContext = new EMFDataBindingContext();
    }

    protected final VTViewTemplateProvider getViewTemplateProvider() {
        return this.viewTemplateProvider;
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        return GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        CTabFolder folder = new CTabFolder(parent, this.getTabFolderStyle());
        folder.setBackground(parent.getBackground());
        EList<VAbstractCategorization> categorizations = this.getCategorizations();
        for (VAbstractCategorization categorization : categorizations) {
            AbstractSWTRenderer renderer;
            CTabItem item = new CTabItem(folder, 0);
            ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)folder, 768);
            IObservableValue modelValue = EMFEditObservables.observeValue((EditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)categorization), (EObject)categorization, (EStructuralFeature)VViewPackage.eINSTANCE.getElement_Label());
            ISWTObservableValue targetValue = WidgetProperties.text().observe((Widget)item);
            this.dataBindingContext.bindValue((IObservableValue)targetValue, modelValue);
            try {
                renderer = this.getEMFFormsRendererFactory().getRendererInstance((VElement)categorization, this.getViewModelContext());
            }
            catch (EMFFormsNoRendererException ex) {
                this.getReportService().report((AbstractReport)new StatusReport(new Status(1, "org.eclipse.emf.ecp.view.categorization.swt", String.format("No Renderer for %s found.", new Object[]{categorization.eClass().getName(), ex}))));
                return null;
            }
            SWTGridDescription gridDescription = renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
            for (SWTGridCell gridCell : gridDescription.getGrid()) {
                Control render = renderer.render(gridCell, (Composite)scrolledComposite);
                GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(render);
                scrolledComposite.setExpandHorizontal(true);
                scrolledComposite.setExpandVertical(true);
                scrolledComposite.setContent(render);
                scrolledComposite.setMinSize(render.computeSize(-1, -1));
                item.setControl((Control)scrolledComposite);
            }
        }
        if (folder.getItemCount() > 0) {
            folder.setSelection(0);
        }
        return folder;
    }

    private int getTabFolderStyle() {
        if (this.getViewTemplateProvider() == null) {
            return this.getDefaultFolderStyle();
        }
        Set styleProperties = this.getViewTemplateProvider().getStyleProperties(this.getVElement(), this.getViewModelContext());
        for (VTStyleProperty styleProperty : styleProperties) {
            if (!VTTabStyleProperty.class.isInstance(styleProperty)) continue;
            VTTabStyleProperty style = (VTTabStyleProperty)VTTabStyleProperty.class.cast(styleProperty);
            switch (style.getType()) {
                case BOTTOM: {
                    return 1024;
                }
                case TOP: {
                    return 128;
                }
            }
            return this.getDefaultFolderStyle();
        }
        return this.getDefaultFolderStyle();
    }

    private int getDefaultFolderStyle() {
        return 1024;
    }

    protected abstract EList<VAbstractCategorization> getCategorizations();

    protected void dispose() {
        this.dataBindingContext.dispose();
        super.dispose();
    }
}

