/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.custom.model.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.view.spi.custom.model.ECPHardcodedReferences;
import org.eclipse.emf.ecp.view.spi.custom.model.VCustomDomainModelReference;
import org.eclipse.emf.ecp.view.spi.custom.model.impl.VCustomDomainModelReferenceImpl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.mappingprovider.EMFFormsMappingProvider;
import org.eclipse.emfforms.spi.core.services.mappingprovider.EMFFormsMappingProviderManager;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component
public class CustomDMRMappingProvider
implements EMFFormsMappingProvider {
    private BundleContext bundleContext;
    private ServiceReference<EMFFormsMappingProviderManager> eMFFormsMappingProviderManagerServiceReference;
    private EMFFormsMappingProviderManager mappingProviderManager;
    private ReportService reportService;

    public Set<UniqueSetting> getMappingFor(VDomainModelReference domainModelReference, EObject domainObject) {
        ECPHardcodedReferences hardcodedReference;
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (!VCustomDomainModelReference.class.isInstance(domainModelReference)) {
            throw new IllegalArgumentException("DomainModelReference must be an instance of VTableDomainModelReference.");
        }
        VCustomDomainModelReference customDomainModelReference = (VCustomDomainModelReference)VCustomDomainModelReference.class.cast(domainModelReference);
        if (!customDomainModelReference.getDomainModelReferences().isEmpty()) {
            return this.getMappingFor((Collection<VDomainModelReference>)customDomainModelReference.getDomainModelReferences(), domainObject);
        }
        try {
            hardcodedReference = CustomDMRMappingProvider.loadObject(customDomainModelReference.getBundleName(), customDomainModelReference.getClassName());
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return Collections.emptySet();
        }
        if (hardcodedReference == null) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)new DatabindingFailedException(String.format("The provided ECPHardcodedReferences from Bundle %1$s Class %2$s cannot be resolved.", customDomainModelReference.getBundleName(), customDomainModelReference.getClassName()))));
            return Collections.emptySet();
        }
        Set<VDomainModelReference> neededDomainModelReferences = hardcodedReference.getNeededDomainModelReferences();
        if (neededDomainModelReferences.isEmpty()) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)new DatabindingFailedException(String.format("The provided ECPHardcodedReferences from Bundle %1$s Class %2$s doesn't define any DomainModelReferences.", customDomainModelReference.getBundleName(), customDomainModelReference.getClassName()))));
            return Collections.emptySet();
        }
        return this.getMappingFor(neededDomainModelReferences, domainObject);
    }

    private Set<UniqueSetting> getMappingFor(Collection<VDomainModelReference> domainModelReferences, EObject domainObject) {
        LinkedHashSet<UniqueSetting> result = new LinkedHashSet<UniqueSetting>();
        for (VDomainModelReference domainModelReference : domainModelReferences) {
            Set settingsFor = this.getEMFFormsMappingProviderManager().getAllSettingsFor(domainModelReference, domainObject);
            if (settingsFor == null) continue;
            result.addAll(settingsFor);
        }
        return result;
    }

    private static ECPHardcodedReferences loadObject(String bundleName, String clazz) throws DatabindingFailedException {
        Class loadClass;
        block6: {
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle == null) {
                new ClassNotFoundException(String.format(LocalizationServiceHelper.getString(VCustomDomainModelReferenceImpl.class, (String)"BundleNotFound_ExceptionMessage"), clazz, bundleName));
                return null;
            }
            loadClass = bundle.loadClass(clazz);
            if (ECPHardcodedReferences.class.isAssignableFrom(loadClass)) break block6;
            return null;
        }
        try {
            return (ECPHardcodedReferences)ECPHardcodedReferences.class.cast(loadClass.newInstance());
        }
        catch (ClassNotFoundException ex) {
            throw new DatabindingFailedException(ex.getMessage());
        }
        catch (InstantiationException ex) {
            throw new DatabindingFailedException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new DatabindingFailedException(ex.getMessage());
        }
    }

    public double isApplicable(VDomainModelReference domainModelReference, EObject domainObject) {
        if (VCustomDomainModelReference.class.isInstance(domainModelReference)) {
            return 10.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        if (this.eMFFormsMappingProviderManagerServiceReference != null) {
            bundleContext.ungetService(this.eMFFormsMappingProviderManagerServiceReference);
            this.mappingProviderManager = null;
        }
    }

    private EMFFormsMappingProviderManager getEMFFormsMappingProviderManager() {
        if (this.mappingProviderManager == null) {
            this.eMFFormsMappingProviderManagerServiceReference = this.bundleContext.getServiceReference(EMFFormsMappingProviderManager.class);
            if (this.eMFFormsMappingProviderManagerServiceReference == null) {
                throw new IllegalStateException("No EMFFormsDomainExpander available!");
            }
            this.setEMFFormsMappingProviderManager((EMFFormsMappingProviderManager)this.bundleContext.getService(this.eMFFormsMappingProviderManagerServiceReference));
        }
        return this.mappingProviderManager;
    }

    void setEMFFormsMappingProviderManager(EMFFormsMappingProviderManager mappingProviderManager) {
        this.mappingProviderManager = mappingProviderManager;
    }

    @Reference
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }
}

