/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.delegation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edapt.common.MetamodelFactory;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.migration.Instance;
import org.eclipse.emf.edapt.migration.Metamodel;
import org.eclipse.emf.edapt.migration.Model;

@EdaptOperation(identifier="extractExistingClass", label="Fold Class", description="In the metamodel, a number of features are extracted into an existing class. More specifically, a containment reference to the extracted class is created and the features are replaced by features of the extracted class. In the model, the values of the features are moved accordingly to a new instance of the extracted class.")
public class ExtractExistingClass
extends OperationImplementation {
    @EdaptParameter(main=true, description="The features to be extracted")
    public List<EStructuralFeature> toReplace;
    @EdaptParameter(description="The extracted class")
    public EClass extractedClass;
    @EdaptParameter(description="The features of the extracted class by which they are replaced (in the same order)")
    public List<EStructuralFeature> replaceBy = new ArrayList<EStructuralFeature>();
    @EdaptParameter(description="The name of the containment reference")
    public String referenceName;

    @EdaptConstraint(restricts="replaceBy", description="The features to replace must be defined in the extracted class")
    public boolean checkReplaceBy(EStructuralFeature feature) {
        return this.extractedClass.getEAllStructuralFeatures().contains((Object)feature);
    }

    @EdaptConstraint(description="The replaced and replacing features must be of the same size")
    public boolean checkFeaturesSize() {
        return this.toReplace.size() == this.replaceBy.size();
    }

    @EdaptConstraint(description="The features must be of the same type")
    public boolean checkFeaturesSameType() {
        return this.hasSameValue(this.toReplace, this.replaceBy, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_EType());
    }

    @EdaptConstraint(description="The features must be of the same multiplicity")
    public boolean checkFeaturesSameMultiplicity() {
        return this.hasSameValue(this.toReplace, this.replaceBy, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_Many());
    }

    public void execute(Metamodel metamodel, Model model) {
        EClass contextClass = this.toReplace.get(0).getEContainingClass();
        EReference reference = MetamodelFactory.newEReference((EClass)contextClass, (String)this.referenceName, (EClass)this.extractedClass, (int)1, (int)1, (boolean)true);
        for (EStructuralFeature feature : this.toReplace) {
            metamodel.delete((EModelElement)feature);
        }
        for (Instance contextInstance : model.getAllInstances(contextClass)) {
            Instance extractedInstance = model.newInstance(this.extractedClass);
            contextInstance.set((EStructuralFeature)reference, (Object)extractedInstance);
            int i = 0;
            while (i < this.toReplace.size()) {
                Object value = contextInstance.unset(this.toReplace.get(i));
                extractedInstance.set(this.replaceBy.get(i), value);
                ++i;
            }
        }
    }
}

