/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.migration.execution;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edapt.common.LoggingUtils;
import org.eclipse.emf.edapt.common.URIUtils;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.migration.MigrationPlugin;
import org.eclipse.emf.edapt.migration.ReleaseUtils;
import org.eclipse.emf.edapt.migration.execution.BundleClassLoader;
import org.eclipse.emf.edapt.migration.execution.IClassLoader;
import org.eclipse.emf.edapt.migration.execution.Migrator;
import org.osgi.framework.Bundle;

public final class MigratorRegistry {
    private static MigratorRegistry migratorRegistry;
    private final Map<String, Migrator> migrators = new HashMap<String, Migrator>();

    private MigratorRegistry() {
        if (Platform.isRunning()) {
            this.registerExtensionMigrators();
        }
    }

    public static MigratorRegistry getInstance() {
        if (migratorRegistry == null) {
            migratorRegistry = new MigratorRegistry();
        }
        return migratorRegistry;
    }

    private void registerExtensionMigrators() {
        IConfigurationElement[] configurationElements;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = extensionRegistry.getConfigurationElementsFor("org.eclipse.emf.edapt.migrators");
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            this.registerExtensionMigrator(configurationElement);
            ++n2;
        }
    }

    private void registerExtensionMigrator(IConfigurationElement configurationElement) {
        String migrationPath = configurationElement.getAttribute("path");
        IContributor contributor = configurationElement.getContributor();
        String bundleName = contributor.getName();
        Bundle bundle = Platform.getBundle((String)bundleName);
        URI migratorURI = URI.createPlatformPluginURI((String)("/" + bundleName + "/" + migrationPath), (boolean)true);
        try {
            this.registerMigrator(migratorURI, (IClassLoader)new BundleClassLoader(bundle));
        }
        catch (MigrationException e) {
            LoggingUtils.logError((Plugin)MigrationPlugin.getPlugin(), (Throwable)e);
        }
    }

    public void registerMigrator(URL migratorURL, IClassLoader loader) throws MigrationException {
        Migrator migrator = new Migrator(URIUtils.getURI((URL)migratorURL), loader);
        for (String nsURI : migrator.getNsURIs()) {
            this.migrators.put(nsURI, migrator);
        }
    }

    public void registerMigrator(URI migratorURI, IClassLoader loader) throws MigrationException {
        this.registerMigrator(URIUtils.getURL((URI)migratorURI), loader);
    }

    public Migrator getMigrator(String nsURI) {
        return this.migrators.get(nsURI);
    }

    public Migrator getMigrator(URI modelURI) {
        String nsURI = ReleaseUtils.getNamespaceURI((URI)modelURI);
        return this.getMigrator(nsURI);
    }
}

