/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation.ui;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edapt.history.instantiation.ui.ReleaseWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class ReleaseWizard
extends Wizard {
    private final Map<EPackage, ReleaseWizardPage> pages = new LinkedHashMap<EPackage, ReleaseWizardPage>();
    private final Map<EPackage, Boolean> updateMap = new LinkedHashMap<EPackage, Boolean>();
    private final Map<EPackage, String> sourceMap = new LinkedHashMap<EPackage, String>();
    private final Map<EPackage, String> targetMap = new LinkedHashMap<EPackage, String>();
    private final List<EPackage> rootPackages;

    public ReleaseWizard(List<EPackage> rootPackages) {
        if (rootPackages == null || rootPackages.isEmpty()) {
            throw new IllegalArgumentException("There must be at least one root package.");
        }
        this.rootPackages = rootPackages;
    }

    public String getWindowTitle() {
        return "Create Release";
    }

    public void addPages() {
        for (EPackage ePackage : this.rootPackages) {
            String source = this.inferSource(ePackage);
            this.pages.put(ePackage, new ReleaseWizardPage("Update namespace URI of package " + ePackage.getNsURI(), "Enter the label to replace and the target label or deselect the update button", null, source));
            this.addPage((IWizardPage)this.pages.get(ePackage));
        }
    }

    private String inferSource(EPackage ePackage) {
        try {
            String nsURI = ePackage.getNsURI();
            int index = nsURI.lastIndexOf(47);
            return nsURI.substring(index + 1);
        }
        catch (RuntimeException runtimeException) {
            return "";
        }
    }

    public boolean updatePackage(EPackage ePackage) {
        if (!this.updateMap.containsKey(ePackage)) {
            return false;
        }
        return this.updateMap.get(ePackage);
    }

    public String getSource(EPackage ePackage) {
        return this.sourceMap.get(ePackage);
    }

    public String getTarget(EPackage ePackage) {
        return this.targetMap.get(ePackage);
    }

    public boolean performFinish() {
        for (Map.Entry<EPackage, ReleaseWizardPage> entry : this.pages.entrySet()) {
            this.updateMap.put(entry.getKey(), entry.getValue().isUpdate());
            if (!entry.getValue().isUpdate()) continue;
            this.sourceMap.put(entry.getKey(), entry.getValue().getSource());
            this.targetMap.put(entry.getKey(), entry.getValue().getTarget());
        }
        this.pages.clear();
        return true;
    }
}

