/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.edapt.common.LoggingUtils;
import org.eclipse.emf.edapt.declaration.DeclarationFactory;
import org.eclipse.emf.edapt.declaration.Library;
import org.eclipse.emf.edapt.declaration.LibraryExtractor;
import org.eclipse.emf.edapt.declaration.LibraryImplementation;
import org.eclipse.emf.edapt.declaration.Operation;
import org.eclipse.emf.edapt.declaration.OperationExtractor;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.migration.MigrationPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationRegistry {
    private static OperationRegistry instance;
    private Map<String, Operation> operations;
    private Map<Operation, List<Operation>> beforeOperations;
    private Map<Operation, List<Operation>> afterOperations;
    private Library rootLibrary;

    private OperationRegistry() {
        this.registerLibrary();
        this.initDependencies();
    }

    private void initDependencies() {
        for (Operation operation : this.getOperations()) {
            if (operation.getBefore() != null) {
                Operation before = this.getOperation(operation.getBefore());
                this.addBefore(operation, before);
            }
            if (operation.getAfter() == null) continue;
            Operation after = this.getOperation(operation.getAfter());
            this.addAfter(operation, after);
        }
    }

    public List<Operation> getBefore(Operation operation) {
        List<Operation> operations = this.beforeOperations.get(operation);
        if (operations == null) {
            return Collections.emptyList();
        }
        return operations;
    }

    private void addBefore(Operation operation, Operation before) {
        List<Operation> operations = this.beforeOperations.get(before);
        if (operations == null) {
            operations = new ArrayList<Operation>();
            this.beforeOperations.put(before, operations);
        }
        operations.add(operation);
    }

    public List<Operation> getAfter(Operation operation) {
        List<Operation> operations = this.afterOperations.get(operation);
        if (operations == null) {
            return Collections.emptyList();
        }
        return operations;
    }

    private void addAfter(Operation operation, Operation after) {
        List<Operation> operations = this.afterOperations.get(after);
        if (operations == null) {
            operations = new ArrayList<Operation>();
            this.afterOperations.put(after, operations);
        }
        operations.add(operation);
    }

    private void registerLibrary() {
        this.operations = new HashMap<String, Operation>();
        this.beforeOperations = new HashMap<Operation, List<Operation>>();
        this.afterOperations = new HashMap<Operation, List<Operation>>();
        this.rootLibrary = DeclarationFactory.eINSTANCE.createLibrary();
        this.rootLibrary.setName("root");
        this.rootLibrary.setLabel("Root library");
        this.rootLibrary.setDescription("Root library of the operation registry");
        if (Platform.isRunning()) {
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] configurationElements = extensionRegistry.getConfigurationElementsFor("org.eclipse.emf.edapt.operations");
            int i = 0;
            int n = configurationElements.length;
            while (i < n) {
                IConfigurationElement configurationElement = configurationElements[i];
                this.register(configurationElement);
                ++i;
            }
        }
    }

    private void register(IConfigurationElement configurationElement) {
        try {
            Class<?> c = configurationElement.createExecutableExtension("class").getClass();
            if ("operation".equals(configurationElement.getName())) {
                this.registerOperation(c);
            } else if ("library".equals(configurationElement.getName())) {
                this.registerLibrary(c);
            }
        }
        catch (CoreException coreException) {}
    }

    public void registerOperation(Class<? extends OperationImplementation> c) {
        Operation operation = new OperationExtractor().extractOperation(c);
        if (operation != null) {
            this.initOperation(operation);
            this.rootLibrary.getOperations().add((Object)operation);
        }
    }

    private void initOperation(Operation operation) {
        String name = operation.getName();
        if (this.operations.get(name) != null) {
            LoggingUtils.logError((Plugin)MigrationPlugin.getPlugin(), (String)("Duplicate operation name: " + name));
        }
        this.operations.put(name, operation);
    }

    public void registerLibrary(Class<? extends LibraryImplementation> c) {
        Library library = new LibraryExtractor().extractLibrary(c);
        if (library != null) {
            this.initLibrary(library);
            this.rootLibrary.getLibraries().add((Object)library);
        }
    }

    private void initLibrary(Library library) {
        for (Operation operation : library.getOperations()) {
            this.initOperation(operation);
        }
        for (Library subLibrary : library.getLibraries()) {
            this.initLibrary(subLibrary);
        }
    }

    public static OperationRegistry getInstance() {
        if (instance == null) {
            instance = new OperationRegistry();
        }
        return instance;
    }

    public Collection<Operation> getOperations() {
        return this.operations.values();
    }

    public Operation getOperation(String name) {
        return this.operations.get(name);
    }

    public List<Library> getRootLibraries() {
        return new ArrayList<Library>((Collection<Library>)this.rootLibrary.getLibraries());
    }

    public List<Operation> getRootOperations() {
        return new ArrayList<Operation>((Collection<Operation>)this.rootLibrary.getOperations());
    }
}

